/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.auth;

import javax.security.sasl.AuthenticationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;
import org.apache.livy.LivyConf;
import org.apache.livy.server.auth.LdapUtils$;
import org.apache.livy.thriftserver.auth.ldap.ChainFilter;
import org.apache.livy.thriftserver.auth.ldap.DirSearchFactory;
import org.apache.livy.thriftserver.auth.ldap.Filter;
import org.apache.livy.thriftserver.auth.ldap.LdapSearchFactory;
import org.apache.livy.thriftserver.auth.ldap.UserFilter;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u00015\u0011a\u0004\u00143ba\u0006+H\u000f[3oi&\u001c\u0017\r^5p]B\u0013xN^5eKJLU\u000e\u001d7\u000b\u0005\r!\u0011\u0001B1vi\"T!!\u0002\u0004\u0002\u0019QD'/\u001b4ug\u0016\u0014h/\u001a:\u000b\u0005\u001dA\u0011\u0001\u00027jmfT!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f-A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u0018;5\t\u0001D\u0003\u0002\u00043)\u0011!dG\u0001\bg\u0016\u0014h/[2f\u0015\ta\u0002\"\u0001\u0003iSZ,\u0017B\u0001\u0010\u0019\u0005q\u0001\u0016m]:xI\u0006+H\u000f[3oi&\u001c\u0017\r^5p]B\u0013xN^5eKJD\u0001\u0002\t\u0001\u0003\u0006\u0004%\t!I\u0001\u0005G>tg-F\u0001#!\t\u0019C%D\u0001\u0007\u0013\t)cA\u0001\u0005MSZL8i\u001c8g\u0011!9\u0003A!A!\u0002\u0013\u0011\u0013!B2p]\u001a\u0004\u0003\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\b\u0006\u0002,[A\u0011A\u0006A\u0007\u0002\u0005!)\u0001\u0005\u000ba\u0001E!9q\u0006\u0001b\u0001\n\u0013\u0001\u0014A\u00024jYR,'/F\u00012!\t\u0011T'D\u00014\u0015\t!$!\u0001\u0003mI\u0006\u0004\u0018B\u0001\u001c4\u0005\u00191\u0015\u000e\u001c;fe\"1\u0001\b\u0001Q\u0001\nE\nqAZ5mi\u0016\u0014\b\u0005C\u0004;\u0001\t\u0007I\u0011B\u001e\u0002\u001bM,\u0017M]2i\r\u0006\u001cGo\u001c:z+\u0005a\u0004C\u0001\u001a>\u0013\tq4G\u0001\tESJ\u001cV-\u0019:dQ\u001a\u000b7\r^8ss\"1\u0001\t\u0001Q\u0001\nq\nab]3be\u000eDg)Y2u_JL\b\u0005C\u0003C\u0001\u0011\u00051)\u0001\u0007BkRDWM\u001c;jG\u0006$X\rF\u0002E\u0015N\u0003\"!\u0012%\u000e\u0003\u0019S\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\u001a\u0013A!\u00168ji\")1*\u0011a\u0001\u0019\u0006!Qo]3s!\ti\u0005K\u0004\u0002F\u001d&\u0011qJR\u0001\u0007!J,G-\u001a4\n\u0005E\u0013&AB*ue&twM\u0003\u0002P\r\")A+\u0011a\u0001\u0019\u0006A\u0001/Y:to>\u0014H\rK\u0002B-\u000e\u00042!R,Z\u0013\tAfI\u0001\u0004uQJ|wo\u001d\t\u00035\u0006l\u0011a\u0017\u0006\u00039v\u000bAa]1tY*\u0011alX\u0001\tg\u0016\u001cWO]5us*\t\u0001-A\u0003kCZ\f\u00070\u0003\u0002c7\n9\u0012)\u001e;iK:$\u0018nY1uS>tW\t_2faRLwN\\\u0019\u0005=1#W0M\u0003$K&D(.\u0006\u0002gOV\tA\nB\u0003i\u0019\t\u0007QNA\u0001U\u0013\tQ7.A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0003Y\u001a\u000ba\u0001\u001e5s_^\u001c\u0018C\u00018r!\t)u.\u0003\u0002q\r\n9aj\u001c;iS:<\u0007C\u0001:v\u001d\t)5/\u0003\u0002u\r\u00069\u0001/Y2lC\u001e,\u0017B\u0001<x\u0005%!\u0006N]8xC\ndWM\u0003\u0002u\rF*1%\u001f>|Y:\u0011QI_\u0005\u0003Y\u001a\u000bDAI#Gy\n)1oY1mCF\u0012a%\u0017\u0005\u0007\u007f\u0002!I!!\u0001\u0002\u001f\r\u0014X-\u0019;f\t&\u00148+Z1sG\"$R\u0001RA\u0002\u0003\u000bAQa\u0013@A\u00021CQ\u0001\u0016@A\u00021CCA ,\u0002\nE2a\u0004TA\u0006\u0003#\tdaI3j\u0003\u001bQ\u0017GB\u0012zu\u0006=A.\r\u0003#\u000b\u001ac\u0018G\u0001\u0014Z\u0011\u001d\t)\u0002\u0001C\u0005\u0003/\t1\"\u00199qYf4\u0015\u000e\u001c;feR\u0019A)!\u0007\t\r-\u000b\u0019\u00021\u0001MQ\u0015\t\u0019BVA\u000fc\u0019qB*a\b\u0002&E21%Z5\u0002\")\fdaI={\u0003Ga\u0017\u0007\u0002\u0012F\rr\f$AJ-")
public class LdapAuthenticationProviderImpl
implements PasswdAuthenticationProvider {
    private final LivyConf conf;
    private final Filter filter;
    private final DirSearchFactory searchFactory;

    public LivyConf conf() {
        return this.conf;
    }

    private Filter filter() {
        return this.filter;
    }

    private DirSearchFactory searchFactory() {
        return this.searchFactory;
    }

    public void Authenticate(String user, String password) throws AuthenticationException {
        this.createDirSearch(user, password);
        this.applyFilter(user);
    }

    private void createDirSearch(String user, String password) throws AuthenticationException {
        if (StringUtils.isBlank((CharSequence)user) || StringUtils.isEmpty((CharSequence)user)) {
            throw new AuthenticationException("Error validating LDAP: a null or blank user name has been provided");
        }
        if (StringUtils.isBlank((CharSequence)password) || StringUtils.isEmpty((CharSequence)password)) {
            throw new AuthenticationException("Error validating LDAP: a null or blank password has been provided");
        }
        String principal = LdapUtils$.MODULE$.createCandidatePrincipal(this.conf(), user);
        try {
            this.searchFactory().getInstance(this.conf(), principal, password);
            return;
        }
        catch (AuthenticationException authenticationException) {
            throw new AuthenticationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error validating LDAP user: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user})), authenticationException);
        }
    }

    private void applyFilter(String user) throws AuthenticationException {
        if (LdapUtils$.MODULE$.hasDomain(user)) {
            this.filter().apply(LdapUtils$.MODULE$.extractUserName(user));
        } else {
            this.filter().apply(user);
        }
    }

    public LdapAuthenticationProviderImpl(LivyConf conf) {
        this.conf = conf;
        this.filter = new ChainFilter((Seq<Filter>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UserFilter[]{new UserFilter(conf)})));
        this.searchFactory = new LdapSearchFactory();
    }
}

