/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.session;

import java.util.ArrayList;
import java.util.List;
import org.apache.livy.thriftserver.session.DataType;
import org.apache.livy.thriftserver.session.SparkCatalogJob;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class GetSchemasJob
extends SparkCatalogJob {
    private final String schemaPattern;

    public GetSchemasJob(String schemaPattern, String sessionId, String jobId, DataType[] resultTypes) {
        super(sessionId, jobId, resultTypes);
        this.schemaPattern = this.convertSchemaPattern(schemaPattern);
    }

    @Override
    protected List<Row> fetchCatalogObjects(SessionCatalog catalog) {
        List databases = JavaConversions.seqAsJavaList((Seq)catalog.listDatabases(this.schemaPattern));
        ArrayList<Row> schemas = new ArrayList<Row>();
        for (String db : databases) {
            schemas.add((Row)new GenericRow(new Object[]{db, ""}));
        }
        return schemas;
    }
}

