/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.jute.Record;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.quorum.FollowerBean;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.zookeeper.server.quorum.Learner;
import org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.server.util.ZxidUtils;
import org.apache.zookeeper.txn.SetDataTxn;
import org.apache.zookeeper.txn.TxnHeader;

public class Follower
extends Learner {
    private long lastQueued;
    final FollowerZooKeeperServer fzk;

    Follower(QuorumPeer self, FollowerZooKeeperServer zk) {
        this.self = self;
        this.zk = zk;
        this.fzk = zk;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Follower ").append(this.sock);
        sb.append(" lastQueuedZxid:").append(this.lastQueued);
        sb.append(" pendingRevalidationCount:").append(this.pendingRevalidations.size());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void followLeader() throws InterruptedException {
        this.self.end_fle = Time.currentElapsedTime();
        long electionTimeTaken = this.self.end_fle - this.self.start_fle;
        this.self.setElectionTimeTaken(electionTimeTaken);
        LOG.info("FOLLOWING - LEADER ELECTION TOOK - {} {}", (Object)electionTimeTaken, (Object)"MS");
        this.self.start_fle = 0L;
        this.self.end_fle = 0L;
        this.fzk.registerJMX(new FollowerBean(this, this.zk), this.self.jmxLocalPeerBean);
        try {
            this.self.setZabState(QuorumPeer.ZabState.DISCOVERY);
            QuorumPeer.QuorumServer leaderServer = this.findLeader();
            try {
                this.connectToLeader(leaderServer.addr, leaderServer.hostname);
                long newEpochZxid = this.registerWithLeader(11);
                if (this.self.isReconfigStateChange()) {
                    throw new Exception("learned about role change");
                }
                long newEpoch = ZxidUtils.getEpochFromZxid(newEpochZxid);
                if (newEpoch < this.self.getAcceptedEpoch()) {
                    LOG.error("Proposed leader epoch " + ZxidUtils.zxidToString(newEpochZxid) + " is less than our accepted epoch " + ZxidUtils.zxidToString(this.self.getAcceptedEpoch()));
                    throw new IOException("Error: Epoch of leader is lower");
                }
                this.self.setZabState(QuorumPeer.ZabState.SYNCHRONIZATION);
                this.syncWithLeader(newEpochZxid);
                this.self.setZabState(QuorumPeer.ZabState.BROADCAST);
                QuorumPacket qp = new QuorumPacket();
                while (this.isRunning()) {
                    this.readPacket(qp);
                    this.processPacket(qp);
                }
            }
            catch (Exception e) {
                LOG.warn("Exception when following the leader", (Throwable)e);
                this.closeSocket();
                this.pendingRevalidations.clear();
            }
        }
        finally {
            this.zk.unregisterJMX(this);
        }
    }

    protected void processPacket(QuorumPacket qp) throws Exception {
        switch (qp.getType()) {
            case 5: {
                this.ping(qp);
                break;
            }
            case 2: {
                TxnHeader hdr = new TxnHeader();
                Record txn = SerializeUtils.deserializeTxn(qp.getData(), hdr);
                if (hdr.getZxid() != this.lastQueued + 1L) {
                    LOG.warn("Got zxid 0x" + Long.toHexString(hdr.getZxid()) + " expected 0x" + Long.toHexString(this.lastQueued + 1L));
                }
                this.lastQueued = hdr.getZxid();
                if (hdr.getType() == 16) {
                    SetDataTxn setDataTxn = (SetDataTxn)txn;
                    QuorumVerifier qv = this.self.configFromString(new String(setDataTxn.getData()));
                    this.self.setLastSeenQuorumVerifier(qv, true);
                }
                this.fzk.logRequest(hdr, txn);
                break;
            }
            case 4: {
                this.fzk.commit(qp.getZxid());
                break;
            }
            case 9: {
                Request request = (Request)this.fzk.pendingTxns.element();
                SetDataTxn setDataTxn = (SetDataTxn)request.getTxn();
                QuorumVerifier qv = this.self.configFromString(new String(setDataTxn.getData()));
                ByteBuffer buffer = ByteBuffer.wrap(qp.getData());
                long suggestedLeaderId = buffer.getLong();
                boolean majorChange = this.self.processReconfig(qv, suggestedLeaderId, qp.getZxid(), true);
                this.fzk.commit(qp.getZxid());
                if (!majorChange) break;
                throw new Exception("changes proposed in reconfig");
            }
            case 12: {
                LOG.error("Received an UPTODATE message after Follower started");
                break;
            }
            case 6: {
                this.revalidate(qp);
                break;
            }
            case 7: {
                this.fzk.sync();
                break;
            }
            default: {
                LOG.warn("Unknown packet type: {}", (Object)LearnerHandler.packetToString(qp));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getZxid() {
        try {
            FollowerZooKeeperServer followerZooKeeperServer = this.fzk;
            synchronized (followerZooKeeperServer) {
                return this.fzk.getZxid();
            }
        }
        catch (NullPointerException e) {
            LOG.warn("error getting zxid", (Throwable)e);
            return -1L;
        }
    }

    protected long getLastQueued() {
        return this.lastQueued;
    }

    @Override
    public void shutdown() {
        LOG.info("shutdown called", (Throwable)new Exception("shutdown Follower"));
        super.shutdown();
    }
}

