/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.EventListener;
import javax.servlet.ServletContextListener;
import org.apache.hadoop.conf.Configuration;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001\u0002\u000f\u001e\u0001\u0019B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tk\u0001\u0011\t\u0019!C\u0001m!A!\t\u0001BA\u0002\u0013\u00051\t\u0003\u0005J\u0001\t\u0005\t\u0015)\u00038\u0011!Q\u0005A!a\u0001\n\u0003Y\u0005\u0002C(\u0001\u0005\u0003\u0007I\u0011\u0001)\t\u0011I\u0003!\u0011!Q!\n1CQa\u0015\u0001\u0005\u0002QCqA\b\u0001C\u0002\u0013\u0005!\f\u0003\u0004e\u0001\u0001\u0006Ia\u0017\u0005\u000bK\u0002\u0001\n\u0011aA!\u0002\u00131\u0007bB:\u0001\u0005\u0004%\t\u0001\u001e\u0005\u0007k\u0002\u0001\u000b\u0011B5\t\u000fY\u0004!\u0019!C\u0001o\"1\u0001\u0010\u0001Q\u0001\n1Dq!\u001f\u0001C\u0002\u0013\u0005!\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0011B>\t\u0013\u0005\u0015\u0001A1A\u0005\u0002\u0005\u001d\u0001\u0002CA\u000b\u0001\u0001\u0006I!!\u0003\t\u0013\u0005]\u0001A1A\u0005\u0002\u0005e\u0001\u0002CA\u0011\u0001\u0001\u0006I!a\u0007\t\u0013\u0005\r\u0002A1A\u0005\u0002\u0005\u0015\u0002\u0002CA\u0017\u0001\u0001\u0006I!a\n\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003bBA%\u0001\u0011\u0005\u0011q\t\u0005\b\u0003\u0017\u0002A\u0011AA$\u0005%9VMY*feZ,'O\u0003\u0002\u001f?\u000511/\u001a:wKJT!\u0001I\u0011\u0002\t1Lg/\u001f\u0006\u0003E\r\na!\u00199bG\",'\"\u0001\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00019S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003]=j\u0011aH\u0005\u0003a}\u0011q\u0001T8hO&tw-\u0001\u0005mSZL8i\u001c8g!\tq3'\u0003\u00025?\tAA*\u001b<z\u0007>tg-\u0001\u0003i_N$X#A\u001c\u0011\u0005azdBA\u001d>!\tQ\u0014&D\u0001<\u0015\taT%\u0001\u0004=e>|GOP\u0005\u0003}%\na\u0001\u0015:fI\u00164\u0017B\u0001!B\u0005\u0019\u0019FO]5oO*\u0011a(K\u0001\tQ>\u001cHo\u0018\u0013fcR\u0011Ai\u0012\t\u0003Q\u0015K!AR\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b\u0011\u000e\t\t\u00111\u00018\u0003\rAH%M\u0001\u0006Q>\u001cH\u000fI\u0001\u0005a>\u0014H/F\u0001M!\tAS*\u0003\u0002OS\t\u0019\u0011J\u001c;\u0002\u0011A|'\u000f^0%KF$\"\u0001R)\t\u000f!3\u0011\u0011!a\u0001\u0019\u0006)\u0001o\u001c:uA\u00051A(\u001b8jiz\"B!V,Y3B\u0011a\u000bA\u0007\u0002;!)\u0011\u0007\u0003a\u0001e!)Q\u0007\u0003a\u0001o!)!\n\u0003a\u0001\u0019V\t1\f\u0005\u0002]E6\tQL\u0003\u0002\u001f=*\u0011q\fY\u0001\u0006U\u0016$H/\u001f\u0006\u0003C\u000e\nq!Z2mSB\u001cX-\u0003\u0002d;\n11+\u001a:wKJ\fqa]3sm\u0016\u0014\b%A\u0002yIQ\u0002B\u0001K4jY&\u0011\u0001.\u000b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005qS\u0017BA6^\u0005=\u0019VM\u001d<fe\u000e{gN\\3di>\u0014\bCA7s\u001b\u0005q'BA8q\u0003\u0011a\u0017M\\4\u000b\u0003E\fAA[1wC&\u0011\u0001I\\\u0001\nG>tg.Z2u_J,\u0012![\u0001\u000bG>tg.Z2u_J\u0004\u0013\u0001\u00039s_R|7m\u001c7\u0016\u00031\f\u0011\u0002\u001d:pi>\u001cw\u000e\u001c\u0011\u0002\u000f\r|g\u000e^3yiV\t1\u0010\u0005\u0002}\u007f6\tQP\u0003\u0002\u007f=\u000691/\u001a:wY\u0016$\u0018bAA\u0001{\n)2+\u001a:wY\u0016$8i\u001c8uKb$\b*\u00198eY\u0016\u0014\u0018\u0001C2p]R,\u0007\u0010\u001e\u0011\u0002\u0011!\fg\u000e\u001a7feN,\"!!\u0003\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004^\u0003\u001dA\u0017M\u001c3mKJLA!a\u0005\u0002\u000e\t\t\u0002*\u00198eY\u0016\u00148i\u001c7mK\u000e$\u0018n\u001c8\u0002\u0013!\fg\u000e\u001a7feN\u0004\u0013!\u0005:fcV,7\u000f\u001e'pO\"\u000bg\u000e\u001a7feV\u0011\u00111\u0004\t\u0005\u0003\u0017\ti\"\u0003\u0003\u0002 \u00055!!\u0005*fcV,7\u000f\u001e'pO\"\u000bg\u000e\u001a7fe\u0006\u0011\"/Z9vKN$Hj\\4IC:$G.\u001a:!\u0003)\u0011X-];fgRdunZ\u000b\u0003\u0003O\u00012\u0001XA\u0015\u0013\r\tY#\u0018\u0002\u000f\u001d\u000e\u001b\u0016IU3rk\u0016\u001cH\u000fT8h\u0003-\u0011X-];fgRdun\u001a\u0011\u0002!\u0005$G-\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014Hc\u0001#\u00024!9\u0011Q\u0007\rA\u0002\u0005]\u0012\u0001\u00037jgR,g.\u001a:\u0011\t\u0005e\u0012\u0011I\u0007\u0003\u0003wQ1A`A\u001f\u0015\t\ty$A\u0003kCZ\f\u00070\u0003\u0003\u0002D\u0005m\"AF*feZdW\r^\"p]R,\u0007\u0010\u001e'jgR,g.\u001a:\u0002\u000bM$\u0018M\u001d;\u0015\u0003\u0011\u000bAA[8j]\u0006!1\u000f^8q\u0001")
public class WebServer
implements Logging {
    private String host;
    private int port;
    private final Server server;
    private final /* synthetic */ Tuple2 x$4;
    private final ServerConnector connector;
    private final String protocol;
    private final ServletContextHandler context;
    private final HandlerCollection handlers;
    private final RequestLogHandler requestLogHandler;
    private final NCSARequestLog requestLog;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        WebServer webServer = this;
        synchronized (webServer) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String host() {
        return this.host;
    }

    public void host_$eq(String x$1) {
        this.host = x$1;
    }

    public int port() {
        return this.port;
    }

    public void port_$eq(int x$1) {
        this.port = x$1;
    }

    public Server server() {
        return this.server;
    }

    public ServerConnector connector() {
        return this.connector;
    }

    public String protocol() {
        return this.protocol;
    }

    public ServletContextHandler context() {
        return this.context;
    }

    public HandlerCollection handlers() {
        return this.handlers;
    }

    public RequestLogHandler requestLogHandler() {
        return this.requestLogHandler;
    }

    public NCSARequestLog requestLog() {
        return this.requestLog;
    }

    public void addEventListener(ServletContextListener listener) {
        this.context().addEventListener((EventListener)listener);
    }

    public void start() {
        this.server().start();
        NetworkConnector connector = (NetworkConnector)this.server().getConnectors()[0];
        String string = this.host();
        String string2 = "0.0.0.0";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.host_$eq(InetAddress.getLocalHost().getCanonicalHostName());
        }
        this.port_$eq(connector.getLocalPort());
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Starting server on %s://%s:%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.protocol(), this.host(), BoxesRunTime.boxToInteger((int)this.port())})));
    }

    public void join() {
        this.server().join();
    }

    public void stop() {
        this.context().stop();
        this.server().stop();
    }

    public static final /* synthetic */ boolean $anonfun$x$4$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1.trim())).nonEmpty();
    }

    public WebServer(LivyConf livyConf, String host, int port) {
        Tuple2 tuple2;
        this.host = host;
        this.port = port;
        Logging.$init$((Logging)this);
        this.server = new Server();
        this.server().setStopTimeout(1000L);
        this.server().setStopAtShutdown(true);
        Option option = Option$.MODULE$.apply((Object)livyConf.get(LivyConf$.MODULE$.SSL_KEYSTORE())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)WebServer.$anonfun$x$4$1(x$1)));
        if (None$.MODULE$.equals(option)) {
            HttpConfiguration http = new HttpConfiguration();
            http.setRequestHeaderSize(livyConf.getInt(LivyConf$.MODULE$.REQUEST_HEADER_SIZE()));
            http.setResponseHeaderSize(livyConf.getInt(LivyConf$.MODULE$.RESPONSE_HEADER_SIZE()));
            http.setSendServerVersion(livyConf.getBoolean(LivyConf$.MODULE$.SEND_SERVER_VERSION()));
            tuple2 = new Tuple2((Object)new ServerConnector(this.server(), new ConnectionFactory[]{new HttpConnectionFactory(http)}), (Object)"http");
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String keystore = (String)some.value();
            HttpConfiguration https = new HttpConfiguration();
            https.setRequestHeaderSize(livyConf.getInt(LivyConf$.MODULE$.REQUEST_HEADER_SIZE()));
            https.setResponseHeaderSize(livyConf.getInt(LivyConf$.MODULE$.RESPONSE_HEADER_SIZE()));
            https.setSendServerVersion(livyConf.getBoolean(LivyConf$.MODULE$.SEND_SERVER_VERSION()));
            https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(keystore);
            String credentialProviderPath = livyConf.get(LivyConf$.MODULE$.HADOOP_CREDENTIAL_PROVIDER_PATH());
            Configuration hadoopConf = new Configuration();
            if (credentialProviderPath != null) {
                hadoopConf.set("hadoop.security.credential.provider.path", credentialProviderPath);
            }
            Option keyStorePassword = Option$.MODULE$.apply((Object)livyConf.get(LivyConf$.MODULE$.SSL_KEYSTORE_PASSWORD())).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)hadoopConf.getPassword(LivyConf$.MODULE$.SSL_KEYSTORE_PASSWORD().key())).map((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(x$2)).mkString()));
            Option keyPassword = Option$.MODULE$.apply((Object)livyConf.get(LivyConf$.MODULE$.SSL_KEY_PASSWORD())).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)hadoopConf.getPassword(LivyConf$.MODULE$.SSL_KEY_PASSWORD().key())).map((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(x$3)).mkString()));
            keyStorePassword.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                sslContextFactory.setKeyStorePassword(x$1);
                return BoxedUnit.UNIT;
            });
            keyPassword.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                sslContextFactory.setKeyManagerPassword(x$1);
                return BoxedUnit.UNIT;
            });
            tuple2 = new Tuple2((Object)new ServerConnector(this.server(), new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https)}), (Object)"https");
        } else {
            throw new MatchError((Object)option);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        ServerConnector connector = (ServerConnector)tuple22._1();
        String protocol = (String)tuple22._2();
        this.x$4 = new Tuple2((Object)connector, (Object)protocol);
        this.connector = (ServerConnector)this.x$4._1();
        this.protocol = (String)this.x$4._2();
        this.connector().setHost(this.host());
        this.connector().setPort(this.port());
        this.server().setConnectors((Connector[])((Object[])new Connector[]{this.connector()}));
        this.context = new ServletContextHandler();
        this.context().setContextPath("/");
        this.context().addServlet(DefaultServlet.class, "/");
        this.handlers = new HandlerCollection();
        this.handlers().addHandler((Handler)this.context());
        this.requestLogHandler = new RequestLogHandler();
        this.requestLog = new NCSARequestLog(new StringBuilder(23).append((String)package$.MODULE$.env().getOrElse((Object)"LIVY_LOG_DIR", (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(5).append((String)package$.MODULE$.env().apply((Object)"LIVY_HOME")).append("/logs").toString())).append("/yyyy_mm_dd.request.log").toString());
        this.requestLog().setAppend(true);
        this.requestLog().setExtended(false);
        this.requestLog().setLogTimeZone("GMT");
        this.requestLog().setRetainDays(livyConf.getInt(LivyConf$.MODULE$.REQUEST_LOG_RETAIN_DAYS()));
        this.requestLogHandler().setRequestLog((RequestLog)this.requestLog());
        this.handlers().addHandler((Handler)this.requestLogHandler());
        this.server().setHandler((Handler)this.handlers());
    }
}

