/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.sessions;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.sessions.Session$;
import org.apache.livy.sessions.SessionState;
import org.apache.livy.utils.AppInfo;
import org.apache.livy.utils.AppInfo$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t5s!\u0002\u001b6\u0011\u0003qd!\u0002!6\u0011\u0003\t\u0005\"\u0002%\u0002\t\u0003Iea\u0002&\u0002!\u0003\r\na\u0013\u0005\b\u0019\u000e\u0011\rQ\"\u0001N\u0011\u001d\t\u0016A1A\u0005\u0002ICa!Y\u0001!\u0002\u0013\u0019\u0006\u0002\u00032\u0002\u0011\u000b\u0007I\u0011\u0001*\t\u000b\r\fA\u0011\u00013\t\u000f\u0005\r\u0011\u0001\"\u0001\u0002\u0006!9\u0011QB\u0001\u0005\u0002\u0005=aA\u0002!6\u0003\u0003\t9\u0003\u0003\u0005M\u0017\t\u0015\r\u0011\"\u0001N\u0011%\tyc\u0003B\u0001B\u0003%a\n\u0003\u0006\u00022-\u0011)\u0019!C\u0001\u0003gA!\"a\u000f\f\u0005\u0003\u0005\u000b\u0011BA\u001b\u0011)\tid\u0003BC\u0002\u0013\u0005\u0011q\b\u0005\n\u0003\u0003Z!\u0011!Q\u0001\nyC!\"a\u0011\f\u0005\u000b\u0007I\u0011AA\u001a\u0011)\t)e\u0003B\u0001B\u0003%\u0011Q\u0007\u0005\ny.\u0011)\u0019!C\u0001\u0003\u000fB\u0011\"!\u0013\f\u0005\u0003\u0005\u000b\u0011B?\t\r![A\u0011AA&\u0011\u0019A5\u0002\"\u0001\u0002Z!I\u00111M\u0006C\u0002\u0013M\u0011Q\r\u0005\t\u0003gZ\u0001\u0015!\u0003\u0002h!I\u0011QO\u0006A\u0002\u0013E\u00111\u0007\u0005\n\u0003oZ\u0001\u0019!C\t\u0003sB\u0001\"!\"\fA\u0003&\u0011Q\u0007\u0005\n\u0003\u000f[\u0001\u0019!C\u0005\u0003\u0013C\u0011\"!%\f\u0001\u0004%I!a%\t\u0011\u0005]5\u0002)Q\u0005\u0003\u0017C\u0011\"!'\f\u0001\u0004%I!a'\t\u0013\u000556\u00021A\u0005\n\u0005=\u0006\u0002CAZ\u0017\u0001\u0006K!!(\t\u000f\u0005U6\u0002\"\u0001\u00024!I\u0011qW\u0006A\u0002\u0013\u0005\u0011\u0011\u0018\u0005\n\u0003\u000f\\\u0001\u0019!C\u0001\u0003\u0013D\u0001\"!4\fA\u0003&\u00111\u0018\u0005\b\u0003\u001f\\A\u0011AAE\u0011\u001d\t\tn\u0003D\u0001\u0003'Dq!a7\f\t\u0003\ti\u000eC\u0004\u0002`.1\t!!9\t\u000f\u0005\u001d8B\"\u0001\u0002j\"9\u0011\u0011_\u0006\u0007\u0002\u0005u\u0007bBAz\u0017\u0011\u0005\u0011Q\u001f\u0005\b\u0003{\\A\u0011IA\u0000\u0011\u001d\u0011\ta\u0003D\t\u0003;D\u0011Ba\u0001\f\u0005\u00045\t!a\r\t\u000f\t\u00151\u0002\"\u0005\u0003\b!9!1F\u0006\u0005\u0012\t5\u0002b\u0002B!\u0017\u0011%!1I\u0001\b'\u0016\u001c8/[8o\u0015\t1t'\u0001\u0005tKN\u001c\u0018n\u001c8t\u0015\tA\u0014(\u0001\u0003mSZL(B\u0001\u001e<\u0003\u0019\t\u0007/Y2iK*\tA(A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002@\u00035\tQGA\u0004TKN\u001c\u0018n\u001c8\u0014\u0005\u0005\u0011\u0005CA\"G\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002}\t\u0001\"+Z2pm\u0016\u0014\u00180T3uC\u0012\fG/Y\n\u0003\u0007\t\u000b!!\u001b3\u0016\u00039\u0003\"aQ(\n\u0005A#%aA%oi\u0006Q\"\tT!D\u00172K5\u000bV0D+N#v*T0D\u0019\u0006\u001b6\u000bU!U\u0011V\t1\u000bE\u0002U7zs!!V-\u0011\u0005Y#U\"A,\u000b\u0005ak\u0014A\u0002\u001fs_>$h(\u0003\u0002[\t\u00061\u0001K]3eK\u001aL!\u0001X/\u0003\u0007M+GO\u0003\u0002[\tB\u0011AkX\u0005\u0003Av\u0013aa\u0015;sS:<\u0017a\u0007\"M\u0003\u000e[E*S*U?\u000e+6\u000bV(N?\u000ec\u0015iU*Q\u0003RC\u0005%A\bd_:4\u0017n\u001a\"mC\u000e\\G*[:u\u0003-\u0001(/\u001a9be\u0016\u001cuN\u001c4\u0015\u000f\u0015D'.^<zwB!AK\u001a0_\u0013\t9WLA\u0002NCBDQ!\u001b\u0005A\u0002\u0015\fAaY8oM\")1\u000e\u0003a\u0001Y\u0006!!.\u0019:t!\ri'O\u0018\b\u0003]Bt!AV8\n\u0003\u0015K!!\u001d#\u0002\u000fA\f7m[1hK&\u00111\u000f\u001e\u0002\u0004'\u0016\f(BA9E\u0011\u00151\b\u00021\u0001m\u0003\u00151\u0017\u000e\\3t\u0011\u0015A\b\u00021\u0001m\u0003!\t'o\u00195jm\u0016\u001c\b\"\u0002>\t\u0001\u0004a\u0017a\u00029z\r&dWm\u001d\u0005\u0006y\"\u0001\r!`\u0001\tY&4\u0018pQ8oMB\u0011ap`\u0007\u0002o%\u0019\u0011\u0011A\u001c\u0003\u00111Kg/_\"p]\u001a\f1B]3t_24X-\u0016*JgR)A.a\u0002\u0002\f!1\u0011\u0011B\u0005A\u00021\fA!\u001e:jg\")A0\u0003a\u0001{\u0006Q!/Z:pYZ,WKU%\u0015\r\u0005E\u0011\u0011EA\u0013!\u0011\t\u0019\"!\b\u000e\u0005\u0005U!\u0002BA\f\u00033\t1A\\3u\u0015\t\tY\"\u0001\u0003kCZ\f\u0017\u0002BA\u0010\u0003+\u00111!\u0016*J\u0011\u001d\t\u0019C\u0003a\u0001\u0003#\t1!\u001e:j\u0011\u0015a(\u00021\u0001~'\u0011Y!)!\u000b\u0011\u0007y\fY#C\u0002\u0002.]\u0012q\u0001T8hO&tw-A\u0002jI\u0002\nAA\\1nKV\u0011\u0011Q\u0007\t\u0005\u0007\u0006]b,C\u0002\u0002:\u0011\u0013aa\u00149uS>t\u0017!\u00028b[\u0016\u0004\u0013!B8x]\u0016\u0014X#\u00010\u0002\r=<h.\u001a:!\u0003\r!H\u000f\\\u0001\u0005iRd\u0007%F\u0001~\u0003%a\u0017N^=D_:4\u0007\u0005\u0006\u0007\u0002N\u0005=\u0013\u0011KA*\u0003+\n9\u0006\u0005\u0002@\u0017!)AJ\u0006a\u0001\u001d\"9\u0011\u0011\u0007\fA\u0002\u0005U\u0002BBA\u001f-\u0001\u0007a\fC\u0004\u0002DY\u0001\r!!\u000e\t\u000bq4\u0002\u0019A?\u0015\u0015\u00055\u00131LA/\u0003?\n\t\u0007C\u0003M/\u0001\u0007a\nC\u0004\u00022]\u0001\r!!\u000e\t\r\u0005ur\u00031\u0001_\u0011\u0015ax\u00031\u0001~\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/\u0006\u0002\u0002hA!\u0011\u0011NA8\u001b\t\tYGC\u0002\u0002n\u0011\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\t\t(a\u001b\u00031\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'/A\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002\naaX1qa&#\u0017AC0baBLEm\u0018\u0013fcR!\u00111PAA!\r\u0019\u0015QP\u0005\u0004\u0003\u007f\"%\u0001B+oSRD\u0011\"a!\u001c\u0003\u0003\u0005\r!!\u000e\u0002\u0007a$\u0013'A\u0004`CB\u0004\u0018\n\u001a\u0011\u0002\u001b}c\u0017m\u001d;BGRLg/\u001b;z+\t\tY\tE\u0002D\u0003\u001bK1!a$E\u0005\u0011auN\\4\u0002#}c\u0017m\u001d;BGRLg/\u001b;z?\u0012*\u0017\u000f\u0006\u0003\u0002|\u0005U\u0005\"CAB=\u0005\u0005\t\u0019AAF\u00039yF.Y:u\u0003\u000e$\u0018N^5us\u0002\n!b\u001d;bO&tw\rR5s+\t\ti\n\u0005\u0003\u0002 \u0006%VBAAQ\u0015\u0011\t\u0019+!*\u0002\u0005\u0019\u001c(bAATs\u00051\u0001.\u00193p_BLA!a+\u0002\"\n!\u0001+\u0019;i\u00039\u0019H/Y4j]\u001e$\u0015N]0%KF$B!a\u001f\u00022\"I\u00111Q\u0011\u0002\u0002\u0003\u0007\u0011QT\u0001\fgR\fw-\u001b8h\t&\u0014\b%A\u0003baBLE-A\u0004baBLeNZ8\u0016\u0005\u0005m\u0006\u0003BA_\u0003\u0007l!!a0\u000b\u0007\u0005\u0005w'A\u0003vi&d7/\u0003\u0003\u0002F\u0006}&aB!qa&sgm\\\u0001\fCB\u0004\u0018J\u001c4p?\u0012*\u0017\u000f\u0006\u0003\u0002|\u0005-\u0007\"CABK\u0005\u0005\t\u0019AA^\u0003!\t\u0007\u000f]%oM>\u0004\u0013\u0001\u00047bgR\f5\r^5wSRL\u0018\u0001\u00037pO2Kg.Z:\u0015\u0005\u0005U\u0007\u0003B7\u0002XzK1!!7u\u0005)Ie\u000eZ3yK\u0012\u001cV-]\u0001\u000fe\u0016\u001cwN\u001d3BGRLg/\u001b;z)\t\tY(\u0001\tsK\u000e|g/\u001a:z\u001b\u0016$\u0018\rZ1uCV\u0011\u00111\u001d\t\u0004\u0003K\u001caBA \u0001\u0003\u0015\u0019H/\u0019;f+\t\tY\u000fE\u0002@\u0003[L1!a<6\u00051\u0019Vm]:j_:\u001cF/\u0019;f\u0003\u0015\u0019H/\u0019:u\u0003\u0011\u0019Ho\u001c9\u0015\u0005\u0005]\bCBA5\u0003s\fY(\u0003\u0003\u0002|\u0006-$A\u0002$viV\u0014X-\u0001\u0005u_N#(/\u001b8h)\u0005q\u0016aC:u_B\u001cVm]:j_:\f\u0011\u0002\u001d:pqf,6/\u001a:\u0002\u0013\u0011|\u0017i](x]\u0016\u0014X\u0003\u0002B\u0005\u0005\u001f!BAa\u0003\u0003\"A!!Q\u0002B\b\u0019\u0001!qA!\u00052\u0005\u0004\u0011\u0019BA\u0001U#\u0011\u0011)Ba\u0007\u0011\u0007\r\u00139\"C\u0002\u0003\u001a\u0011\u0013qAT8uQ&tw\rE\u0002D\u0005;I1Aa\bE\u0005\r\te.\u001f\u0005\t\u0005G\tD\u00111\u0001\u0003&\u0005\u0011aM\u001c\t\u0006\u0007\n\u001d\"1B\u0005\u0004\u0005S!%\u0001\u0003\u001fcs:\fW.\u001a \u0002%\r|\u0007/\u001f*fg>,(oY3U_\"#ei\u0015\u000b\u0007\u0003#\u0011yCa\u0010\t\u000f\tE\"\u00071\u0001\u00034\u0005QA-\u0019;b'R\u0014X-Y7\u0011\t\tU\"1H\u0007\u0003\u0005oQAA!\u000f\u0002\u001a\u0005\u0011\u0011n\\\u0005\u0005\u0005{\u00119DA\u0006J]B,Ho\u0015;sK\u0006l\u0007BBA\u0019e\u0001\u0007a,A\u0007hKR\u001cF/Y4j]\u001e$\u0015N\u001d\u000b\u0005\u0003;\u0013)\u0005C\u0004\u0002$N\u0002\rAa\u0012\u0011\t\u0005}%\u0011J\u0005\u0005\u0005\u0017\n\tK\u0001\u0006GS2,7+_:uK6\u0004")
public abstract class Session
implements Logging {
    private final int id;
    private final Option<String> name;
    private final String owner;
    private final Option<String> ttl;
    private final LivyConf livyConf;
    private final ExecutionContextExecutor executionContext;
    private Option<String> _appId;
    private long _lastActivity;
    private Path stagingDir;
    private AppInfo appInfo;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static URI resolveURI(URI uRI, LivyConf livyConf) {
        return Session$.MODULE$.resolveURI(uRI, livyConf);
    }

    public static Seq<String> resolveURIs(Seq<String> seq, LivyConf livyConf) {
        return Session$.MODULE$.resolveURIs(seq, livyConf);
    }

    public static Map<String, String> prepareConf(Map<String, String> map, Seq<String> seq, Seq<String> seq2, Seq<String> seq3, Seq<String> seq4, LivyConf livyConf) {
        return Session$.MODULE$.prepareConf(map, seq, seq2, seq3, seq4, livyConf);
    }

    public static Set<String> configBlackList() {
        return Session$.MODULE$.configBlackList();
    }

    public static Set<String> BLACKLIST_CUSTOM_CLASSPATH() {
        return Session$.MODULE$.BLACKLIST_CUSTOM_CLASSPATH();
    }

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        Session session = this;
        synchronized (session) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public int id() {
        return this.id;
    }

    public Option<String> name() {
        return this.name;
    }

    public String owner() {
        return this.owner;
    }

    public Option<String> ttl() {
        return this.ttl;
    }

    public LivyConf livyConf() {
        return this.livyConf;
    }

    public ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    public Option<String> _appId() {
        return this._appId;
    }

    public void _appId_$eq(Option<String> x$1) {
        this._appId = x$1;
    }

    private long _lastActivity() {
        return this._lastActivity;
    }

    private void _lastActivity_$eq(long x$1) {
        this._lastActivity = x$1;
    }

    private Path stagingDir() {
        return this.stagingDir;
    }

    private void stagingDir_$eq(Path x$1) {
        this.stagingDir = x$1;
    }

    public Option<String> appId() {
        return this._appId();
    }

    public AppInfo appInfo() {
        return this.appInfo;
    }

    public void appInfo_$eq(AppInfo x$1) {
        this.appInfo = x$1;
    }

    public long lastActivity() {
        SessionState sessionState = this.state();
        if (sessionState instanceof SessionState.Error) {
            SessionState.Error error = (SessionState.Error)sessionState;
            long time = error.time();
            return time;
        }
        if (sessionState instanceof SessionState.Dead) {
            SessionState.Dead dead = (SessionState.Dead)sessionState;
            long time = dead.time();
            return time;
        }
        if (sessionState instanceof SessionState.Success) {
            SessionState.Success success = (SessionState.Success)sessionState;
            long time = success.time();
            return time;
        }
        return this._lastActivity();
    }

    public abstract IndexedSeq<String> logLines();

    public void recordActivity() {
        this._lastActivity_$eq(System.nanoTime());
    }

    public abstract RecoveryMetadata recoveryMetadata();

    public abstract SessionState state();

    public abstract void start();

    public Future<BoxedUnit> stop() {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Stopping ").append(this).append("...").toString());
                this.stopSession();
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Stopped ").append(this).append(".").toString());
            }
            catch (Exception e) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Error stopping session ").append(this.id()).append(".").toString(), e);
            }
            try {
                if (this.stagingDir() != null) {
                    this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Deleting session ").append(this.id()).append(" staging directory ").append(this.stagingDir()).toString());
                    this.doAsOwner((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                        boolean bl;
                        try (FileSystem fs = FileSystem.newInstance((Configuration)this.livyConf().hadoopConf());){
                            bl = fs.delete(this.stagingDir(), true);
                        }
                        return bl;
                    });
                }
            }
            catch (Exception e) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Error cleaning up session ").append(this.id()).append(" staging dir.").toString(), e);
            }
        }, (ExecutionContext)this.executionContext());
    }

    public String toString() {
        return new StringBuilder(1).append(this.getClass().getSimpleName()).append(" ").append(this.id()).toString();
    }

    public abstract void stopSession();

    public abstract Option<String> proxyUser();

    public <T> T doAsOwner(Function0<T> fn) {
        String user = (String)this.proxyUser().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.owner());
        if (user != null) {
            UserGroupInformation ugi = UserGroupInformation.isSecurityEnabled() ? (this.livyConf().getBoolean(LivyConf$.MODULE$.IMPERSONATION_ENABLED()) ? UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getCurrentUser()) : UserGroupInformation.getCurrentUser()) : UserGroupInformation.createRemoteUser((String)user);
            return (T)ugi.doAs(new PrivilegedExceptionAction<T>(null, fn){
                private final Function0 fn$1;

                public T run() {
                    return (T)this.fn$1.apply();
                }
                {
                    this.fn$1 = fn$1;
                }
            });
        }
        return (T)fn.apply();
    }

    public URI copyResourceToHDFS(InputStream dataStream, String name) {
        return (URI)this.doAsOwner((Function0 & Serializable & scala.Serializable)() -> {
            URI uRI;
            try (FileSystem fs = FileSystem.newInstance((Configuration)this.livyConf().hadoopConf());){
                Path filePath = new Path(this.getStagingDir(fs), name);
                this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Uploading user file to ").append(filePath).toString());
                FSDataOutputStream outFile = fs.create(filePath, true);
                byte[] buffer = new byte[524288];
                int read = -1;
                try {
                    while ((read = dataStream.read(buffer)) != -1) {
                        outFile.write(buffer, 0, read);
                    }
                }
                finally {
                    outFile.close();
                }
                uRI = filePath.toUri();
            }
            return uRI;
        });
    }

    private synchronized Path getStagingDir(FileSystem fs) {
        block0: {
            if (this.stagingDir() != null) break block0;
            String stagingRoot = (String)Option$.MODULE$.apply((Object)this.livyConf().get(LivyConf$.MODULE$.SESSION_STAGING_DIR())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Path(fs.getHomeDirectory(), ".livy-sessions").toString());
            Path sessionDir = new Path(stagingRoot, UUID.randomUUID().toString());
            fs.mkdirs(sessionDir);
            fs.setPermission(sessionDir, new FsPermission("700"));
            this.stagingDir_$eq(sessionDir);
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Session ").append(this.id()).append(" staging directory is ").append(this.stagingDir()).toString());
        }
        return this.stagingDir();
    }

    public static final /* synthetic */ void $anonfun$new$1(String sessionName) {
        if (new StringOps(Predef$.MODULE$.augmentString(sessionName)).forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$3)))))) {
            throw new IllegalArgumentException(new StringBuilder(22).append("Invalid session name: ").append(sessionName).toString());
        }
    }

    public Session(int id, Option<String> name, String owner, Option<String> ttl, LivyConf livyConf) {
        this.id = id;
        this.name = name;
        this.owner = owner;
        this.ttl = ttl;
        this.livyConf = livyConf;
        Logging.$init$((Logging)this);
        this.executionContext = ExecutionContext$.MODULE$.global();
        name.foreach((Function1 & Serializable & scala.Serializable)sessionName -> {
            Session.$anonfun$new$1(sessionName);
            return BoxedUnit.UNIT;
        });
        this._appId = None$.MODULE$;
        this._lastActivity = System.nanoTime();
        this.stagingDir = null;
        this.appInfo = new AppInfo(AppInfo$.MODULE$.apply$default$1(), AppInfo$.MODULE$.apply$default$2());
    }

    public Session(int id, Option<String> name, String owner, LivyConf livyConf) {
        this(id, name, owner, (Option<String>)None$.MODULE$, livyConf);
    }

    public static interface RecoveryMetadata {
        public int id();
    }
}

