/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.livy.thriftserver.LivyExecuteStatementOperation$;
import org.apache.livy.thriftserver.LivyThriftSessionManager;
import org.apache.livy.thriftserver.SessionInfo;
import org.apache.livy.thriftserver.SessionStates$;
import org.apache.livy.thriftserver.ThriftServerAudit$;
import org.apache.livy.thriftserver.operation.Operation;
import org.apache.livy.thriftserver.rpc.RpcClient;
import org.apache.livy.thriftserver.serde.ThriftResultSet;
import org.apache.livy.thriftserver.serde.ThriftResultSet$;
import org.apache.livy.thriftserver.session.ResultSet;
import org.apache.livy.thriftserver.types.BasicDataType;
import org.apache.livy.thriftserver.types.DataTypeUtils$;
import org.apache.livy.thriftserver.types.Field;
import org.apache.livy.thriftserver.types.Schema;
import org.apache.livy.thriftserver.types.Schema$;
import scala.Enumeration;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001\u0002\u000f\u001e\u0001\u0019B\u0011\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u001f\t\u0011u\u0002!\u0011!Q\u0001\nyB\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t!\u0002\u0011\t\u0011)A\u0005#\")Q\u000b\u0001C\u0001-\"9A\f\u0001b\u0001\n\u0013i\u0006B\u00025\u0001A\u0003%a\f\u0003\u0005j\u0001!\u0015\r\u0011\"\u0003k\u0011\u001d\t\b\u00011A\u0005\nIDqA\u001e\u0001A\u0002\u0013%q\u000f\u0003\u0004~\u0001\u0001\u0006Ka\u001d\u0005\u0006}\u0002!Ia \u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0011\u001d\t)\u0001\u0001C!\u0003\u000fAq!a\t\u0001\t\u0003\n)\u0003C\u0004\u0002(\u0001!\t\"!\n\t\u000f\u0005%\u0002\u0001\"\u0001\u0002&!9\u00111\u0006\u0001\u0005B\u00055\u0002bBA\u001d\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001bBq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0007\u0002h\u0001\u0001\n1!A\u0001\n\u0013\tI\u0007P\u0004\n\u0003Wj\u0012\u0011!E\u0001\u0003[2\u0001\u0002H\u000f\u0002\u0002#\u0005\u0011q\u000e\u0005\u0007+f!\t!a\u001e\t\u0013\u0005e\u0014$%A\u0005\u0002\u0005m$!\b'jmf,\u00050Z2vi\u0016\u001cF/\u0019;f[\u0016tGo\u00149fe\u0006$\u0018n\u001c8\u000b\u0005yy\u0012\u0001\u0004;ie&4Go]3sm\u0016\u0014(B\u0001\u0011\"\u0003\u0011a\u0017N^=\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0002\u0001'\r\u0001q%\f\t\u0003Q-j\u0011!\u000b\u0006\u0003Uu\t\u0011b\u001c9fe\u0006$\u0018n\u001c8\n\u00051J#!C(qKJ\fG/[8o!\tqs&D\u0001 \u0013\t\u0001tDA\u0004M_\u001e<\u0017N\\4\u0002\u001bM,7o]5p]\"\u000bg\u000e\u001a7f!\t\u0019$(D\u00015\u0015\t)d'A\u0002dY&T!a\u000e\u001d\u0002\u000fM,'O^5dK*\u0011\u0011(I\u0001\u0005Q&4X-\u0003\u0002<i\ti1+Z:tS>t\u0007*\u00198eY\u0016L!!M\u0016\u0002\u0013M$\u0018\r^3nK:$\bCA I\u001d\t\u0001e\t\u0005\u0002B\t6\t!I\u0003\u0002DK\u00051AH]8pizR\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u000ba\u0001\u0015:fI\u00164\u0017BA%K\u0005\u0019\u0019FO]5oO*\u0011q\tR\u0001\u0010eVt\u0017J\u001c\"bG.<'o\\;oIB\u0011QJT\u0007\u0002\t&\u0011q\n\u0012\u0002\b\u0005>|G.Z1o\u00039\u0019Xm]:j_:l\u0015M\\1hKJ\u0004\"AU*\u000e\u0003uI!\u0001V\u000f\u000311Kg/\u001f+ie&4GoU3tg&|g.T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0006/bK&l\u0017\t\u0003%\u0002AQ!M\u0003A\u0002IBQ!P\u0003A\u0002yBqaS\u0003\u0011\u0002\u0003\u0007A\nC\u0003Q\u000b\u0001\u0007\u0011+A\tpa\u0016\u0014\u0018\r^5p]6+7o]1hKN,\u0012A\u0018\t\u0004?\u001atT\"\u00011\u000b\u0005\u0005\u0014\u0017AC2p]\u000e,(O]3oi*\u00111\rZ\u0001\u0005kRLGNC\u0001f\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0004'!F\"p]\u000e,(O]3oi2Kgn[3e#V,W/Z\u0001\u0013_B,'/\u0019;j_:lUm]:bO\u0016\u001c\b%A\u0005sa\u000e\u001cE.[3oiV\t1\u000e\u0005\u0002m_6\tQN\u0003\u0002o;\u0005\u0019!\u000f]2\n\u0005Al'!\u0003*qG\u000ec\u0017.\u001a8u\u0003%\u0011xn^(gMN,G/F\u0001t!\tiE/\u0003\u0002v\t\n!Aj\u001c8h\u00035\u0011xn^(gMN,Go\u0018\u0013fcR\u0011\u0001p\u001f\t\u0003\u001bfL!A\u001f#\u0003\tUs\u0017\u000e\u001e\u0005\by*\t\t\u00111\u0001t\u0003\rAH%M\u0001\u000be><xJ\u001a4tKR\u0004\u0013aC:uCR,W.\u001a8u\u0013\u0012,\u0012AP\u0001\u000feB\u001c7\t\\5f]R4\u0016\r\\5e+\u0005a\u0015!D4fi:+\u0007\u0010\u001e*poN+G\u000f\u0006\u0004\u0002\n\u0005U\u0011q\u0004\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011qB\u000f\u0002\u000bM,'\u000fZ3\n\t\u0005M\u0011Q\u0002\u0002\u0010)\"\u0014\u0018N\u001a;SKN,H\u000e^*fi\"9\u0011q\u0003\bA\u0002\u0005e\u0011!B8sI\u0016\u0014\bcA\u001a\u0002\u001c%\u0019\u0011Q\u0004\u001b\u0003!\u0019+Go\u00195Pe&,g\u000e^1uS>t\u0007BBA\u0011\u001d\u0001\u00071/\u0001\u0005nCb\u0014vn^:M\u0003-\u0011XO\\%oi\u0016\u0014h.\u00197\u0015\u0003a\fq!\u001a=fGV$X-A\u0003dY>\u001cX-\u0001\u0004dC:\u001cW\r\u001c\u000b\u0004q\u0006=\u0002bBA\u0019%\u0001\u0007\u00111G\u0001\u0006gR\fG/\u001a\t\u0004g\u0005U\u0012bAA\u001ci\tqq\n]3sCRLwN\\*uCR,\u0017AD:i_VdGMU;o\u0003NLhnY\u0001\u0013O\u0016$(+Z:vYR\u001cV\r^*dQ\u0016l\u0017-\u0006\u0002\u0002@A!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002Fu\tQ\u0001^=qKNLA!!\u0013\u0002D\t11k\u00195f[\u0006\fqa\u00197fC:,\b\u000fF\u0002y\u0003\u001fBq!!\r\u0016\u0001\u0004\t\u0019$\u0001\u000bhKR|\u0005/\u001a:bi&|g.T3tg\u0006<Wm]\u000b\u0003\u0003+\u0002R!a\u0016\u0002byrA!!\u0017\u0002^9\u0019\u0011)a\u0017\n\u0003\u0015K1!a\u0018E\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0019\u0002f\t\u00191+Z9\u000b\u0007\u0005}C)A\ntkB,'\u000fJ:fgNLwN\u001c%b]\u0012dW-F\u00013\u0003ua\u0015N^=Fq\u0016\u001cW\u000f^3Ti\u0006$X-\\3oi>\u0003XM]1uS>t\u0007C\u0001*\u001a'\rI\u0012\u0011\u000f\t\u0004\u001b\u0006M\u0014bAA;\t\n1\u0011I\\=SK\u001a$\"!!\u001c\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tiHK\u0002M\u0003\u007fZ#!!!\u0011\t\u0005\r\u0015QR\u0007\u0003\u0003\u000bSA!a\"\u0002\n\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0017#\u0015AC1o]>$\u0018\r^5p]&!\u0011qRAC\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class LivyExecuteStatementOperation
extends Operation {
    private RpcClient rpcClient;
    private final String statement;
    private final boolean runInBackground;
    private final LivyThriftSessionManager sessionManager;
    private final ConcurrentLinkedQueue<String> operationMessages;
    private long rowOffset;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return LivyExecuteStatementOperation$.MODULE$.$lessinit$greater$default$3();
    }

    private /* synthetic */ SessionHandle super$sessionHandle() {
        return super.sessionHandle();
    }

    private ConcurrentLinkedQueue<String> operationMessages() {
        return this.operationMessages;
    }

    private RpcClient rpcClient$lzycompute() {
        LivyExecuteStatementOperation livyExecuteStatementOperation = this;
        synchronized (livyExecuteStatementOperation) {
            if (!this.bitmap$0) {
                Enumeration.Value sessionState;
                Enumeration.Value value = sessionState = this.sessionManager.livySessionState(super.sessionHandle());
                Enumeration.Value value2 = SessionStates$.MODULE$.CREATION_IN_PROGRESS();
                Object object = !(value != null ? !value.equals(value2) : value2 != null) ? BoxesRunTime.boxToBoolean((boolean)this.operationMessages().offer("Livy session has not yet started. Please wait for it to be ready...")) : BoxedUnit.UNIT;
                this.rpcClient = new RpcClient(this.sessionManager.getLivySession(super.sessionHandle()));
                this.bitmap$0 = true;
            }
        }
        return this.rpcClient;
    }

    private RpcClient rpcClient() {
        if (!this.bitmap$0) {
            return this.rpcClient$lzycompute();
        }
        return this.rpcClient;
    }

    private long rowOffset() {
        return this.rowOffset;
    }

    private void rowOffset_$eq(long x$1) {
        this.rowOffset = x$1;
    }

    private String statementId() {
        return this.opHandle().getHandleIdentifier().toString();
    }

    private boolean rpcClientValid() {
        Enumeration.Value value = this.sessionManager.livySessionState(super.sessionHandle());
        Enumeration.Value value2 = SessionStates$.MODULE$.CREATION_SUCCESS();
        return !(value != null ? !value.equals(value2) : value2 != null) && this.rpcClient().isValid();
    }

    @Override
    public ThriftResultSet getNextRowSet(FetchOrientation order, long maxRowsL) {
        this.validateFetchOrientation(order);
        this.assertState((Seq<OperationState>)((Seq)new .colon.colon((Object)OperationState.FINISHED, (List)Nil$.MODULE$)));
        this.setHasResultSet(true);
        int maxRows = (int)maxRowsL;
        ResultSet resultSet = (ResultSet)this.rpcClient().fetchResult(super.sessionHandle(), this.statementId(), maxRows).get();
        ThriftResultSet livyColumnResultSet = ThriftResultSet$.MODULE$.apply(resultSet);
        livyColumnResultSet.setRowOffset(this.rowOffset());
        this.rowOffset_$eq(this.rowOffset() + (long)livyColumnResultSet.numRows());
        return livyColumnResultSet;
    }

    @Override
    public void runInternal() {
        this.setState(OperationState.PENDING);
        this.setHasResultSet(true);
        if (!this.runInBackground) {
            this.execute();
            return;
        }
        UserGroupInformation livyServiceUGI = UserGroupInformation.getCurrentUser();
        Runnable backgroundOperation = new Runnable(this, livyServiceUGI){
            private final /* synthetic */ LivyExecuteStatementOperation $outer;
            private final UserGroupInformation livyServiceUGI$1;

            public void run() {
                PrivilegedExceptionAction<BoxedUnit> doAsAction = new PrivilegedExceptionAction<BoxedUnit>(this){
                    private final /* synthetic */ $anon$1 $outer;

                    public void run() {
                        try {
                            this.$outer.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$anon$$$outer().execute();
                        }
                        catch (HiveSQLException e) {
                            this.$outer.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$anon$$$outer().setOperationException(e);
                            this.$outer.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$anon$$$outer().error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error running hive query: ", e);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1()}, serializedLambda);
                    }
                };
                try {
                    this.livyServiceUGI$1.doAs((PrivilegedExceptionAction)doAsAction);
                }
                catch (Exception e) {
                    this.$outer.setOperationException(new HiveSQLException((Throwable)e));
                    this.$outer.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Error running hive query as user : ").append($this.livyServiceUGI$1.getShortUserName()).toString(), e);
                }
            }

            public /* synthetic */ LivyExecuteStatementOperation org$apache$livy$thriftserver$LivyExecuteStatementOperation$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.livyServiceUGI$1 = livyServiceUGI$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$2(org.apache.livy.thriftserver.LivyExecuteStatementOperation$$anon$1 )}, serializedLambda);
            }
        };
        try {
            Future<?> backgroundHandle = this.sessionManager.submitBackgroundOperation(backgroundOperation);
            this.setBackgroundHandle(backgroundHandle);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof RejectedExecutionException) {
                RejectedExecutionException rejectedExecutionException = (RejectedExecutionException)throwable2;
                this.setState(OperationState.ERROR);
                throw new HiveSQLException("The background threadpool cannot accept new task for execution, please retry the operation", (Throwable)rejectedExecutionException);
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error executing query in background", e);
                this.setState(OperationState.ERROR);
                throw e;
            }
            throw throwable;
        }
    }

    public void execute() {
        if (this.logger().isDebugEnabled()) {
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Running query '").append($this.statement).append("' with id ").append(this.statementId()).append(" (session = ").append(this.super$sessionHandle().getSessionId()).append(")").toString());
        }
        this.setState(OperationState.RUNNING);
        long before = System.currentTimeMillis();
        try {
            this.rpcClient().executeSql(super.sessionHandle(), this.statementId(), this.statement).get();
        }
        catch (Throwable e) {
            OperationState currentState = this.getStatus().state();
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)new StringBuilder(38).append("Error executing query, currentState ").append(currentState).append(", ").toString(), (Object)e));
            this.setState(OperationState.ERROR);
            throw new HiveSQLException(e);
        }
        this.setState(OperationState.FINISHED);
        SessionInfo sessionInfo = this.sessionManager.getSessionInfo(super.sessionHandle());
        long after = System.currentTimeMillis();
        ThriftServerAudit$.MODULE$.audit(sessionInfo.username(), sessionInfo.ipAddress(), this.statement, before, after);
    }

    @Override
    public void close() {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(6).append("Close ").append(this.statementId()).toString());
        this.cleanup(OperationState.CLOSED);
    }

    @Override
    public void cancel(OperationState state) {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Cancel ").append(this.statementId()).append(" with state ").append(state).toString());
        this.cleanup(state);
    }

    @Override
    public boolean shouldRunAsync() {
        return this.runInBackground;
    }

    @Override
    public Schema getResultSetSchema() {
        Schema tableSchema = DataTypeUtils$.MODULE$.schemaFromSparkJson((String)this.rpcClient().fetchResultSchema(super.sessionHandle(), this.statementId()).get());
        if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableSchema.fields())).isEmpty()) {
            return tableSchema;
        }
        return Schema$.MODULE$.apply((Seq<Field>)Predef$.MODULE$.wrapRefArray((Object[])new Field[]{new Field("Result", new BasicDataType("string"), "")}));
    }

    private void cleanup(OperationState state) {
        Boolean cleaned;
        if (this.statementId() != null && this.rpcClientValid() && !Predef$.MODULE$.Boolean2boolean(cleaned = (Boolean)this.rpcClient().cleanupStatement(super.sessionHandle(), this.statementId(), this.rpcClient().cleanupStatement$default$3()).get())) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Fail to cleanup query ").append(this.statementId()).append(" (session = ").append(this.super$sessionHandle().getSessionId()).append("), ").append("this message can be ignored if the query failed.").toString());
        }
        this.setState(state);
    }

    public Seq<String> getOperationMessages() {
        ListBuffer res = new ListBuffer();
        while (this.fetchNext$1(res)) {
        }
        return res;
    }

    private final boolean fetchNext$1(ListBuffer acc) {
        String m = this.operationMessages().poll();
        if (m == null) {
            return false;
        }
        acc.$plus$eq((Object)m);
        return true;
    }

    public LivyExecuteStatementOperation(SessionHandle sessionHandle, String statement, boolean runInBackground, LivyThriftSessionManager sessionManager) {
        this.statement = statement;
        this.runInBackground = runInBackground;
        this.sessionManager = sessionManager;
        super(sessionHandle, OperationType.EXECUTE_STATEMENT);
        this.operationMessages = new ConcurrentLinkedQueue();
        this.rowOffset = 0L;
    }
}

