/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver;

import java.io.Serializable;
import java.util.Map;
import org.apache.livy.Logging;
import org.apache.livy.server.interactive.CreateInteractiveRequest;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class LivyThriftSessionManager$
implements Logging {
    public static LivyThriftSessionManager$ MODULE$;
    private final String livySessionIdConfigKey;
    private final Regex livySessionConfRegexp;
    private final Regex hiveVarPattern;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new LivyThriftSessionManager$();
    }

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        LivyThriftSessionManager$ livyThriftSessionManager$ = this;
        synchronized (livyThriftSessionManager$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private String livySessionIdConfigKey() {
        return this.livySessionIdConfigKey;
    }

    private Regex livySessionConfRegexp() {
        return this.livySessionConfRegexp;
    }

    private Regex hiveVarPattern() {
        return this.hiveVarPattern;
    }

    private Option<Object> convertConfValueToInt(String key, String value) {
        Try res = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(value)).toInt());
        if (res.isFailure()) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Ignoring ").append(key).append(" = ").append(value).append(" as it is not a valid integer").toString());
            return None$.MODULE$;
        }
        return new Some(res.get());
    }

    public Tuple3<List<String>, CreateInteractiveRequest, Option<Object>> org$apache$livy$thriftserver$LivyThriftSessionManager$$processSessionConf(Map<String, String> sessionConf, boolean supportUseDatabase) {
        if (sessionConf != null && !sessionConf.isEmpty()) {
            ListBuffer statements = new ListBuffer();
            ListBuffer extraLivyConf = new ListBuffer();
            CreateInteractiveRequest createInteractiveRequest = new CreateInteractiveRequest();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(sessionConf).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    String string = key;
                    if (string.startsWith("use:") && supportUseDatabase) {
                        return statements.$plus$eq((Object)new StringBuilder(4).append("use ").append(value).toString());
                    }
                    if ("set:hiveconf:livy.session.driverMemory".equals(string)) {
                        createInteractiveRequest.driverMemory_$eq((Option)new Some((Object)value));
                        return BoxedUnit.UNIT;
                    }
                    if ("set:hiveconf:livy.session.driverCores".equals(string)) {
                        createInteractiveRequest.driverCores_$eq(MODULE$.convertConfValueToInt(key, value));
                        return BoxedUnit.UNIT;
                    }
                    if ("set:hiveconf:livy.session.executorMemory".equals(string)) {
                        createInteractiveRequest.executorMemory_$eq((Option)new Some((Object)value));
                        return BoxedUnit.UNIT;
                    }
                    if ("set:hiveconf:livy.session.executorCores".equals(string)) {
                        createInteractiveRequest.executorCores_$eq(MODULE$.convertConfValueToInt(key, value));
                        return BoxedUnit.UNIT;
                    }
                    if ("set:hiveconf:livy.session.numExecutors".equals(string)) {
                        createInteractiveRequest.numExecutors_$eq(MODULE$.convertConfValueToInt(key, value));
                        return BoxedUnit.UNIT;
                    }
                    if ("set:hiveconf:livy.session.queue".equals(string)) {
                        createInteractiveRequest.queue_$eq((Option)new Some((Object)value));
                        return BoxedUnit.UNIT;
                    }
                    if ("set:hiveconf:livy.session.name".equals(string)) {
                        createInteractiveRequest.name_$eq((Option)new Some((Object)value));
                        return BoxedUnit.UNIT;
                    }
                    if ("set:hiveconf:livy.session.heartbeatTimeoutInSecond".equals(string)) {
                        MODULE$.convertConfValueToInt(key, value).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)heartbeatTimeoutInSecond -> createInteractiveRequest.heartbeatTimeoutInSecond_$eq(heartbeatTimeoutInSecond));
                        return BoxedUnit.UNIT;
                    }
                    Option option = MODULE$.livySessionConfRegexp().unapplySeq((CharSequence)string);
                    if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                        String livyConfKey = (String)((LinearSeqOptimized)option.get()).apply(0);
                        return extraLivyConf.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)livyConfKey), (Object)value));
                    }
                    Option option2 = MODULE$.hiveVarPattern().unapplySeq((CharSequence)string);
                    if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                        String confKey = (String)((LinearSeqOptimized)option2.get()).apply(0);
                        return statements.$plus$eq((Object)new StringBuilder(13).append("set hivevar:").append(confKey.trim()).append("=").append(value).toString());
                    }
                    String string2 = key;
                    String string3 = MODULE$.livySessionIdConfigKey();
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        return BoxedUnit.UNIT;
                    }
                    MODULE$.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Ignoring key: ").append(key).append(" = '").append(value).append("'").toString());
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)tuple2);
            });
            createInteractiveRequest.conf_$eq(extraLivyConf.toMap(Predef$.MODULE$.$conforms()));
            Option sessionId = Option$.MODULE$.apply((Object)sessionConf.get(this.livySessionIdConfigKey())).flatMap((Function1 & Serializable & scala.Serializable)id -> {
                Try res = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(id)).toInt());
                if (res.isFailure()) {
                    MODULE$.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Ignoring ").append(MODULE$.livySessionIdConfigKey()).append("=").append((String)id).append(" as it is not an int.").toString());
                    return None$.MODULE$;
                }
                return new Some(res.get());
            });
            return new Tuple3((Object)statements.toList(), (Object)createInteractiveRequest, (Object)sessionId);
        }
        return new Tuple3((Object)Nil$.MODULE$, (Object)new CreateInteractiveRequest(), (Object)None$.MODULE$);
    }

    private LivyThriftSessionManager$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.livySessionIdConfigKey = "set:hiveconf:livy.server.sessionId";
        this.livySessionConfRegexp = new StringOps(Predef$.MODULE$.augmentString("set:hiveconf:livy.session.conf.(.*)")).r();
        this.hiveVarPattern = new StringOps(Predef$.MODULE$.augmentString("set:hivevar:(.*)")).r();
    }
}

