/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver;

import org.apache.hive.service.ServiceException;
import org.apache.livy.LivyConf;
import org.apache.livy.Logging;
import org.apache.livy.thriftserver.STATE$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001\u0002\r\u001a\u0001\tB\u0001\"\f\u0001\u0003\u0006\u0004%\tA\f\u0005\tu\u0001\u0011\t\u0011)A\u0005_!)1\b\u0001C\u0001y!9\u0001\t\u0001b\u0001\n\u0013\t\u0005B\u0002&\u0001A\u0003%!\tC\u0004L\u0001\u0001\u0007I\u0011\u0002'\t\u000fU\u0003\u0001\u0019!C\u0005-\"1A\f\u0001Q!\n5Cq!\u0018\u0001A\u0002\u0013%a\fC\u0004c\u0001\u0001\u0007I\u0011B2\t\r\u0015\u0004\u0001\u0015)\u0003`\u0011\u00151\u0007\u0001\"\u0001h\u0011\u0015\t\b\u0001\"\u0005s\u0011\u0015)\b\u0001\"\u0005w\u0011\u0015A\b\u0001\"\u0001z\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!9\u00111\u0001\u0001\u0005\u0002\u0005\u0005\u0001bBA\u0002\u0001\u0011%\u0011Q\u0001\u0005\u0007\u0003#\u0001A\u0011\u0001'\t\r\u0005M\u0001\u0001\"\u0001/\u0011\u0019\t)\u0002\u0001C\u0001=\"9\u0011q\u0003\u0001\u0005\n\u0005e\u0001bBA\u0010\u0001\u0011%\u0011\u0011\u0005\u0002\u000e)\"\u0014\u0018N\u001a;TKJ4\u0018nY3\u000b\u0005iY\u0012\u0001\u0004;ie&4Go]3sm\u0016\u0014(B\u0001\u000f\u001e\u0003\u0011a\u0017N^=\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0002\u0001'\r\u00011%\u000b\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005)ZS\"A\u000e\n\u00051Z\"a\u0002'pO\u001eLgnZ\u0001\u0005]\u0006lW-F\u00010!\t\u0001tG\u0004\u00022kA\u0011!'J\u0007\u0002g)\u0011A'I\u0001\u0007yI|w\u000e\u001e \n\u0005Y*\u0013A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!AN\u0013\u0002\u000b9\fW.\u001a\u0011\u0002\rqJg.\u001b;?)\tit\b\u0005\u0002?\u00015\t\u0011\u0004C\u0003.\u0007\u0001\u0007q&A\u0006tKJ4\u0018nY3MSN$X#\u0001\"\u0011\u0007\rCU(D\u0001E\u0015\t)e)A\u0004nkR\f'\r\\3\u000b\u0005\u001d+\u0013AC2pY2,7\r^5p]&\u0011\u0011\n\u0012\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\u0018\u0001D:feZL7-\u001a'jgR\u0004\u0013!B:uCR,W#A'\u0011\u00059\u000bfB\u0001 P\u0013\t\u0001\u0016$A\u0003T)\u0006#V)\u0003\u0002S'\n)a+\u00197vK&\u0011A+\n\u0002\f\u000b:,X.\u001a:bi&|g.A\u0005ti\u0006$Xm\u0018\u0013fcR\u0011qK\u0017\t\u0003IaK!!W\u0013\u0003\tUs\u0017\u000e\u001e\u0005\b7\u001e\t\t\u00111\u0001N\u0003\rAH%M\u0001\u0007gR\fG/\u001a\u0011\u0002\u0013M$\u0018M\u001d;US6,W#A0\u0011\u0005\u0011\u0002\u0017BA1&\u0005\u0011auN\\4\u0002\u001bM$\u0018M\u001d;US6,w\fJ3r)\t9F\rC\u0004\\\u0015\u0005\u0005\t\u0019A0\u0002\u0015M$\u0018M\u001d;US6,\u0007%A\u0006hKR\u001cVM\u001d<jG\u0016\u001cX#\u00015\u0011\u0007%tWH\u0004\u0002kY:\u0011!g[\u0005\u0002M%\u0011Q.J\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0007OA\u0002TKFT!!\\\u0013\u0002\u0015\u0005$GmU3sm&\u001cW\r\u0006\u0002Xg\")A/\u0004a\u0001{\u000591/\u001a:wS\u000e,\u0017!\u0004:f[>4XmU3sm&\u001cW\r\u0006\u0002Xo\")AO\u0004a\u0001{\u0005!\u0011N\\5u)\t9&\u0010C\u0003|\u001f\u0001\u0007A0\u0001\u0003d_:4\u0007C\u0001\u0016~\u0013\tq8D\u0001\u0005MSZL8i\u001c8g\u0003\u0015\u0019H/\u0019:u)\u00059\u0016\u0001B:u_B$2aVA\u0004\u0011\u001d\tIA\u0005a\u0001\u0003\u0017\tAC\\;n\u001f\u001a\u001cVM\u001d<jG\u0016\u001c8\u000b^1si\u0016$\u0007c\u0001\u0013\u0002\u000e%\u0019\u0011qB\u0013\u0003\u0007%sG/A\bhKR\u001cVM\u001d<jG\u0016\u001cF/\u0019;f\u0003\u001d9W\r\u001e(b[\u0016\fAbZ3u'R\f'\u000f\u001e+j[\u0016\f!#\u001a8tkJ,7)\u001e:sK:$8\u000b^1uKR\u0019q+a\u0007\t\r\u0005ua\u00031\u0001N\u00031\u0019WO\u001d:f]R\u001cF/\u0019;f\u0003-\u0019\u0007.\u00198hKN#\u0018\r^3\u0015\u0007]\u000b\u0019\u0003\u0003\u0004\u0002&]\u0001\r!T\u0001\t]\u0016<8\u000b^1uK\u0002")
public class ThriftService
implements Logging {
    private final String name;
    private final ListBuffer<ThriftService> serviceList;
    private Enumeration.Value state;
    private long startTime;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        ThriftService thriftService = this;
        synchronized (thriftService) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String name() {
        return this.name;
    }

    private ListBuffer<ThriftService> serviceList() {
        return this.serviceList;
    }

    private Enumeration.Value state() {
        return this.state;
    }

    private void state_$eq(Enumeration.Value x$1) {
        this.state = x$1;
    }

    private long startTime() {
        return this.startTime;
    }

    private void startTime_$eq(long x$1) {
        this.startTime = x$1;
    }

    public Seq<ThriftService> getServices() {
        return this.serviceList().toList();
    }

    public void addService(ThriftService service) {
        this.serviceList().$plus$eq((Object)service);
    }

    public void removeService(ThriftService service) {
        this.serviceList().$minus$eq((Object)service);
    }

    public void init(LivyConf conf) {
        this.serviceList().foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
            ((ThriftService)x$1).init(conf);
            return BoxedUnit.UNIT;
        });
        this.ensureCurrentState(STATE$.MODULE$.NOTINITED());
        this.changeState(STATE$.MODULE$.INITED());
        this.info((Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(19).append("Service:").append(this.getName()).append(" is inited.").toString());
    }

    public void start() {
        int i;
        try {
            int n = this.serviceList().size();
            for (i = 0; i < n; ++i) {
                ThriftService service = (ThriftService)this.serviceList().apply(i);
                service.start();
            }
            this.startTime_$eq(System.currentTimeMillis());
            this.ensureCurrentState(STATE$.MODULE$.INITED());
            this.changeState(STATE$.MODULE$.STARTED());
            this.info((Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(20).append("Service:").append(this.getName()).append(" is started.").toString());
        }
        catch (Throwable e) {
            this.error((Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(24).append("Error starting services ").append(this.getName()).toString(), e);
            this.stop(i);
            throw new ServiceException(new StringBuilder(16).append("Failed to Start ").append(this.getName()).toString(), e);
        }
    }

    public void stop() {
        block6: {
            block5: {
                Enumeration.Value value = this.getServiceState();
                Enumeration.Value value2 = STATE$.MODULE$.STOPPED();
                if (!(value != null ? !value.equals(value2) : value2 != null)) {
                    return;
                }
                if (this.serviceList().nonEmpty()) {
                    this.stop(this.serviceList().size() - 1);
                }
                Enumeration.Value value3 = this.state();
                Enumeration.Value value4 = STATE$.MODULE$.STOPPED();
                if (!(value3 == null ? value4 != null : !value3.equals(value4))) break block5;
                Enumeration.Value value5 = this.state();
                Enumeration.Value value6 = STATE$.MODULE$.INITED();
                if (!(value5 == null ? value6 != null : !value5.equals(value6))) break block5;
                Enumeration.Value value7 = this.state();
                Enumeration.Value value8 = STATE$.MODULE$.NOTINITED();
                if (value7 != null ? !value7.equals(value8) : value8 != null) break block6;
            }
            return;
        }
        this.ensureCurrentState(STATE$.MODULE$.STARTED());
        this.changeState(STATE$.MODULE$.STOPPED());
        this.info((Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(20).append("Service:").append(this.getName()).append(" is stopped.").toString());
    }

    private void stop(int numOfServicesStarted) {
        for (int i = numOfServicesStarted; i >= 0; --i) {
            ThriftService service = (ThriftService)this.serviceList().apply(i);
            try {
                service.stop();
                continue;
            }
            catch (Throwable t) {
                this.info((Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> new Tuple2((Object)new StringBuilder(15).append("Error stopping ").append(service.getName()).toString(), (Object)t));
            }
        }
    }

    public Enumeration.Value getServiceState() {
        return this.state();
    }

    public String getName() {
        return this.name();
    }

    public long getStartTime() {
        return this.startTime();
    }

    private void ensureCurrentState(Enumeration.Value currentState) {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = currentState;
        if (value == null ? value2 != null : !value.equals(value2)) {
            throw new IllegalStateException(new StringBuilder(66).append("For this operation, the current service state must be ").append(currentState).append(" instead of ").append(this.state()).toString());
        }
    }

    private void changeState(Enumeration.Value newState) {
        this.state_$eq(newState);
    }

    public ThriftService(String name) {
        this.name = name;
        Logging.$init$((Logging)this);
        this.serviceList = new ListBuffer();
        this.state = STATE$.MODULE$.NOTINITED();
        this.startTime = 0L;
    }
}

