/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.auth;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hive.service.auth.HiveAuthConstants;
import org.apache.hive.service.auth.SaslQOP;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.client.common.ClientConf;
import org.apache.livy.thriftserver.auth.AuthBridgeServer;
import org.apache.livy.thriftserver.auth.CLIServiceProcessorFactory;
import org.apache.livy.thriftserver.auth.LivyDelegationTokenSecretManager;
import org.apache.livy.thriftserver.auth.PlainSaslServer$;
import org.apache.livy.thriftserver.auth.SQLPlainProcessorFactory;
import org.apache.livy.thriftserver.cli.ThriftCLIService;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\tc\u0001\u0011\t\u0011)A\u0005]!)!\u0007\u0001C\u0001g!9q\u0007\u0001b\u0001\n\u0013A\u0004BB!\u0001A\u0003%\u0011\bC\u0004C\u0001\t\u0007I\u0011\u0002\u001d\t\r\r\u0003\u0001\u0015!\u0003:\u0011\u001d!\u0005A1A\u0005\n\u0015Ca\u0001\u0014\u0001!\u0002\u00131\u0005bB'\u0001\u0005\u0004%IA\u0014\u0005\u0007'\u0002\u0001\u000b\u0011B(\t\u000bQ\u0003A\u0011A+\t\u000b\u0019\u0004A\u0011A4\t\u000f\u0005U\u0002\u0001\"\u0001\u00028!9\u0011Q\f\u0001\u0005\u0002\u0005\u0015\u0001bBA0\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003C\u0002A\u0011AA\u0003\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003KBq!!\u001c\u0001\t\u0003\t)\u0007C\u0004\u0002p\u0001!\t!!\u001d\u0003\u0017\u0005+H\u000f\u001b$bGR|'/\u001f\u0006\u0003/a\tA!Y;uQ*\u0011\u0011DG\u0001\ri\"\u0014\u0018N\u001a;tKJ4XM\u001d\u0006\u00037q\tA\u0001\\5ws*\u0011QDH\u0001\u0007CB\f7\r[3\u000b\u0003}\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0012)!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fMB\u0011\u0011FK\u0007\u00025%\u00111F\u0007\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0016\u00039\u0002\"!K\u0018\n\u0005AR\"\u0001\u0003'jmf\u001cuN\u001c4\u0002\u000b\r|gN\u001a\u0011\u0002\rqJg.\u001b;?)\t!d\u0007\u0005\u00026\u00015\ta\u0003C\u0003-\u0007\u0001\u0007a&A\u0006bkRDG+\u001f9f'R\u0014X#A\u001d\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014\u0001\u00027b]\u001eT\u0011AP\u0001\u0005U\u00064\u0018-\u0003\u0002Aw\t11\u000b\u001e:j]\u001e\fA\"Y;uQRK\b/Z*ue\u0002\n!\u0002[1e_>\u0004\u0018)\u001e;i\u0003-A\u0017\rZ8pa\u0006+H\u000f\u001b\u0011\u0002\u001bM,7M]3u\u001b\u0006t\u0017mZ3s+\u00051\u0005cA\u0012H\u0013&\u0011\u0001\n\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005UR\u0015BA&\u0017\u0005\u0001b\u0015N^=EK2,w-\u0019;j_:$vn[3o'\u0016\u001c'/\u001a;NC:\fw-\u001a:\u0002\u001dM,7M]3u\u001b\u0006t\u0017mZ3sA\u0005Q1/Y:m'\u0016\u0014h/\u001a:\u0016\u0003=\u00032aI$Q!\t)\u0014+\u0003\u0002S-\t\u0001\u0012)\u001e;i\u0005JLGmZ3TKJ4XM]\u0001\fg\u0006\u001cHnU3sm\u0016\u0014\b%A\thKR\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN,\u0012A\u0016\t\u0005/jcF,D\u0001Y\u0015\tIV(\u0001\u0003vi&d\u0017BA.Y\u0005\ri\u0015\r\u001d\t\u0003;\u0012t!A\u00182\u0011\u0005}#S\"\u00011\u000b\u0005\u0005\u0004\u0013A\u0002\u001fs_>$h(\u0003\u0002dI\u00051\u0001K]3eK\u001aL!\u0001Q3\u000b\u0005\r$\u0013aE4fi\u0006+H\u000f\u001b+sC:\u001ch)Y2u_JLX#\u00015\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017!\u0003;sC:\u001c\bo\u001c:u\u0015\tiG$\u0001\u0004uQJLg\r^\u0005\u0003_*\u0014\u0011\u0003\u0016+sC:\u001c\bo\u001c:u\r\u0006\u001cGo\u001c:zQ\ri\u0011o \t\u0004GI$\u0018BA:%\u0005\u0019!\bN]8xgB\u0011Q/`\u0007\u0002m*\u0011q\u000f_\u0001\u0006Y><\u0017N\u001c\u0006\u0003/eT!A_>\u0002\u0011M,7-\u001e:jifT\u0011\u0001`\u0001\u0006U\u00064\u0018\r_\u0005\u0003}Z\u0014a\u0002T8hS:,\u0005pY3qi&|g.\r\u0004\u001f9\u0006\u0005\u00111G\u0019\nG\u0005\r\u00111BA\u0015\u0003\u001b)B!!\u0002\u0002\bU\tA\fB\u0004\u0002\n\u0001\u0012\r!a\u0005\u0003\u0003QKA!!\u0004\u0002\u0010\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER1!!\u0005%\u0003\u0019!\bN]8xgF!\u0011QCA\u000e!\r\u0019\u0013qC\u0005\u0004\u00033!#a\u0002(pi\"Lgn\u001a\t\u0005\u0003;\t\u0019CD\u0002$\u0003?I1!!\t%\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\n\u0002(\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003C!\u0013'C\u0012\u0002,\u00055\u0012qFA\t\u001d\r\u0019\u0013QF\u0005\u0004\u0003#!\u0013'\u0002\u0012$I\u0005E\"!B:dC2\f\u0017G\u0001\u0014u\u0003I9W\r^!vi\"\u0004&o\\2GC\u000e$xN]=\u0015\t\u0005e\u0012\u0011\t\t\u0005\u0003w\ti$D\u0001m\u0013\r\ty\u0004\u001c\u0002\u0012)B\u0013xnY3tg>\u0014h)Y2u_JL\bbBA\"\u001d\u0001\u0007\u0011QI\u0001\bg\u0016\u0014h/[2f!\u0011\t9%!\u0014\u000e\u0005\u0005%#bAA&1\u0005\u00191\r\\5\n\t\u0005=\u0013\u0011\n\u0002\u0011)\"\u0014\u0018N\u001a;D\u0019&\u001bVM\u001d<jG\u0016DCAD9\u0002TE2a\u0004XA+\u00037\n\u0014bIA\u0002\u0003\u0017\t9&!\u00042\u0013\r\nY#!\f\u0002Z\u0005E\u0011'\u0002\u0012$I\u0005E\u0012G\u0001\u0014u\u000359W\r\u001e*f[>$X-V:fe\u0006aq-\u001a;Ja\u0006#GM]3tg\u0006!r-\u001a;Vg\u0016\u0014\u0018)\u001e;i\u001b\u0016\u001c\u0007.\u00198jg6\f!$[:T\u0003Ncu+\u001b;i\u0017\u0016\u0014(-\u001a:ju\u0016$\u0007*\u00193p_B,\"!a\u001a\u0011\u0007\r\nI'C\u0002\u0002l\u0011\u0012qAQ8pY\u0016\fg.\u0001\njgN\u000b5\u000bT&fe\n,'o\\:Vg\u0016\u0014\u0018!\u0006<fe&4\u0017\u0010R3mK\u001e\fG/[8o)>\\WM\u001c\u000b\u00049\u0006M\u0004BBA;)\u0001\u0007A,A\beK2,w-\u0019;j_:$vn[3oQ\u0015!\u0012\u0011PAF!\u0011\u0019#/a\u001f\u0011\t\u0005u\u0014qQ\u0007\u0003\u0003\u007fRA!a\u0013\u0002\u0002*!\u00111IAB\u0015\r\t)\tH\u0001\u0005Q&4X-\u0003\u0003\u0002\n\u0006}$\u0001\u0005%jm\u0016\u001c\u0016\u000bT#yG\u0016\u0004H/[8oc\u0019qB,!$\u0002\u0014FJ1%a\u0001\u0002\f\u0005=\u0015QB\u0019\nG\u0005-\u0012QFAI\u0003#\tTAI\u0012%\u0003c\t4AJA>\u0001")
public class AuthFactory
implements Logging {
    private final LivyConf conf;
    private final String authTypeStr;
    private final String hadoopAuth;
    private final Option<LivyDelegationTokenSecretManager> secretManager;
    private final Option<AuthBridgeServer> saslServer;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        AuthFactory authFactory = this;
        synchronized (authFactory) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public LivyConf conf() {
        return this.conf;
    }

    private String authTypeStr() {
        return this.authTypeStr;
    }

    private String hadoopAuth() {
        return this.hadoopAuth;
    }

    private Option<LivyDelegationTokenSecretManager> secretManager() {
        return this.secretManager;
    }

    private Option<AuthBridgeServer> saslServer() {
        return this.saslServer;
    }

    public Map<String, String> getSaslProperties() {
        HashMap<String, String> saslProps = new HashMap<String, String>();
        SaslQOP saslQOP = SaslQOP.fromString((String)this.conf().get((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_SASL_QOP()));
        saslProps.put("javax.security.sasl.qop", saslQOP.toString());
        saslProps.put("javax.security.sasl.server.authentication", "true");
        return saslProps;
    }

    public TTransportFactory getAuthTransFactory() throws LoginException {
        boolean isAuthKerberos = this.authTypeStr().equalsIgnoreCase(HiveAuthConstants.AuthTypes.KERBEROS.getAuthName());
        boolean isAuthNoSASL = this.authTypeStr().equalsIgnoreCase(HiveAuthConstants.AuthTypes.NOSASL.getAuthName());
        boolean isAuthOther = this.authTypeStr().equalsIgnoreCase(HiveAuthConstants.AuthTypes.LDAP.getAuthName()) || this.authTypeStr().equalsIgnoreCase(HiveAuthConstants.AuthTypes.NONE.getAuthName()) || this.authTypeStr().equalsIgnoreCase(HiveAuthConstants.AuthTypes.CUSTOM.getAuthName());
        return (TTransportFactory)this.saslServer().map((Function1 & Serializable & scala.Serializable)server -> {
            TSaslServerTransport.Factory factory;
            try {
                factory = server.createSaslServerTransportFactory(this.getSaslProperties());
            }
            catch (TTransportException e) {
                throw new LoginException(e.getMessage());
            }
            TSaslServerTransport.Factory serverTransportFactory = factory;
            if (isAuthOther) {
                PlainSaslServer$.MODULE$.addPlainServerDefinition(serverTransportFactory, this.authTypeStr(), this.conf());
            } else if (!isAuthKerberos) {
                throw new LoginException(new StringBuilder(32).append("Unsupported authentication type ").append(this.authTypeStr()).toString());
            }
            return server.wrapTransportFactory((TTransportFactory)serverTransportFactory);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            if (isAuthOther) {
                return PlainSaslServer$.MODULE$.getPlainTransportFactory(this.authTypeStr(), this.conf());
            }
            if (isAuthNoSASL) {
                return new TTransportFactory();
            }
            throw new LoginException(new StringBuilder(32).append("Unsupported authentication type ").append(this.authTypeStr()).toString());
        });
    }

    public TProcessorFactory getAuthProcFactory(ThriftCLIService service) throws LoginException {
        if (this.saslServer().isDefined()) {
            return new CLIServiceProcessorFactory(service, (AuthBridgeServer)this.saslServer().get());
        }
        return new SQLPlainProcessorFactory(service);
    }

    public String getRemoteUser() {
        return (String)this.saslServer().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getRemoteUser()).orNull(Predef$.MODULE$.$conforms());
    }

    public String getIpAddress() {
        return (String)this.saslServer().flatMap((Function1 & Serializable & scala.Serializable)s -> Option$.MODULE$.apply((Object)s.getRemoteAddress())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getHostAddress()).orNull(Predef$.MODULE$.$conforms());
    }

    public String getUserAuthMechanism() {
        return (String)this.saslServer().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getUserAuthMechanism()).orNull(Predef$.MODULE$.$conforms());
    }

    public boolean isSASLWithKerberizedHadoop() {
        return "kerberos".equalsIgnoreCase(this.hadoopAuth()) && !this.authTypeStr().equalsIgnoreCase(HiveAuthConstants.AuthTypes.NOSASL.getAuthName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSASLKerberosUser() {
        String string = SaslRpcServer.AuthMethod.KERBEROS.getMechanismName();
        String string2 = this.getUserAuthMechanism();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = SaslRpcServer.AuthMethod.TOKEN.getMechanismName();
        String string4 = this.getUserAuthMechanism();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public String verifyDelegationToken(String delegationToken) throws HiveSQLException {
        String string;
        if (this.secretManager().isEmpty()) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            string = ((LivyDelegationTokenSecretManager)((Object)this.secretManager().get())).verifyDelegationToken(delegationToken);
        }
        catch (IOException e) {
            String msg = new StringBuilder(33).append("Error verifying delegation token ").append(delegationToken).toString();
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
            throw new HiveSQLException(msg, "08S01", (Throwable)e);
        }
        return string;
    }

    private static final /* synthetic */ void liftedTree1$1(LivyDelegationTokenSecretManager sm$1) {
        try {
            sm$1.startThreads();
        }
        catch (IOException e) {
            throw new TTransportException("Failed to start token manager", (Throwable)e);
        }
    }

    public AuthFactory(LivyConf conf) {
        None$ none$;
        this.conf = conf;
        Logging.$init$((Logging)this);
        this.authTypeStr = conf.get((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_AUTHENTICATION());
        this.hadoopAuth = new Configuration().get("hadoop.security.authentication");
        if (this.isSASLWithKerberizedHadoop()) {
            LivyDelegationTokenSecretManager sm2 = new LivyDelegationTokenSecretManager(conf);
            AuthFactory.liftedTree1$1(sm2);
            none$ = new Some((Object)sm2);
        } else {
            none$ = None$.MODULE$;
        }
        this.secretManager = none$;
        this.saslServer = this.secretManager().map((Function1 & Serializable & scala.Serializable)sm -> new AuthBridgeServer((LivyDelegationTokenSecretManager)((Object)sm)));
    }
}

