/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.auth;

import javax.security.sasl.AuthenticationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;
import org.apache.livy.LivyConf;
import org.apache.livy.server.auth.LdapUtils$;
import org.apache.livy.thriftserver.auth.ldap.ChainFilter;
import org.apache.livy.thriftserver.auth.ldap.DirSearchFactory;
import org.apache.livy.thriftserver.auth.ldap.Filter;
import org.apache.livy.thriftserver.auth.ldap.LdapSearchFactory;
import org.apache.livy.thriftserver.auth.ldap.UserFilter;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0006\r\u0001]A\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005W!)\u0001\u0007\u0001C\u0001c!9Q\u0007\u0001b\u0001\n\u00131\u0004BB\u001f\u0001A\u0003%q\u0007C\u0004?\u0001\t\u0007I\u0011B \t\r\r\u0003\u0001\u0015!\u0003A\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017Aq!!\b\u0001\t\u0013\tyB\u0001\u0010MI\u0006\u0004\u0018)\u001e;iK:$\u0018nY1uS>t\u0007K]8wS\u0012,'/S7qY*\u0011QBD\u0001\u0005CV$\bN\u0003\u0002\u0010!\u0005aA\u000f\u001b:jMR\u001cXM\u001d<fe*\u0011\u0011CE\u0001\u0005Y&4\u0018P\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7\u0001A\n\u0004\u0001a\u0001\u0003CA\r\u001f\u001b\u0005Q\"BA\u000e\u001d\u0003\u0011a\u0017M\\4\u000b\u0003u\tAA[1wC&\u0011qD\u0007\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0005:S\"\u0001\u0012\u000b\u00055\u0019#B\u0001\u0013&\u0003\u001d\u0019XM\u001d<jG\u0016T!A\n\n\u0002\t!Lg/Z\u0005\u0003Q\t\u0012A\u0004U1tg^$\u0017)\u001e;iK:$\u0018nY1uS>t\u0007K]8wS\u0012,'/\u0001\u0003d_:4W#A\u0016\u0011\u00051jS\"\u0001\t\n\u00059\u0002\"\u0001\u0003'jmf\u001cuN\u001c4\u0002\u000b\r|gN\u001a\u0011\u0002\rqJg.\u001b;?)\t\u0011D\u0007\u0005\u00024\u00015\tA\u0002C\u0003*\u0007\u0001\u00071&\u0001\u0004gS2$XM]\u000b\u0002oA\u0011\u0001hO\u0007\u0002s)\u0011!\bD\u0001\u0005Y\u0012\f\u0007/\u0003\u0002=s\t1a)\u001b7uKJ\fqAZ5mi\u0016\u0014\b%A\u0007tK\u0006\u00148\r\u001b$bGR|'/_\u000b\u0002\u0001B\u0011\u0001(Q\u0005\u0003\u0005f\u0012\u0001\u0003R5s'\u0016\f'o\u00195GC\u000e$xN]=\u0002\u001dM,\u0017M]2i\r\u0006\u001cGo\u001c:zA\u0005a\u0011)\u001e;iK:$\u0018nY1uKR\u0019a\tT-\u0011\u0005\u001dSU\"\u0001%\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001b\"\u0001\rAT\u0001\u0005kN,'\u000f\u0005\u0002P-:\u0011\u0001\u000b\u0016\t\u0003#\"k\u0011A\u0015\u0006\u0003'Z\ta\u0001\u0010:p_Rt\u0014BA+I\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000b\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005UC\u0005\"\u0002.\t\u0001\u0004q\u0015\u0001\u00039bgN<xN\u001d3)\u0007!a\u0016\u000eE\u0002H;~K!A\u0018%\u0003\rQD'o\\<t!\t\u0001w-D\u0001b\u0015\t\u00117-\u0001\u0003tCNd'B\u00013f\u0003!\u0019XmY;sSRL(\"\u00014\u0002\u000b)\fg/\u0019=\n\u0005!\f'aF!vi\",g\u000e^5dCRLwN\\#yG\u0016\u0004H/[8oc\u0015qbJ[A\u0004c\u0015\u00193n\u001c@q+\taW.F\u0001O\t\u0015qgC1\u0001t\u0005\u0005!\u0016B\u00019r\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0011!\u000fS\u0001\u0007i\"\u0014xn^:\u0012\u0005Q<\bCA$v\u0013\t1\bJA\u0004O_RD\u0017N\\4\u0011\u0005a\\hBA$z\u0013\tQ\b*A\u0004qC\u000e\\\u0017mZ3\n\u0005ql(!\u0003+ie><\u0018M\u00197f\u0015\tQ\b*M\u0004$\u007f\u0006\u0005\u00111\u0001:\u000f\u0007\u001d\u000b\t!\u0003\u0002s\u0011F*!e\u0012%\u0002\u0006\t)1oY1mCF\u0012aeX\u0001\u0010GJ,\u0017\r^3ESJ\u001cV-\u0019:dQR)a)!\u0004\u0002\u0010!)Q*\u0003a\u0001\u001d\")!,\u0003a\u0001\u001d\"\"\u0011\u0002XA\nc\u0019qb*!\u0006\u0002\u001cE21e[8\u0002\u0018A\ftaI@\u0002\u0002\u0005e!/M\u0003#\u000f\"\u000b)!\r\u0002'?\u0006Y\u0011\r\u001d9ms\u001aKG\u000e^3s)\r1\u0015\u0011\u0005\u0005\u0006\u001b*\u0001\rA\u0014\u0015\u0005\u0015q\u000b)#\r\u0004\u001f\u001d\u0006\u001d\u0012QF\u0019\u0007G-|\u0017\u0011\u000692\u000f\rz\u0018\u0011AA\u0016eF*!e\u0012%\u0002\u0006E\u0012ae\u0018")
public class LdapAuthenticationProviderImpl
implements PasswdAuthenticationProvider {
    private final LivyConf conf;
    private final Filter filter;
    private final DirSearchFactory searchFactory;

    public LivyConf conf() {
        return this.conf;
    }

    private Filter filter() {
        return this.filter;
    }

    private DirSearchFactory searchFactory() {
        return this.searchFactory;
    }

    public void Authenticate(String user, String password) throws AuthenticationException {
        this.createDirSearch(user, password);
        this.applyFilter(user);
    }

    private void createDirSearch(String user, String password) throws AuthenticationException {
        if (StringUtils.isBlank((CharSequence)user) || StringUtils.isEmpty((CharSequence)user)) {
            throw new AuthenticationException("Error validating LDAP: a null or blank user name has been provided");
        }
        if (StringUtils.isBlank((CharSequence)password) || StringUtils.isEmpty((CharSequence)password)) {
            throw new AuthenticationException("Error validating LDAP: a null or blank password has been provided");
        }
        String principal = LdapUtils$.MODULE$.createCandidatePrincipal(this.conf(), user);
        try {
            this.searchFactory().getInstance(this.conf(), principal, password);
        }
        catch (AuthenticationException e) {
            throw new AuthenticationException(new StringBuilder(28).append("Error validating LDAP user: ").append(user).toString(), e);
        }
    }

    private void applyFilter(String user) throws AuthenticationException {
        if (LdapUtils$.MODULE$.hasDomain(user)) {
            this.filter().apply(LdapUtils$.MODULE$.extractUserName(user));
            return;
        }
        this.filter().apply(user);
    }

    public LdapAuthenticationProviderImpl(LivyConf conf) {
        this.conf = conf;
        this.filter = new ChainFilter((Seq<Filter>)new .colon.colon((Object)new UserFilter(conf), (List)Nil$.MODULE$));
        this.searchFactory = new LdapSearchFactory();
    }
}

