/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.auth;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.security.PrivilegedExceptionAction;
import javax.security.sasl.SaslServer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.livy.Logging;
import org.apache.livy.thriftserver.auth.AuthBridgeServer$;
import org.apache.livy.thriftserver.auth.LivyDelegationTokenIdentifier;
import org.apache.livy.thriftserver.auth.LivyDelegationTokenSecretManager;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001\u0002\u0006\f!YA\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\tW\u0001\u0011\t\u0011)A\u0005?!AA\u0006\u0001BC\u0002\u0013\u0005Q\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u0003/\u0011!\u0019\u0004A!a\u0001\n\u0003!\u0004\u0002C\u001e\u0001\u0005\u0003\u0007I\u0011\u0001\u001f\t\u0011\t\u0003!\u0011!Q!\nUBQa\u0011\u0001\u0005\u0002\u0011CQ!\u0013\u0001\u0005B)\u0013Q\u0003V+H\u0013\u0006\u001b8/^7j]\u001e\u0004&o\\2fgN|'O\u0003\u0002\r\u001b\u0005!\u0011-\u001e;i\u0015\tqq\"\u0001\u0007uQJLg\r^:feZ,'O\u0003\u0002\u0011#\u0005!A.\u001b<z\u0015\t\u00112#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002)\u0005\u0019qN]4\u0004\u0001M!\u0001aF\u0010&!\tAR$D\u0001\u001a\u0015\tQ2$\u0001\u0003mC:<'\"\u0001\u000f\u0002\t)\fg/Y\u0005\u0003=e\u0011aa\u00142kK\u000e$\bC\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0012\u0003\u0019!\bN]5gi&\u0011A%\t\u0002\u000b)B\u0013xnY3tg>\u0014\bC\u0001\u0014(\u001b\u0005y\u0011B\u0001\u0015\u0010\u0005\u001daunZ4j]\u001e\fqa\u001e:baB,G-F\u0001 \u0003!9(/\u00199qK\u0012\u0004\u0013!D:fGJ,G/T1oC\u001e,'/F\u0001/!\ty\u0003'D\u0001\f\u0013\t\t4B\u0001\u0011MSZLH)\u001a7fO\u0006$\u0018n\u001c8U_.,gnU3de\u0016$X*\u00198bO\u0016\u0014\u0018AD:fGJ,G/T1oC\u001e,'\u000fI\u0001\tkN,\u0007K]8ysV\tQ\u0007\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtGA\u0004C_>dW-\u00198\u0002\u0019U\u001cX\r\u0015:pqf|F%Z9\u0015\u0005u\u0002\u0005C\u0001\u001c?\u0013\tytG\u0001\u0003V]&$\bbB!\u0007\u0003\u0003\u0005\r!N\u0001\u0004q\u0012\n\u0014!C;tKB\u0013x\u000e_=!\u0003\u0019a\u0014N\\5u}Q!QIR$I!\ty\u0003\u0001C\u0003*\u0011\u0001\u0007q\u0004C\u0003-\u0011\u0001\u0007a\u0006C\u00034\u0011\u0001\u0007Q'A\u0004qe>\u001cWm]:\u0015\u0007uZ5\u000bC\u0003M\u0013\u0001\u0007Q*\u0001\u0004j]B\u0013x\u000e\u001e\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u0006\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003%>\u0013\u0011\u0002\u0016)s_R|7m\u001c7\t\u000bQK\u0001\u0019A'\u0002\u000f=,H\u000f\u0015:pi\"\u001a\u0011B\u0016/\u0011\u0007Y:\u0016,\u0003\u0002Yo\t1A\u000f\u001b:poN\u0004\"\u0001\t.\n\u0005m\u000b#A\u0003+Fq\u000e,\u0007\u000f^5p]F*a$\u00185\u0002\u0004A\u0011a,\u001a\b\u0003?\u000e\u0004\"\u0001Y\u001c\u000e\u0003\u0005T!AY\u000b\u0002\rq\u0012xn\u001c;?\u0013\t!w'\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001e\u0014aa\u0015;sS:<'B\u000138c\u0015\u0019\u0013.\u001c?o+\tQ7.F\u0001^\t\u0015aWC1\u0001r\u0005\u0005!\u0016B\u00018p\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0011\u0001oN\u0001\u0007i\"\u0014xn^:\u0012\u0005I,\bC\u0001\u001ct\u0013\t!xGA\u0004O_RD\u0017N\\4\u0011\u0005YLhB\u0001\u001cx\u0013\tAx'A\u0004qC\u000e\\\u0017mZ3\n\u0005i\\(!\u0003+ie><\u0018M\u00197f\u0015\tAx'M\u0003${z|\bO\u0004\u00027}&\u0011\u0001oN\u0019\u0006EY:\u0014\u0011\u0001\u0002\u0006g\u000e\fG.Y\u0019\u0003Me\u0003")
public class TUGIAssumingProcessor
implements TProcessor,
Logging {
    private final TProcessor wrapped;
    private final LivyDelegationTokenSecretManager secretManager;
    private boolean useProxy;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        TUGIAssumingProcessor tUGIAssumingProcessor = this;
        synchronized (tUGIAssumingProcessor) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public TProcessor wrapped() {
        return this.wrapped;
    }

    public LivyDelegationTokenSecretManager secretManager() {
        return this.secretManager;
    }

    public boolean useProxy() {
        return this.useProxy;
    }

    public void useProxy_$eq(boolean x$1) {
        this.useProxy = x$1;
    }

    public void process(TProtocol inProt, TProtocol outProt) throws TException {
        block24: {
            TTransport trans = inProt.getTransport();
            if (!(trans instanceof TSaslServerTransport)) {
                throw new TException(new StringBuilder(30).append("Unexpected non-SASL transport ").append(trans.getClass()).toString());
            }
            TSaslServerTransport saslTrans = (TSaslServerTransport)trans;
            SaslServer saslServer = saslTrans.getSaslServer();
            String authId = saslServer.getAuthorizationID();
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("AUTH ID ======> ").append(authId).toString());
            ObjectRef endUser = ObjectRef.create((Object)authId);
            Socket socket = ((TSocket)saslTrans.getUnderlyingTransport()).getSocket();
            AuthBridgeServer$.MODULE$.remoteAddress().set(socket.getInetAddress());
            String mechanismName = saslServer.getMechanismName();
            AuthBridgeServer$.MODULE$.userAuthMechanism().set(mechanismName);
            if (SaslRpcServer.AuthMethod.PLAIN.getMechanismName().equalsIgnoreCase(mechanismName)) {
                AuthBridgeServer$.MODULE$.remoteUser().set((String)endUser.elem);
                try {
                    this.wrapped().process(inProt, outProt);
                }
                catch (TException te) {
                    throw new RuntimeException(te);
                }
            }
            AuthBridgeServer$.MODULE$.authenticationMethod().set(UserGroupInformation.AuthenticationMethod.KERBEROS);
            if (SaslRpcServer.AuthMethod.TOKEN.getMechanismName().equalsIgnoreCase(mechanismName)) {
                try {
                    LivyDelegationTokenIdentifier tokenId = (LivyDelegationTokenIdentifier)SaslRpcServer.getIdentifier((String)authId, (SecretManager)this.secretManager());
                    endUser.elem = tokenId.getUser().getUserName();
                    AuthBridgeServer$.MODULE$.authenticationMethod().set(UserGroupInformation.AuthenticationMethod.TOKEN);
                }
                catch (SecretManager.InvalidToken e) {
                    throw new TException(e.getMessage());
                }
            }
            ObjectRef clientUgi = ObjectRef.create(null);
            try {
                try {
                    if (this.useProxy()) {
                        clientUgi.elem = UserGroupInformation.createProxyUser((String)((String)endUser.elem), (UserGroupInformation)UserGroupInformation.getLoginUser());
                        AuthBridgeServer$.MODULE$.remoteUser().set(((UserGroupInformation)clientUgi.elem).getShortUserName());
                        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Set remoteUser : ").append((Object)AuthBridgeServer$.MODULE$.remoteUser().get()).toString());
                        ((UserGroupInformation)clientUgi.elem).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(this, inProt, outProt){
                            private final /* synthetic */ TUGIAssumingProcessor $outer;
                            private final TProtocol inProt$1;
                            private final TProtocol outProt$1;

                            public boolean run() {
                                try {
                                    try {
                                        this.$outer.wrapped().process(this.inProt$1, this.outProt$1);
                                        return true;
                                    }
                                    catch (TException te) {
                                        throw new RuntimeException(te);
                                    }
                                }
                                catch (TException te) {
                                    throw new RuntimeException(te);
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.inProt$1 = inProt$1;
                                this.outProt$1 = outProt$1;
                            }
                        });
                        break block24;
                    }
                    UserGroupInformation endUserUgi = UserGroupInformation.createRemoteUser((String)((String)endUser.elem));
                    AuthBridgeServer$.MODULE$.remoteUser().set(endUserUgi.getShortUserName());
                    this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Set remoteUser: ").append((Object)AuthBridgeServer$.MODULE$.remoteUser().get()).append(", from endUser :").append((String)endUser$1.elem).toString());
                    try {
                        this.wrapped().process(inProt, outProt);
                    }
                    catch (TException te) {
                        throw new RuntimeException(te);
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (runtimeException.getCause() instanceof TException) {
                        throw runtimeException.getCause();
                    }
                    throw runtimeException;
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            finally {
                if ((UserGroupInformation)clientUgi.elem != null) {
                    try {
                        FileSystem.closeAllForUGI((UserGroupInformation)((UserGroupInformation)clientUgi.elem));
                    }
                    catch (IOException exception) {
                        this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Could not clean up file-system handles for UGI: ").append((UserGroupInformation)clientUgi$1.elem).toString(), exception);
                    }
                }
            }
        }
    }

    public TUGIAssumingProcessor(TProcessor wrapped, LivyDelegationTokenSecretManager secretManager, boolean useProxy) {
        this.wrapped = wrapped;
        this.secretManager = secretManager;
        this.useProxy = useProxy;
        Logging.$init$((Logging)this);
    }
}

