/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.auth.ldap;

import javax.security.sasl.AuthenticationException;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.client.common.ClientConf;
import org.apache.livy.server.auth.LdapUtils$;
import org.apache.livy.thriftserver.auth.ldap.Filter;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a4A\u0001C\u0005\u0001-!AQ\u0005\u0001B\u0001B\u0003%a\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0004.\u0001\t\u0007I\u0011\u0002\u0018\t\r]\u0002\u0001\u0015!\u00030\u0011\u001dA\u0004A1A\u0005\neBaa\u0012\u0001!\u0002\u0013Q\u0004\"\u0002%\u0001\t\u0003I%AC+tKJ4\u0015\u000e\u001c;fe*\u0011!bC\u0001\u0005Y\u0012\f\u0007O\u0003\u0002\r\u001b\u0005!\u0011-\u001e;i\u0015\tqq\"\u0001\u0007uQJLg\r^:feZ,'O\u0003\u0002\u0011#\u0005!A.\u001b<z\u0015\t\u00112#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002)\u0005\u0019qN]4\u0004\u0001M!\u0001aF\u000f\"!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fMB\u0011adH\u0007\u0002\u0013%\u0011\u0001%\u0003\u0002\u0007\r&dG/\u001a:\u0011\u0005\t\u001aS\"A\b\n\u0005\u0011z!a\u0002'pO\u001eLgnZ\u0001\u0005G>tg\r\u0005\u0002#O%\u0011\u0001f\u0004\u0002\t\u0019&4\u0018pQ8oM\u00061A(\u001b8jiz\"\"a\u000b\u0017\u0011\u0005y\u0001\u0001\"B\u0013\u0003\u0001\u00041\u0013!D;tKJ4\u0015\u000e\u001c;feN#(/F\u00010!\t\u0001T'D\u00012\u0015\t\u00114'\u0001\u0003mC:<'\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003mE\u0012aa\u0015;sS:<\u0017AD;tKJ4\u0015\u000e\u001c;feN#(\u000fI\u0001\u000bkN,'OR5mi\u0016\u0014X#\u0001\u001e\u0011\u0007m\u0012UI\u0004\u0002=\u0001B\u0011Q(G\u0007\u0002})\u0011q(F\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005K\u0012A\u0002)sK\u0012,g-\u0003\u0002D\t\n\u00191+\u001a;\u000b\u0005\u0005K\u0002CA\u001eG\u0013\t1D)A\u0006vg\u0016\u0014h)\u001b7uKJ\u0004\u0013!B1qa2LHC\u0001&N!\tA2*\u0003\u0002M3\t!QK\\5u\u0011\u0015qu\u00011\u0001F\u0003\u0011)8/\u001a:)\u0007\u001d\u0001V\fE\u0002\u0019#NK!AU\r\u0003\rQD'o\\<t!\t!6,D\u0001V\u0015\t1v+\u0001\u0003tCNd'B\u0001-Z\u0003!\u0019XmY;sSRL(\"\u0001.\u0002\u000b)\fg/\u0019=\n\u0005q+&aF!vi\",g\u000e^5dCRLwN\\#yG\u0016\u0004H/[8oc\u0011qRIX<2\u000b\rz6M\u001d3\u0016\u0005\u0001\fW#A#\u0005\u000b\t,\"\u0019A4\u0003\u0003QK!\u0001Z3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\t1\u0017$\u0001\u0004uQJ|wo]\t\u0003Q.\u0004\"\u0001G5\n\u0005)L\"a\u0002(pi\"Lgn\u001a\t\u0003Y>t!\u0001G7\n\u00059L\u0012a\u00029bG.\fw-Z\u0005\u0003aF\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u00059L\u0012'B\u0012tiV4gB\u0001\ru\u0013\t1\u0017$\r\u0003#1e1(!B:dC2\f\u0017G\u0001\u0014T\u0001")
public class UserFilter
implements Filter,
Logging {
    private final String userFilterStr;
    private final Set<String> userFilter;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        UserFilter userFilter = this;
        synchronized (userFilter) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private String userFilterStr() {
        return this.userFilterStr;
    }

    private Set<String> userFilter() {
        return this.userFilter;
    }

    @Override
    public void apply(String user) throws AuthenticationException {
        if (!this.userFilter().isEmpty()) {
            this.info((Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> new Tuple2((Object)"Authenticating user '{}' using user filter", (Object)user));
            String userName = LdapUtils$.MODULE$.extractUserName(user).toLowerCase();
            if (!this.userFilter().contains((Object)userName)) {
                this.info((Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> "Authentication failed based on user membership");
                throw new AuthenticationException("Authentication failed: User not a member of specified list");
            }
            return;
        }
    }

    public UserFilter(LivyConf conf) {
        Logging.$init$((Logging)this);
        this.userFilterStr = conf.get((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_LDAP_AUTHENTICATION_USERFILTER());
        this.userFilter = this.userFilterStr() != null ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.userFilterStr().split(","))).toSet() : (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }
}

