/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.cli;

import java.io.IOException;
import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hive.service.auth.HttpAuthenticationException;
import org.apache.livy.thriftserver.cli.ThriftHttpServlet$;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import scala.Function1;
import scala.None$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001\u0002\u0006\f\u0001YA\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\t}\u0001\u0011\t\u0011)A\u0005i!Aq\b\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003B\u0011!I\u0005A!A!\u0002\u0013)\u0003\"\u0002&\u0001\t\u0003Y\u0005\"B)\u0001\t\u0003\u0012\u0006\"B?\u0001\t\u0013q\bbBA\u0002\u0001\u0011%\u0011Q\u0001\u0002\u0019\u0011R$\boS3sE\u0016\u0014xn]*feZ,'/Q2uS>t'B\u0001\u0007\u000e\u0003\r\u0019G.\u001b\u0006\u0003\u001d=\tA\u0002\u001e5sS\u001a$8/\u001a:wKJT!\u0001E\t\u0002\t1Lg/\u001f\u0006\u0003%M\ta!\u00199bG\",'\"\u0001\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00019r\u0004\u0005\u0002\u0019;5\t\u0011D\u0003\u0002\u001b7\u0005!A.\u00198h\u0015\u0005a\u0012\u0001\u00026bm\u0006L!AH\r\u0003\r=\u0013'.Z2u!\r\u00013%J\u0007\u0002C)\u0011!eG\u0001\tg\u0016\u001cWO]5us&\u0011A%\t\u0002\u001a!JLg/\u001b7fO\u0016$W\t_2faRLwN\\!di&|g\u000e\u0005\u0002'_9\u0011q%\f\t\u0003Q-j\u0011!\u000b\u0006\u0003UU\ta\u0001\u0010:p_Rt$\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z\u0013A\u0002)sK\u0012,g-\u0003\u00021c\t11\u000b\u001e:j]\u001eT!AL\u0016\u0002\u000fI,\u0017/^3tiV\tA\u0007\u0005\u00026y5\taG\u0003\u00028q\u0005!\u0001\u000e\u001e;q\u0015\tI$(A\u0004tKJ4H.\u001a;\u000b\u0003m\nQA[1wCbL!!\u0010\u001c\u0003%!#H\u000f]*feZdW\r\u001e*fcV,7\u000f^\u0001\te\u0016\fX/Z:uA\u0005Q1/\u001a:wS\u000e,WkR%\u0016\u0003\u0005\u0003\"A\u0011$\u000e\u0003\rS!A\t#\u000b\u0005\u0015\u000b\u0012A\u00025bI>|\u0007/\u0003\u0002H\u0007\n!Rk]3s\u000fJ|W\u000f]%oM>\u0014X.\u0019;j_:\f1b]3sm&\u001cW-V$JA\u0005A\u0011-\u001e;i)f\u0004X-\u0001\u0004=S:LGO\u0010\u000b\u0005\u0019:{\u0005\u000b\u0005\u0002N\u00015\t1\u0002C\u00033\r\u0001\u0007A\u0007C\u0003@\r\u0001\u0007\u0011\tC\u0003J\r\u0001\u0007Q%A\u0002sk:$\u0012!\n\u0015\u0004\u000fQ\u0013\u0007cA+W16\t1&\u0003\u0002XW\t1A\u000f\u001b:poN\u0004\"!\u00171\u000e\u0003iS!a\u0017/\u0002\t\u0005,H\u000f\u001b\u0006\u0003;z\u000bqa]3sm&\u001cWM\u0003\u0002`#\u0005!\u0001.\u001b<f\u0013\t\t'LA\u000eIiR\u0004\u0018)\u001e;iK:$\u0018nY1uS>tW\t_2faRLwN\\\u0019\u0005=\u0015\u001aG0M\u0003$I\"<\u0018.\u0006\u0002fMV\tQ\u0005B\u0003h+\t\u0007ANA\u0001U\u0013\tI'.A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0003W.\na\u0001\u001e5s_^\u001c\u0018CA7q!\t)f.\u0003\u0002pW\t9aj\u001c;iS:<\u0007CA9u\u001d\t)&/\u0003\u0002tW\u00059\u0001/Y2lC\u001e,\u0017BA;w\u0005%!\u0006N]8xC\ndWM\u0003\u0002tWE*1\u0005_={W:\u0011Q+_\u0005\u0003W.\nDAI+,w\n)1oY1mCF\u0012a\u0005W\u0001\u0019O\u0016$\bK]5oG&\u0004\u0018\r\\,ji\"|W\u000f\u001e*fC2lGCA\u0013\u0000\u0011\u0019\t\t\u0001\u0003a\u0001K\u0005ia-\u001e7m!JLgnY5qC2\fqdZ3u!JLgnY5qC2<\u0016\u000e\u001e5pkR\u0014V-\u00197n\u0003:$\u0007j\\:u)\r)\u0013q\u0001\u0005\u0007\u0003\u0003I\u0001\u0019A\u0013")
public class HttpKerberosServerAction
implements PrivilegedExceptionAction<String> {
    private final HttpServletRequest request;
    private final UserGroupInformation serviceUGI;
    private final String authType;

    public HttpServletRequest request() {
        return this.request;
    }

    public UserGroupInformation serviceUGI() {
        return this.serviceUGI;
    }

    @Override
    public String run() throws HttpAuthenticationException {
        String string;
        GSSManager manager = GSSManager.getInstance();
        None$ gssContext = None$.MODULE$;
        String serverPrincipal = this.getPrincipalWithoutRealm(this.serviceUGI().getUserName());
        try {
            try {
                Oid kerberosMechOid = new Oid("1.2.840.113554.1.2.2");
                Oid spnegoMechOid = new Oid("1.3.6.1.5.5.2");
                Oid krb5PrincipalOid = new Oid("1.2.840.113554.1.2.2.1");
                GSSName serverName = manager.createName(serverPrincipal, krb5PrincipalOid);
                GSSCredential serverCreds = manager.createCredential(serverName, 0, (Oid[])((Object[])new Oid[]{kerberosMechOid, spnegoMechOid}), 2);
                gssContext = new Some((Object)manager.createContext(serverCreds));
                String serviceTicketBase64 = ThriftHttpServlet$.MODULE$.getAuthHeader(this.request(), this.authType);
                byte[] inToken = Base64.decodeBase64((byte[])serviceTicketBase64.getBytes());
                ((GSSContext)gssContext.get()).acceptSecContext(inToken, 0, inToken.length);
                if (!((GSSContext)gssContext.get()).isEstablished()) {
                    throw new HttpAuthenticationException("Kerberos authentication failed: unable to establish context with the service ticket provided by the client.");
                }
                string = this.getPrincipalWithoutRealmAndHost(((Object)((GSSContext)gssContext.get()).getSrcName()).toString());
            }
            catch (GSSException e) {
                throw new HttpAuthenticationException("Kerberos authentication failed: ", (Throwable)e);
            }
        }
        finally {
            gssContext.foreach((Function1 & Serializable & scala.Serializable)ctx -> {
                HttpKerberosServerAction.$anonfun$run$1(ctx);
                return BoxedUnit.UNIT;
            });
        }
        return string;
    }

    private String getPrincipalWithoutRealm(String fullPrincipal) {
        KerberosName fullKerberosName = new KerberosName(fullPrincipal);
        String serviceName = fullKerberosName.getServiceName();
        String hostName = fullKerberosName.getHostName();
        if (hostName != null) {
            return new StringBuilder(1).append(serviceName).append("/").append(hostName).toString();
        }
        return serviceName;
    }

    private String getPrincipalWithoutRealmAndHost(String fullPrincipal) {
        String string;
        try {
            string = new KerberosName(fullPrincipal).getShortName();
        }
        catch (IOException e) {
            throw new HttpAuthenticationException((Throwable)e);
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$run$1(GSSContext ctx) {
        try {
            ctx.dispose();
        }
        catch (GSSException gSSException) {}
    }

    public HttpKerberosServerAction(HttpServletRequest request, UserGroupInformation serviceUGI, String authType) {
        this.request = request;
        this.serviceUGI = serviceUGI;
        this.authType = authType;
    }
}

