/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.cli;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLServerSocket;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.rpc.thrift.TDownloadDataReq;
import org.apache.hive.service.rpc.thrift.TDownloadDataResp;
import org.apache.hive.service.rpc.thrift.TUploadDataReq;
import org.apache.hive.service.rpc.thrift.TUploadDataResp;
import org.apache.hive.service.server.ThreadFactoryWithGarbageCleanup;
import org.apache.livy.LivyConf$;
import org.apache.livy.client.common.ClientConf;
import org.apache.livy.thriftserver.LivyCLIService;
import org.apache.livy.thriftserver.auth.AuthFactory;
import org.apache.livy.thriftserver.cli.ThreadPoolExecutorWithOomHook;
import org.apache.livy.thriftserver.cli.ThriftCLIServerContext;
import org.apache.livy.thriftserver.cli.ThriftCLIService;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\b\u0011\u0001mA\u0001\u0002\t\u0001\u0003\u0006\u0004%\t%\t\u0005\nM\u0001\u0011\t\u0011)A\u0005E\u001dB\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005U!)1\u0007\u0001C\u0001i!I\u0001\b\u0001a\u0001\u0002\u0004%\t\"\u000f\u0005\n\u0003\u0002\u0001\r\u00111A\u0005\u0012\tC\u0011b\u0013\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001e\t\u00111\u0003\u0001R1A\u0005B5CQ\u0001\u0016\u0001\u0005\u0012UCQA\u0016\u0001\u0005BUCQa\u0016\u0001\u0005\u0012UCQ\u0001\u0017\u0001\u0005BeCq!!\r\u0001\t\u0003\t\u0019D\u0001\fUQJLg\r\u001e\"j]\u0006\u0014\u0018p\u0011'J'\u0016\u0014h/[2f\u0015\t\t\"#A\u0002dY&T!a\u0005\u000b\u0002\u0019QD'/\u001b4ug\u0016\u0014h/\u001a:\u000b\u0005U1\u0012\u0001\u00027jmfT!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sO\u000e\u00011C\u0001\u0001\u001d!\tib$D\u0001\u0011\u0013\ty\u0002C\u0001\tUQJLg\r^\"M\u0013N+'O^5dK\u0006Q1\r\\5TKJ4\u0018nY3\u0016\u0003\t\u0002\"a\t\u0013\u000e\u0003II!!\n\n\u0003\u001d1Kg/_\"M\u0013N+'O^5dK\u0006Y1\r\\5TKJ4\u0018nY3!\u0013\t\u0001c$A\u0004p_6Dun\\6\u0016\u0003)\u0002\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\t1\fgn\u001a\u0006\u0002_\u0005!!.\u0019<b\u0013\t\tDF\u0001\u0005Sk:t\u0017M\u00197f\u0003!yw.\u001c%p_.\u0004\u0013A\u0002\u001fj]&$h\bF\u00026m]\u0002\"!\b\u0001\t\u000b\u0001*\u0001\u0019\u0001\u0012\t\u000b!*\u0001\u0019\u0001\u0016\u0002\rM,'O^3s+\u0005Q\u0004CA\u001e@\u001b\u0005a$B\u0001\u001d>\u0015\tqd#\u0001\u0004uQJLg\r^\u0005\u0003\u0001r\u0012q\u0001V*feZ,'/\u0001\u0006tKJ4XM]0%KF$\"aQ%\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\tUs\u0017\u000e\u001e\u0005\b\u0015\u001e\t\t\u00111\u0001;\u0003\rAH%M\u0001\bg\u0016\u0014h/\u001a:!\u0003=A\u0017N^3BkRDg)Y2u_JLX#\u0001(\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E\u0013\u0012\u0001B1vi\"L!a\u0015)\u0003\u0017\u0005+H\u000f\u001b$bGR|'/_\u0001\u000bS:LGoU3sm\u0016\u0014H#A\"\u0002\u0007I,h.\u0001\u0006ti>\u00048+\u001a:wKJ\f!\"\u00169m_\u0006$G)\u0019;b)\tQV\r\u0005\u0002\\G6\tAL\u0003\u0002?;*\u0011alX\u0001\u0004eB\u001c'B\u00011b\u0003\u001d\u0019XM\u001d<jG\u0016T!A\u0019\f\u0002\t!Lg/Z\u0005\u0003Ir\u0013q\u0002V+qY>\fG\rR1uCJ+7\u000f\u001d\u0005\u0006M6\u0001\raZ\u0001\u0004e\u0016\f\bCA.i\u0013\tIGL\u0001\bU+Bdw.\u00193ECR\f'+Z9)\u00075Y'\u000fE\u0002EY:L!!\\#\u0003\rQD'o\\<t!\ty\u0007/D\u0001>\u0013\t\tXH\u0001\u0006U\u000bb\u001cW\r\u001d;j_:\fTAH:\u007f\u0003_\u0001\"\u0001^>\u000f\u0005UL\bC\u0001<F\u001b\u00059(B\u0001=\u001b\u0003\u0019a$o\\8u}%\u0011!0R\u0001\u0007!J,G-\u001a4\n\u0005ql(AB*ue&twM\u0003\u0002{\u000bFB1e`A\u0004\u0003K\tI!\u0006\u0003\u0002\u0002\u0005\rQ#A:\u0005\u000f\u0005\u0015!D1\u0001\u0002\u0010\t\tA+\u0003\u0003\u0002\n\u0005-\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0002\u000e\u0015\u000ba\u0001\u001e5s_^\u001c\u0018\u0003BA\t\u0003/\u00012\u0001RA\n\u0013\r\t)\"\u0012\u0002\b\u001d>$\b.\u001b8h!\u0011\tI\"a\b\u000f\u0007\u0011\u000bY\"C\u0002\u0002\u001e\u0015\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\"\u0005\r\"!\u0003+ie><\u0018M\u00197f\u0015\r\ti\"R\u0019\nG\u0005\u001d\u0012\u0011FA\u0016\u0003\u001bq1\u0001RA\u0015\u0013\r\ti!R\u0019\u0006E\u0011+\u0015Q\u0006\u0002\u0006g\u000e\fG.Y\u0019\u0003M9\fA\u0002R8x]2|\u0017\r\u001a#bi\u0006$B!!\u000e\u0002<A\u00191,a\u000e\n\u0007\u0005eBLA\tU\t><h\u000e\\8bI\u0012\u000bG/\u0019*fgBDaA\u001a\bA\u0002\u0005u\u0002cA.\u0002@%\u0019\u0011\u0011\t/\u0003!Q#un\u001e8m_\u0006$G)\u0019;b%\u0016\f\b\u0006\u0002\bl\u0003\u000b\ndAH:\u0002H\u00055\u0013\u0007C\u0012\u0000\u0003\u000f\tI%!\u00032\u0013\r\n9#!\u000b\u0002L\u00055\u0011'\u0002\u0012E\u000b\u00065\u0012G\u0001\u0014o\u0001")
public class ThriftBinaryCLIService
extends ThriftCLIService {
    private AuthFactory hiveAuthFactory;
    private final Runnable oomHook;
    private TServer server;
    private volatile boolean bitmap$0;

    @Override
    public LivyCLIService cliService() {
        return super.cliService();
    }

    public Runnable oomHook() {
        return this.oomHook;
    }

    public TServer server() {
        return this.server;
    }

    public void server_$eq(TServer x$1) {
        this.server = x$1;
    }

    private AuthFactory hiveAuthFactory$lzycompute() {
        ThriftBinaryCLIService thriftBinaryCLIService = this;
        synchronized (thriftBinaryCLIService) {
            if (!this.bitmap$0) {
                this.hiveAuthFactory = new AuthFactory(this.livyConf());
                this.bitmap$0 = true;
            }
        }
        return this.hiveAuthFactory;
    }

    @Override
    public AuthFactory hiveAuthFactory() {
        if (!this.bitmap$0) {
            return this.hiveAuthFactory$lzycompute();
        }
        return this.hiveAuthFactory;
    }

    @Override
    public void initServer() {
        try {
            InetSocketAddress serverAddress;
            ThreadPoolExecutorWithOomHook executorService = new ThreadPoolExecutorWithOomHook(this.minWorkerThreads(), this.maxWorkerThreads(), this.workerKeepAliveTime(), TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new ThreadFactoryWithGarbageCleanup("LivyThriftserver-Handler-Pool"), this.oomHook());
            TTransportFactory transportFactory = this.hiveAuthFactory().getAuthTransFactory();
            TProcessorFactory processorFactory = this.hiveAuthFactory().getAuthProcFactory(this);
            TServerSocket serverSocket = null;
            InetSocketAddress inetSocketAddress = serverAddress = this.hiveHost() == null || this.hiveHost().isEmpty() ? new InetSocketAddress(this.portNum()) : new InetSocketAddress(this.hiveHost(), this.portNum());
            if (!this.livyConf().getBoolean((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_USE_SSL())) {
                serverSocket = new TServerSocket(serverAddress);
            } else {
                ArrayList sslVersionBlacklist = new ArrayList();
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.livyConf().get((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_SSL_PROTOCOL_BLACKLIST()).split(","))).foreach((Function1 & Serializable & scala.Serializable)sslVersion -> BoxesRunTime.boxToBoolean((boolean)sslVersionBlacklist.add(sslVersion.trim().toLowerCase())));
                String keyStorePath = this.livyConf().get((ClientConf.ConfEntry)LivyConf$.MODULE$.SSL_KEYSTORE()).trim();
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(34).append(LivyConf$.MODULE$.SSL_KEYSTORE().key()).append(" Not configured for SSL connection").toString());
                }
                String keyStorePassword = this.getKeyStorePassword();
                TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
                params.setKeyStore(keyStorePath, keyStorePassword);
                serverSocket = TSSLTransportFactory.getServerSocket((int)this.portNum(), (int)0, (InetAddress)serverAddress.getAddress(), (TSSLTransportFactory.TSSLTransportParameters)params);
                if (serverSocket.getServerSocket() instanceof SSLServerSocket) {
                    SSLServerSocket sslServerSocket = (SSLServerSocket)serverSocket.getServerSocket();
                    String[] enabledProtocols = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sslServerSocket.getEnabledProtocols())).filter((Function1 & Serializable & scala.Serializable)protocol -> BoxesRunTime.boxToBoolean((boolean)ThriftBinaryCLIService.$anonfun$initServer$2(this, sslVersionBlacklist, protocol)));
                    sslServerSocket.setEnabledProtocols(enabledProtocols);
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("SSL Server Socket Enabled Protocols: ").append(sslServerSocket.getEnabledProtocols()).toString());
                }
            }
            int maxMessageSize = this.livyConf().getInt((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_MAX_MESSAGE_SIZE());
            TThreadPoolServer.Args sargs = ((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverSocket).processorFactory(processorFactory).transportFactory(transportFactory).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory()).inputProtocolFactory((TProtocolFactory)new TBinaryProtocol.Factory(true, true, (long)maxMessageSize, (long)maxMessageSize))).executorService((ExecutorService)executorService);
            this.server_$eq((TServer)new TThreadPoolServer(sargs));
            this.server().setServerEventHandler(new TServerEventHandler(this){
                private final /* synthetic */ ThriftBinaryCLIService $outer;

                public ServerContext createContext(TProtocol input, TProtocol output) {
                    return new ThriftCLIServerContext();
                }

                public void deleteContext(ServerContext serverContext, TProtocol input, TProtocol output) {
                    ThriftCLIServerContext context = (ThriftCLIServerContext)serverContext;
                    SessionHandle sessionHandle = context.getSessionHandle();
                    if (sessionHandle != null) {
                        this.$outer.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Session disconnected without closing properly. ");
                        try {
                            boolean close = this.$outer.livyConf().getBoolean((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_CLOSE_SESSION_ON_DISCONNECT());
                            this.$outer.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Closing the session: ").append(sessionHandle).toString());
                            if (close) {
                                this.$outer.cliService().closeSession(sessionHandle);
                            }
                        }
                        catch (HiveSQLException e) {
                            this.$outer.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Failed to close session: ").append((Object)((Object)e)).toString(), e);
                        }
                        return;
                    }
                }

                public void preServe() {
                }

                public void processContext(ServerContext serverContext, TTransport input, TTransport output) {
                    this.$outer.currentServerContext().set(serverContext);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$deleteContext$1(), $anonfun$deleteContext$2(org.apache.hive.service.cli.SessionHandle ), $anonfun$deleteContext$3(org.apache.hive.service.cli.HiveSQLException )}, serializedLambda);
                }
            });
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Starting ").append(ThriftBinaryCLIService.class.getSimpleName()).append(" on port ").append(this.portNum()).append(" ").append("with ").append(this.minWorkerThreads()).append("...").append(this.maxWorkerThreads()).append(" worker threads").toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to init thrift server", e);
        }
    }

    @Override
    public void run() {
        try {
            this.server().serve();
        }
        catch (InterruptedException t) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Caught ").append(t.getClass().getSimpleName()).append(". Shutting down thrift server.").toString());
        }
        catch (Throwable t) {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Exception caught by ").append(this.getClass().getSimpleName()).append(". Exiting.").toString(), t);
            System.exit(-1);
        }
    }

    @Override
    public void stopServer() {
        this.server().stop();
        this.server_$eq(null);
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Thrift server has stopped");
    }

    public TUploadDataResp UploadData(TUploadDataReq req) throws TException {
        TUploadDataResp resp = new TUploadDataResp();
        try {
            SessionHandle sessionHandle = new SessionHandle(req.getSessionHandle());
            throw this.cliService().uploadData();
        }
        catch (Exception e) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error UploadData: ", e);
            resp.setStatus(HiveSQLException.toTStatus((Exception)e));
            return resp;
        }
    }

    public TDownloadDataResp DownloadData(TDownloadDataReq req) throws TException {
        TDownloadDataResp resp = new TDownloadDataResp();
        try {
            SessionHandle sessionHandle = new SessionHandle(req.getSessionHandle());
            throw this.cliService().downloadData();
        }
        catch (Exception e) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error download data: ", e);
            resp.setStatus(HiveSQLException.toTStatus((Exception)e));
            return resp;
        }
    }

    public static final /* synthetic */ boolean $anonfun$initServer$2(ThriftBinaryCLIService $this, ArrayList sslVersionBlacklist$1, String protocol) {
        if (sslVersionBlacklist$1.contains(protocol.toLowerCase())) {
            $this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Disabling SSL Protocol: ").append(protocol).toString());
            return false;
        }
        return true;
    }

    public ThriftBinaryCLIService(LivyCLIService cliService, Runnable oomHook) {
        this.oomHook = oomHook;
        super(cliService, ThriftBinaryCLIService.class.getSimpleName());
    }
}

