/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.cli;

import java.io.Serializable;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TDownloadDataReq;
import org.apache.hive.service.rpc.thrift.TDownloadDataResp;
import org.apache.hive.service.rpc.thrift.TUploadDataReq;
import org.apache.hive.service.rpc.thrift.TUploadDataResp;
import org.apache.hive.service.server.ThreadFactoryWithGarbageCleanup;
import org.apache.livy.LivyConf$;
import org.apache.livy.client.common.ClientConf;
import org.apache.livy.thriftserver.LivyCLIService;
import org.apache.livy.thriftserver.auth.AuthFactory;
import org.apache.livy.thriftserver.cli.ThreadPoolExecutorWithOomHook;
import org.apache.livy.thriftserver.cli.ThriftCLIService;
import org.apache.livy.thriftserver.cli.ThriftHttpCLIService$;
import org.apache.livy.thriftserver.cli.ThriftHttpServlet;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u000b\u0017\u0001\u0005B\u0001B\n\u0001\u0003\u0006\u0004%\te\n\u0005\nY\u0001\u0011\t\u0011)A\u0005Q5B\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tq\u0001\u0011\t\u0011)A\u0005a!)\u0011\b\u0001C\u0001u!Ia\b\u0001a\u0001\u0002\u0004%\tb\u0010\u0005\n\u0013\u0002\u0001\r\u00111A\u0005\u0012)C\u0011b\u0015\u0001A\u0002\u0003\u0005\u000b\u0015\u0002!\t\u0011Q\u0003\u0001R1A\u0005BUCQ\u0001\u0018\u0001\u0005\u0012uCQA\u0018\u0001\u0005BuCQa\u0018\u0001\u0005\n\u0001DQA\u001c\u0001\u0005\u0012uCQa\u001c\u0001\u0005BADq!!\u0014\u0001\t\u0003\tyeB\u0004\u0002lYA\t!!\u001c\u0007\rU1\u0002\u0012AA8\u0011\u0019I\u0014\u0003\"\u0001\u0002x!I\u0011\u0011P\tC\u0002\u0013%\u00111\u0010\u0005\t\u0003\u0003\u000b\u0002\u0015!\u0003\u0002~\t!B\u000b\u001b:jMRDE\u000f\u001e9D\u0019&\u001bVM\u001d<jG\u0016T!a\u0006\r\u0002\u0007\rd\u0017N\u0003\u0002\u001a5\u0005aA\u000f\u001b:jMR\u001cXM\u001d<fe*\u00111\u0004H\u0001\u0005Y&4\u0018P\u0003\u0002\u001e=\u00051\u0011\r]1dQ\u0016T\u0011aH\u0001\u0004_J<7\u0001A\n\u0003\u0001\t\u0002\"a\t\u0013\u000e\u0003YI!!\n\f\u0003!QC'/\u001b4u\u00072K5+\u001a:wS\u000e,\u0017AC2mSN+'O^5dKV\t\u0001\u0006\u0005\u0002*U5\t\u0001$\u0003\u0002,1\tqA*\u001b<z\u00072K5+\u001a:wS\u000e,\u0017aC2mSN+'O^5dK\u0002J!A\n\u0013\u0002\u000f=|W\u000eS8pWV\t\u0001\u0007\u0005\u00022m5\t!G\u0003\u00024i\u0005!A.\u00198h\u0015\u0005)\u0014\u0001\u00026bm\u0006L!a\u000e\u001a\u0003\u0011I+hN\\1cY\u0016\f\u0001b\\8n\u0011>|7\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007mbT\b\u0005\u0002$\u0001!)a%\u0002a\u0001Q!)a&\u0002a\u0001a\u000511/\u001a:wKJ,\u0012\u0001\u0011\t\u0003\u0003\u001ek\u0011A\u0011\u0006\u0003}\rS!\u0001R#\u0002\u000b),G\u000f^=\u000b\u0005\u0019s\u0012aB3dY&\u00048/Z\u0005\u0003\u0011\n\u0013aaU3sm\u0016\u0014\u0018AC:feZ,'o\u0018\u0013fcR\u00111*\u0015\t\u0003\u0019>k\u0011!\u0014\u0006\u0002\u001d\u0006)1oY1mC&\u0011\u0001+\u0014\u0002\u0005+:LG\u000fC\u0004S\u000f\u0005\u0005\t\u0019\u0001!\u0002\u0007a$\u0013'A\u0004tKJ4XM\u001d\u0011\u0002\u001f!Lg/Z!vi\"4\u0015m\u0019;pef,\u0012A\u0016\t\u0003/jk\u0011\u0001\u0017\u0006\u00033b\tA!Y;uQ&\u00111\f\u0017\u0002\f\u0003V$\bNR1di>\u0014\u00180\u0001\u0006j]&$8+\u001a:wKJ$\u0012aS\u0001\u0004eVt\u0017aC4fi\"#H\u000f\u001d)bi\"$\"!\u00197\u0011\u0005\tLgBA2h!\t!W*D\u0001f\u0015\t1\u0007%\u0001\u0004=e>|GOP\u0005\u0003Q6\u000ba\u0001\u0015:fI\u00164\u0017B\u00016l\u0005\u0019\u0019FO]5oO*\u0011\u0001.\u0014\u0005\u0006[2\u0001\r!Y\u0001\tQR$\b\u000fU1uQ\u0006Q1\u000f^8q'\u0016\u0014h/\u001a:\u0002\u0015U\u0003Hn\\1e\t\u0006$\u0018\r\u0006\u0002r{B\u0011!o_\u0007\u0002g*\u0011A/^\u0001\u0007i\"\u0014\u0018N\u001a;\u000b\u0005Y<\u0018a\u0001:qG*\u0011\u00010_\u0001\bg\u0016\u0014h/[2f\u0015\tQH$\u0001\u0003iSZ,\u0017B\u0001?t\u0005=!V\u000b\u001d7pC\u0012$\u0015\r^1SKN\u0004\b\"\u0002@\u000f\u0001\u0004y\u0018a\u0001:fcB\u0019!/!\u0001\n\u0007\u0005\r1O\u0001\bU+Bdw.\u00193ECR\f'+Z9)\u000b9\t9!a\u0006\u0011\u000b1\u000bI!!\u0004\n\u0007\u0005-QJ\u0001\u0004uQJ|wo\u001d\t\u0005\u0003\u001f\t\u0019\"\u0004\u0002\u0002\u0012)\u0011A\u000fH\u0005\u0005\u0003+\t\tB\u0001\u0006U\u000bb\u001cW\r\u001d;j_:\fdAH1\u0002\u001a\u0005-\u0013'C\u0012\u0002\u001c\u0005\r\u0012\u0011IA\u0013+\u0011\ti\"a\b\u0016\u0003\u0005$q!!\t!\u0005\u0004\tYCA\u0001U\u0013\u0011\t)#a\n\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\tI#T\u0001\u0007i\"\u0014xn^:\u0012\t\u00055\u00121\u0007\t\u0004\u0019\u0006=\u0012bAA\u0019\u001b\n9aj\u001c;iS:<\u0007\u0003BA\u001b\u0003wq1\u0001TA\u001c\u0013\r\tI$T\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti$a\u0010\u0003\u0013QC'o\\<bE2,'bAA\u001d\u001bFJ1%a\u0011\u0002F\u0005\u001d\u0013\u0011\u0006\b\u0004\u0019\u0006\u0015\u0013bAA\u0015\u001bF*!\u0005T'\u0002J\t)1oY1mCF\u001aa%!\u0004\u0002\u0019\u0011{wO\u001c7pC\u0012$\u0015\r^1\u0015\t\u0005E\u0013q\u000b\t\u0004e\u0006M\u0013bAA+g\n\tB\u000bR8x]2|\u0017\r\u001a#bi\u0006\u0014Vm\u001d9\t\ry|\u0001\u0019AA-!\r\u0011\u00181L\u0005\u0004\u0003;\u001a(\u0001\u0005+E_^tGn\\1e\t\u0006$\u0018MU3rQ\u0015y\u0011qAA1c\u0019q\u0012-a\u0019\u0002jEJ1%a\u0007\u0002$\u0005\u0015\u0014QE\u0019\nG\u0005\r\u0013QIA4\u0003S\tTA\t'N\u0003\u0013\n4AJA\u0007\u0003Q!\u0006N]5gi\"#H\u000f]\"M\u0013N+'O^5dKB\u00111%E\n\u0004#\u0005E\u0004c\u0001'\u0002t%\u0019\u0011QO'\u0003\r\u0005s\u0017PU3g)\t\ti'\u0001\nB!Bc\u0015jQ!U\u0013>su\f\u0016%S\u0013\u001a#VCAA?!\r\t\u0014qP\u0005\u0003UJ\n1#\u0011)Q\u0019&\u001b\u0015\tV%P\u001d~#\u0006JU%G)\u0002\u0002")
public class ThriftHttpCLIService
extends ThriftCLIService {
    private AuthFactory hiveAuthFactory;
    private final Runnable oomHook;
    private Server server;
    private volatile boolean bitmap$0;

    @Override
    public LivyCLIService cliService() {
        return super.cliService();
    }

    public Runnable oomHook() {
        return this.oomHook;
    }

    public Server server() {
        return this.server;
    }

    public void server_$eq(Server x$1) {
        this.server = x$1;
    }

    private AuthFactory hiveAuthFactory$lzycompute() {
        ThriftHttpCLIService thriftHttpCLIService = this;
        synchronized (thriftHttpCLIService) {
            if (!this.bitmap$0) {
                this.hiveAuthFactory = new AuthFactory(this.livyConf());
                this.bitmap$0 = true;
            }
        }
        return this.hiveAuthFactory;
    }

    @Override
    public AuthFactory hiveAuthFactory() {
        if (!this.bitmap$0) {
            return this.hiveAuthFactory$lzycompute();
        }
        return this.hiveAuthFactory;
    }

    @Override
    public void initServer() {
        try {
            ServerConnector serverConnector;
            String schemeName;
            ThreadPoolExecutorWithOomHook executorService = new ThreadPoolExecutorWithOomHook(this.minWorkerThreads(), this.maxWorkerThreads(), this.workerKeepAliveTime(), TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new ThreadFactoryWithGarbageCleanup("LivyThriftserver-HttpHandler-Pool"), this.oomHook());
            ExecutorThreadPool threadPool = new ExecutorThreadPool((ThreadPoolExecutor)executorService);
            this.server_$eq(new Server((ThreadPool)threadPool));
            HttpConfiguration conf = new HttpConfiguration();
            int requestHeaderSize = this.livyConf().getInt((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_HTTP_REQUEST_HEADER_SIZE());
            int responseHeaderSize = this.livyConf().getInt((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_HTTP_RESPONSE_HEADER_SIZE());
            conf.setRequestHeaderSize(requestHeaderSize);
            conf.setResponseHeaderSize(responseHeaderSize);
            HttpConnectionFactory http = new HttpConnectionFactory(conf);
            boolean useSsl = this.livyConf().getBoolean((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_USE_SSL());
            String string = schemeName = useSsl ? "https" : "http";
            if (useSsl) {
                String keyStorePath = this.livyConf().get((ClientConf.ConfEntry)LivyConf$.MODULE$.SSL_KEYSTORE()).trim();
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(34).append(LivyConf$.MODULE$.SSL_KEYSTORE().key()).append(" Not configured for SSL connection").toString());
                }
                String keyStorePassword = this.getKeyStorePassword();
                SslContextFactory sslContextFactory = new SslContextFactory();
                String[] excludedProtocols = this.livyConf().get((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_SSL_PROTOCOL_BLACKLIST()).split(",");
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("HTTP Server SSL: adding excluded protocols: ").append(excludedProtocols).toString());
                sslContextFactory.addExcludeProtocols(excludedProtocols);
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("HTTP Server SSL: SslContextFactory.getExcludeProtocols = ").append(sslContextFactory.getExcludeProtocols()).toString());
                sslContextFactory.setKeyStorePath(keyStorePath);
                sslContextFactory.setKeyStorePassword(keyStorePassword);
                serverConnector = new ServerConnector(this.server(), sslContextFactory, new ConnectionFactory[]{http});
            } else {
                serverConnector = new ServerConnector(this.server(), new ConnectionFactory[]{http});
            }
            ServerConnector connector = serverConnector;
            connector.setPort(this.portNum());
            connector.setReuseAddress(true);
            int maxIdleTime = (int)this.livyConf().getTimeAsMs((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_HTTP_MAX_IDLE_TIME());
            connector.setIdleTimeout((long)maxIdleTime);
            this.server().addConnector((Connector)connector);
            TCLIService.Processor processor = new TCLIService.Processor((TCLIService.Iface)this);
            TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory();
            UserGroupInformation serviceUGI = this.cliService().getServiceUGI();
            UserGroupInformation httpUGI = this.cliService().getHttpUGI();
            String authType = this.livyConf().get((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_AUTHENTICATION());
            ThriftHttpServlet thriftHttpServlet = new ThriftHttpServlet((TProcessor)processor, (TProtocolFactory)protocolFactory, authType, serviceUGI, httpUGI, this.hiveAuthFactory(), this.livyConf());
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            if (this.livyConf().getBoolean((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_XSRF_FILTER_ENABLED())) {
                this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "XSRF filter enabled");
            } else {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "XSRF filter disabled");
            }
            String httpPath = this.getHttpPath(this.livyConf().get((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_HTTP_PATH()));
            if (this.livyConf().getBoolean((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_XSRF_FILTER_ENABLED())) {
                GzipHandler gzipHandler = new GzipHandler();
                gzipHandler.setHandler((Handler)context);
                gzipHandler.addIncludedMethods(new String[]{"POST"});
                gzipHandler.addIncludedMimeTypes(new String[]{ThriftHttpCLIService$.MODULE$.org$apache$livy$thriftserver$cli$ThriftHttpCLIService$$APPLICATION_THRIFT()});
                this.server().setHandler((Handler)gzipHandler);
            } else {
                this.server().setHandler((Handler)context);
            }
            context.addServlet(new ServletHolder((Servlet)thriftHttpServlet), httpPath);
            this.server().start();
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Started ").append(ThriftHttpCLIService.class.getSimpleName()).append(" in ").append(schemeName).append(" mode on port ").append(this.portNum()).append(" path=").append(httpPath).append(" with ").append(this.minWorkerThreads()).append("...").append(this.maxWorkerThreads()).append(" worker threads").toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to init HttpServer", e);
        }
    }

    @Override
    public void run() {
        try {
            this.server().join();
        }
        catch (InterruptedException t) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Caught ").append(t.getClass().getSimpleName()).append(". Shutting down thrift server.").toString());
        }
        catch (Throwable t) {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Exception caught by ").append(this.getClass().getSimpleName()).append(". Exiting.").toString(), t);
            System.exit(-1);
        }
    }

    private String getHttpPath(String httpPath) {
        Some some;
        String string;
        Option option = Option$.MODULE$.apply((Object)httpPath);
        if (None$.MODULE$.equals(option) ? true : option instanceof Some && "".equals(string = (String)(some = (Some)option).value())) {
            return "/*";
        }
        if (option instanceof Some) {
            String withStartingSlash;
            Some some2 = (Some)option;
            String path = (String)some2.value();
            String string2 = withStartingSlash = !path.startsWith("/") ? new StringBuilder(1).append("/").append(path).toString() : path;
            if (httpPath.endsWith("/")) {
                return new StringBuilder(1).append(withStartingSlash).append("*").toString();
            }
            if (!httpPath.endsWith("/*")) {
                return new StringBuilder(2).append(withStartingSlash).append("/*").toString();
            }
            return withStartingSlash;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public void stopServer() {
        if (this.server() != null && this.server().isStarted()) {
            try {
                this.server().stop();
                this.server_$eq(null);
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Thrift HTTP server has been stopped");
            }
            catch (Exception e) {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error stopping HTTP server: ", e);
            }
            return;
        }
    }

    public TUploadDataResp UploadData(TUploadDataReq req) throws TException {
        TUploadDataResp resp = new TUploadDataResp();
        try {
            SessionHandle sessionHandle = new SessionHandle(req.getSessionHandle());
            throw this.cliService().uploadData();
        }
        catch (Exception e) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error UploadData: ", e);
            resp.setStatus(HiveSQLException.toTStatus((Exception)e));
            return resp;
        }
    }

    public TDownloadDataResp DownloadData(TDownloadDataReq req) throws TException {
        TDownloadDataResp resp = new TDownloadDataResp();
        try {
            SessionHandle sessionHandle = new SessionHandle(req.getSessionHandle());
            throw this.cliService().downloadData();
        }
        catch (Exception e) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error download data: ", e);
            resp.setStatus(HiveSQLException.toTStatus((Exception)e));
            return resp;
        }
    }

    public ThriftHttpCLIService(LivyCLIService cliService, Runnable oomHook) {
        this.oomHook = oomHook;
        super(cliService, ThriftHttpCLIService.class.getSimpleName());
    }
}

