/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.cli;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Hashtable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.ws.rs.core.NewCookie;
import org.apache.hive.service.auth.HiveAuthConstants;
import org.apache.hive.service.auth.HttpAuthenticationException;
import org.apache.livy.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class ThriftHttpServlet$
implements Logging,
scala.Serializable {
    public static ThriftHttpServlet$ MODULE$;
    private final String XSRF_HEADER_DEFAULT;
    private final Set<String> XSRF_METHODS_TO_IGNORE_DEFAULT;
    private final String AUTH_COOKIE;
    private final SecureRandom RAN;
    private final String HIVE_DELEGATION_TOKEN_HEADER;
    private final String X_FORWARDED_FOR;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ThriftHttpServlet$();
    }

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        ThriftHttpServlet$ thriftHttpServlet$ = this;
        synchronized (thriftHttpServlet$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private String XSRF_HEADER_DEFAULT() {
        return this.XSRF_HEADER_DEFAULT;
    }

    private Set<String> XSRF_METHODS_TO_IGNORE_DEFAULT() {
        return this.XSRF_METHODS_TO_IGNORE_DEFAULT;
    }

    public String AUTH_COOKIE() {
        return this.AUTH_COOKIE;
    }

    public SecureRandom RAN() {
        return this.RAN;
    }

    public String HIVE_DELEGATION_TOKEN_HEADER() {
        return this.HIVE_DELEGATION_TOKEN_HEADER;
    }

    public String X_FORWARDED_FOR() {
        return this.X_FORWARDED_FOR;
    }

    public String org$apache$livy$thriftserver$cli$ThriftHttpServlet$$getHttpOnlyCookieHeader(Cookie cookie) {
        NewCookie newCookie = new NewCookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion(), cookie.getComment(), cookie.getMaxAge(), cookie.getSecure());
        return Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)newCookie), "; HttpOnly");
    }

    public String org$apache$livy$thriftserver$cli$ThriftHttpServlet$$getDoAsQueryParam(String queryString) {
        block0: {
            if (!this.logger().isDebugEnabled()) break block0;
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("URL query string:").append(queryString).toString());
        }
        return (String)Option$.MODULE$.apply((Object)queryString).flatMap((Function1 & Serializable & scala.Serializable)qs -> {
            Hashtable params = HttpUtils.parseQueryString((String)qs);
            return ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(params.keySet()).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.equalsIgnoreCase("doAs"))).map((Function1 & Serializable & scala.Serializable)x$3 -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params.get(x$3))).head());
        }).orNull(Predef$.MODULE$.$conforms());
    }

    public boolean org$apache$livy$thriftserver$cli$ThriftHttpServlet$$doXsrfFilter(HttpServletRequest request, HttpServletResponse response) {
        if (this.XSRF_METHODS_TO_IGNORE_DEFAULT().contains((Object)request.getMethod()) || request.getHeader(this.XSRF_HEADER_DEFAULT()) != null) {
            return true;
        }
        response.sendError(400, "Missing Required Header for Vulnerability Protection");
        response.getWriter().println(new StringBuilder(51).append("XSRF filter denial, requests must contain header : ").append(this.XSRF_HEADER_DEFAULT()).toString());
        return false;
    }

    public String getAuthHeader(HttpServletRequest request, String authType) throws HttpAuthenticationException {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || authHeader.isEmpty()) {
            throw new HttpAuthenticationException("Authorization header received from the client is empty.");
        }
        int beginIndex = this.org$apache$livy$thriftserver$cli$ThriftHttpServlet$$isKerberosAuthMode(authType) ? "Negotiate ".length() : "Basic ".length();
        String authHeaderBase64String = authHeader.substring(beginIndex);
        if (authHeaderBase64String == null || authHeaderBase64String.isEmpty()) {
            throw new HttpAuthenticationException("Authorization header received from the client does not contain any data.");
        }
        return authHeaderBase64String;
    }

    public boolean org$apache$livy$thriftserver$cli$ThriftHttpServlet$$isKerberosAuthMode(String authType) {
        return authType.equalsIgnoreCase(HiveAuthConstants.AuthTypes.KERBEROS.toString());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ThriftHttpServlet$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.XSRF_HEADER_DEFAULT = "X-XSRF-HEADER";
        this.XSRF_METHODS_TO_IGNORE_DEFAULT = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GET", "OPTIONS", "HEAD", "TRACE"}));
        this.AUTH_COOKIE = "hive.server2.auth";
        this.RAN = new SecureRandom();
        this.HIVE_DELEGATION_TOKEN_HEADER = "X-Hive-Delegation-Token";
        this.X_FORWARDED_FOR = "X-Forwarded-For";
    }
}

