/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.cli;

import java.io.IOException;
import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.CookieSigner;
import org.apache.hive.service.auth.HiveAuthConstants;
import org.apache.hive.service.auth.HttpAuthUtils;
import org.apache.hive.service.auth.HttpAuthenticationException;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.client.common.ClientConf;
import org.apache.livy.thriftserver.SessionInfo$;
import org.apache.livy.thriftserver.auth.AuthFactory;
import org.apache.livy.thriftserver.auth.AuthenticationProvider$;
import org.apache.livy.thriftserver.cli.HttpKerberosServerAction;
import org.apache.livy.thriftserver.cli.ThriftHttpServlet$;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServlet;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\tuh\u0001\u0002 @\u0001)C\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\t9\u0002\u0011\t\u0011)A\u0005;\"A1\r\u0001BC\u0002\u0013\u0005A\r\u0003\u0005s\u0001\t\u0005\t\u0015!\u0003f\u0011!\u0019\bA!b\u0001\n\u0003!\b\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011B;\t\u0011y\u0004!Q1A\u0005\u0002QD\u0001b \u0001\u0003\u0002\u0003\u0006I!\u001e\u0005\u000b\u0003\u0003\u0001!Q1A\u0005\u0002\u0005\r\u0001BCA\t\u0001\t\u0005\t\u0015!\u0003\u0002\u0006!Q\u00111\u0003\u0001\u0003\u0006\u0004%\t!!\u0006\t\u0015\u0005u\u0001A!A!\u0002\u0013\t9\u0002C\u0004\u0002 \u0001!\t!!\t\t\u0013\u0005U\u0002A1A\u0005\n\u0005]\u0002\u0002CA!\u0001\u0001\u0006I!!\u000f\t\u0013\u0005\r\u0003A1A\u0005\n\u0005\u0015\u0003\u0002CA,\u0001\u0001\u0006I!a\u0012\t\u0013\u0005e\u0003A1A\u0005\n\u0005m\u0003\u0002CA6\u0001\u0001\u0006I!!\u0018\t\u0013\u00055\u0004A1A\u0005\n\u0005m\u0003\u0002CA8\u0001\u0001\u0006I!!\u0018\t\u0013\u0005E\u0004A1A\u0005\n\u0005M\u0004\u0002CA>\u0001\u0001\u0006I!!\u001e\t\u0013\u0005u\u0004A1A\u0005\n\u0005]\u0002\u0002CA@\u0001\u0001\u0006I!!\u000f\t\u0013\u0005\u0005\u0005A1A\u0005\n\u0005]\u0002\u0002CAB\u0001\u0001\u0006I!!\u000f\t\u0013\u0005\u0015\u0005A1A\u0005\n\u0005]\u0002\u0002CAD\u0001\u0001\u0006I!!\u000f\t\u000f\u0005%\u0005\u0001\"\u0015\u0002\f\"9!1\u0003\u0001\u0005\n\tU\u0001b\u0002B\u0014\u0001\u0011%!\u0011\u0006\u0005\b\u0005[\u0001A\u0011\u0002B\u0018\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005kAqAa\u000f\u0001\t\u0013\u0011i\u0004C\u0004\u0003D\u0001!IA!\u0012\t\u000f\t-\u0003\u0001\"\u0003\u0003N!9!\u0011\u000b\u0001\u0005\n\tM\u0003b\u0002B-\u0001\u0011%!1\f\u0005\b\u0005C\u0002A\u0011\u0002B2\u000f\u001d\u0011Yg\u0010E\u0001\u0005[2aAP \t\u0002\t=\u0004bBA\u0010U\u0011\u0005!Q\u0010\u0005\n\u0005\u007fR#\u0019!C\u0005\u00037B\u0001B!!+A\u0003%\u0011Q\f\u0005\n\u0005\u0007S#\u0019!C\u0005\u0005\u000bC\u0001Ba&+A\u0003%!q\u0011\u0005\n\u00053S#\u0019!C\u0001\u00037B\u0001Ba'+A\u0003%\u0011Q\f\u0005\n\u0005;S#\u0019!C\u0001\u0005?C\u0001Ba++A\u0003%!\u0011\u0015\u0005\t\u0005[S#\u0019!C\u0001I\"9!q\u0016\u0016!\u0002\u0013)\u0007\u0002\u0003BYU\t\u0007I\u0011\u00013\t\u000f\tM&\u0006)A\u0005K\"9!Q\u0017\u0016\u0005\n\t]\u0006b\u0002B_U\u0011%!q\u0018\u0005\b\u0005\u000bTC\u0011\u0002Bd\u0011!\u0011iM\u000bC\u0001\u007f\t=\u0007b\u0002BwU\u0011%!q\u001e\u0005\n\u0005gT\u0013\u0011!C\u0005\u0005k\u0014\u0011\u0003\u00165sS\u001a$\b\n\u001e;q'\u0016\u0014h\u000f\\3u\u0015\t\u0001\u0015)A\u0002dY&T!AQ\"\u0002\u0019QD'/\u001b4ug\u0016\u0014h/\u001a:\u000b\u0005\u0011+\u0015\u0001\u00027jmfT!AR$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0015aA8sO\u000e\u00011c\u0001\u0001L'B\u0011A*U\u0007\u0002\u001b*\u0011ajT\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005A+\u0015A\u0002;ie&4G/\u0003\u0002S\u001b\nAAkU3sm2,G\u000f\u0005\u0002U+6\t1)\u0003\u0002W\u0007\n9Aj\\4hS:<\u0017!\u00039s_\u000e,7o]8s!\tI&,D\u0001P\u0013\tYvJ\u0001\u0006U!J|7-Z:t_J\fq\u0002\u001d:pi>\u001cw\u000e\u001c$bGR|'/\u001f\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A>\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003E~\u0013\u0001\u0003\u0016)s_R|7m\u001c7GC\u000e$xN]=\u0002\u0011\u0005,H\u000f\u001b+za\u0016,\u0012!\u001a\t\u0003M>t!aZ7\u0011\u0005!\\W\"A5\u000b\u0005)L\u0015A\u0002\u001fs_>$hHC\u0001m\u0003\u0015\u00198-\u00197b\u0013\tq7.\u0001\u0004Qe\u0016$WMZ\u0005\u0003aF\u0014aa\u0015;sS:<'B\u00018l\u0003%\tW\u000f\u001e5UsB,\u0007%\u0001\u0006tKJ4\u0018nY3V\u000f&+\u0012!\u001e\t\u0003mnl\u0011a\u001e\u0006\u0003qf\f\u0001b]3dkJLG/\u001f\u0006\u0003u\u0016\u000ba\u0001[1e_>\u0004\u0018B\u0001?x\u0005Q)6/\u001a:He>,\b/\u00138g_Jl\u0017\r^5p]\u0006Y1/\u001a:wS\u000e,WkR%!\u0003\u001dAG\u000f\u001e9V\u000f&\u000b\u0001\u0002\u001b;uaV;\u0015\nI\u0001\fCV$\bNR1di>\u0014\u00180\u0006\u0002\u0002\u0006A!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f\u0005\u000bA!Y;uQ&!\u0011qBA\u0005\u0005-\tU\u000f\u001e5GC\u000e$xN]=\u0002\u0019\u0005,H\u000f\u001b$bGR|'/\u001f\u0011\u0002\u00111Lg/_\"p]\u001a,\"!a\u0006\u0011\u0007Q\u000bI\"C\u0002\u0002\u001c\r\u0013\u0001\u0002T5ws\u000e{gNZ\u0001\nY&4\u0018pQ8oM\u0002\na\u0001P5oSRtD\u0003EA\u0012\u0003O\tI#a\u000b\u0002.\u0005=\u0012\u0011GA\u001a!\r\t)\u0003A\u0007\u0002\u007f!)q+\u0004a\u00011\")A,\u0004a\u0001;\")1-\u0004a\u0001K\")1/\u0004a\u0001k\")a0\u0004a\u0001k\"9\u0011\u0011A\u0007A\u0002\u0005\u0015\u0001bBA\n\u001b\u0001\u0007\u0011qC\u0001\u0014SN\u001cun\\6jK\u0006+H\u000f[#oC\ndW\rZ\u000b\u0003\u0003s\u0001B!a\u000f\u0002>5\t1.C\u0002\u0002@-\u0014qAQ8pY\u0016\fg.\u0001\u000bjg\u000e{wn[5f\u0003V$\b.\u00128bE2,G\rI\u0001\u0007g&<g.\u001a:\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003'j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\bg\u0016\u0014h/[2f\u0015\r\t\t&R\u0001\u0005Q&4X-\u0003\u0003\u0002V\u0005-#\u0001D\"p_.LWmU5h]\u0016\u0014\u0018aB:jO:,'\u000fI\u0001\rG>|7.[3E_6\f\u0017N\\\u000b\u0003\u0003;\u0002B!a\u0018\u0002j5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'\u0001\u0003mC:<'BAA4\u0003\u0011Q\u0017M^1\n\u0007A\f\t'A\u0007d_>\\\u0017.\u001a#p[\u0006Lg\u000eI\u0001\u000bG>|7.[3QCRD\u0017aC2p_.LW\rU1uQ\u0002\nAbY8pW&,W*\u0019=BO\u0016,\"!!\u001e\u0011\t\u0005m\u0012qO\u0005\u0004\u0003sZ'aA%oi\u0006i1m\\8lS\u0016l\u0015\r_!hK\u0002\na\"[:D_>\\\u0017.Z*fGV\u0014X-A\bjg\u000e{wn[5f'\u0016\u001cWO]3!\u0003AI7\u000f\u0013;ua>sG._\"p_.LW-A\tjg\"#H\u000f](oYf\u001cun\\6jK\u0002\n\u0011\u0003_:sM\u001aKG\u000e^3s\u000b:\f'\r\\3e\u0003IA8O\u001d4GS2$XM]#oC\ndW\r\u001a\u0011\u0002\r\u0011|\u0007k\\:u)\u0019\ti)a%\u0002,B!\u00111HAH\u0013\r\t\tj\u001b\u0002\u0005+:LG\u000fC\u0004\u0002\u0016z\u0001\r!a&\u0002\u000fI,\u0017/^3tiB!\u0011\u0011TAT\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006}\u0015\u0001\u00025uiBTA!!)\u0002$\u000691/\u001a:wY\u0016$(BAAS\u0003\u0015Q\u0017M^1y\u0013\u0011\tI+a'\u0003%!#H\u000f]*feZdW\r\u001e*fcV,7\u000f\u001e\u0005\b\u0003[s\u0002\u0019AAX\u0003!\u0011Xm\u001d9p]N,\u0007\u0003BAM\u0003cKA!a-\u0002\u001c\n\u0019\u0002\n\u001e;q'\u0016\u0014h\u000f\\3u%\u0016\u001c\bo\u001c8tK\"*a$a.\u0002FB1\u00111HA]\u0003{K1!a/l\u0005\u0019!\bN]8xgB!\u0011qXAa\u001b\t\ty*\u0003\u0003\u0002D\u0006}%\u0001E*feZdW\r^#yG\u0016\u0004H/[8oc\u0019qR-a2\u0002xFJ1%!3\u0002P\u00065\u0018\u0011[\u000b\u0004I\u0006-GaBAg\u0013\n\u0007\u0011q\u001b\u0002\u0002)&!\u0011\u0011[Aj\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u0011Q[6\u0002\rQD'o\\<t#\u0011\tI.a8\u0011\t\u0005m\u00121\\\u0005\u0004\u0003;\\'a\u0002(pi\"Lgn\u001a\t\u0005\u0003C\f9O\u0004\u0003\u0002<\u0005\r\u0018bAAsW\u00069\u0001/Y2lC\u001e,\u0017\u0002BAu\u0003W\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005\u00158.M\u0005$\u0003_\f\t0a=\u0002V:!\u00111HAy\u0013\r\t)n[\u0019\u0007E\u0005m2.!>\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\ni\fK\u0003\u001f\u0003w\u0014I\u0001\u0005\u0004\u0002<\u0005e\u0016Q \t\u0005\u0003\u007f\u0014)!\u0004\u0002\u0003\u0002)!!1AA3\u0003\tIw.\u0003\u0003\u0003\b\t\u0005!aC%P\u000bb\u001cW\r\u001d;j_:\fdAH3\u0003\f\tE\u0011'C\u0012\u0002J\u0006='QBAic%\u0019\u0013q^Ay\u0005\u001f\t).\r\u0004#\u0003wY\u0017Q_\u0019\u0004M\u0005u\u0018aF4fi\u000ec\u0017.\u001a8u\u001d\u0006lWM\u0012:p[\u000e{wn[5f)\r)'q\u0003\u0005\b\u00053y\u0002\u0019\u0001B\u000e\u0003\u001d\u0019wn\\6jKN\u0004b!a\u000f\u0003\u001e\t\u0005\u0012b\u0001B\u0010W\n)\u0011I\u001d:bsB!\u0011\u0011\u0014B\u0012\u0013\u0011\u0011)#a'\u0003\r\r{wn[5f\u0003-!xnQ8pW&,7\u000b\u001e:\u0015\u0007\u0015\u0014Y\u0003C\u0004\u0003\u001a\u0001\u0002\rAa\u0007\u0002\u001dY\fG.\u001b3bi\u0016\u001cun\\6jKR\u0019QM!\r\t\u000f\u0005U\u0015\u00051\u0001\u0002\u0018\u0006a1M]3bi\u0016\u001cun\\6jKR!!\u0011\u0005B\u001c\u0011\u0019\u0011ID\ta\u0001K\u0006\u00191\u000f\u001e:\u0002\u0019\u0011|\u0007+Y:to\u0012\fU\u000f\u001e5\u0015\u000b\u0015\u0014yD!\u0011\t\u000f\u0005U5\u00051\u0001\u0002\u0018\")1m\ta\u0001K\u0006YAm\u001c+pW\u0016t\u0017)\u001e;i)\u0015)'q\tB%\u0011\u001d\t)\n\na\u0001\u0003/Cq!!,%\u0001\u0004\ty+\u0001\be_.+'OY3s_N\fU\u000f\u001e5\u0015\u0007\u0015\u0014y\u0005C\u0004\u0002\u0016\u0016\u0002\r!a&\u0002\u0017\u001d,G/V:fe:\fW.\u001a\u000b\u0006K\nU#q\u000b\u0005\b\u0003+3\u0003\u0019AAL\u0011\u0015\u0019g\u00051\u0001f\u0003-9W\r\u001e)bgN<xN\u001d3\u0015\u000b\u0015\u0014iFa\u0018\t\u000f\u0005Uu\u00051\u0001\u0002\u0018\")1m\na\u0001K\u0006\u0019r-\u001a;BkRD\u0007*Z1eKJ$vn[3ogR1!Q\rB4\u0005S\u0002R!a\u000f\u0003\u001e\u0015Dq!!&)\u0001\u0004\t9\nC\u0003dQ\u0001\u0007Q-A\tUQJLg\r\u001e%uiB\u001cVM\u001d<mKR\u00042!!\n+'\u0019Q#\u0011O*\u0003xA!\u00111\bB:\u0013\r\u0011)h\u001b\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005m\"\u0011P\u0005\u0004\u0005wZ'\u0001D*fe&\fG.\u001b>bE2,GC\u0001B7\u0003MA6K\u0015$`\u0011\u0016\u000bE)\u0012*`\t\u00163\u0015)\u0016'U\u0003QA6K\u0015$`\u0011\u0016\u000bE)\u0012*`\t\u00163\u0015)\u0016'UA\u0005q\u0002l\u0015*G?6+E\u000bS(E'~#vjX%H\u001d>\u0013Vi\u0018#F\r\u0006+F\nV\u000b\u0003\u0005\u000f\u0003bA!#\u0003\u0014\u0006uSB\u0001BF\u0015\u0011\u0011iIa$\u0002\u0013%lW.\u001e;bE2,'b\u0001BIW\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tU%1\u0012\u0002\u0004'\u0016$\u0018a\b-T%\u001a{V*\u0012+I\u001f\u0012\u001bv\fV(`\u0013\u001esuJU#`\t\u00163\u0015)\u0016'UA\u0005Y\u0011)\u0016+I?\u000e{ujS%F\u00031\tU\u000b\u0016%`\u0007>{5*S#!\u0003\r\u0011\u0016IT\u000b\u0003\u0005C\u0003BAa)\u0003(6\u0011!Q\u0015\u0006\u0004q\u0006\u0015\u0014\u0002\u0002BU\u0005K\u0013AbU3dkJ,'+\u00198e_6\fAAU!OA\u0005a\u0002*\u0013,F?\u0012+E*R$B)&{ej\u0018+P\u0017\u0016su\fS#B\t\u0016\u0013\u0016!\b%J-\u0016{F)\u0012'F\u000f\u0006#\u0016j\u0014(`)>[UIT0I\u000b\u0006#UI\u0015\u0011\u0002\u001fa{fi\u0014*X\u0003J#U\tR0G\u001fJ\u000b\u0001\u0003W0G\u001fJ;\u0016I\u0015#F\t~3uJ\u0015\u0011\u0002/\u001d,G\u000f\u0013;ua>sG._\"p_.LW\rS3bI\u0016\u0014HcA3\u0003:\"9!1\u0018\u001dA\u0002\t\u0005\u0012AB2p_.LW-A\thKR$u.Q:Rk\u0016\u0014\u0018\u0010U1sC6$2!\u001aBa\u0011\u0019\u0011\u0019-\u000fa\u0001K\u0006Y\u0011/^3ssN#(/\u001b8h\u00031!w\u000eW:sM\u001aKG\u000e^3s)\u0019\tID!3\u0003L\"9\u0011Q\u0013\u001eA\u0002\u0005]\u0005bBAWu\u0001\u0007\u0011qV\u0001\u000eO\u0016$\u0018)\u001e;i\u0011\u0016\fG-\u001a:\u0015\u000b\u0015\u0014\tNa5\t\u000f\u0005U5\b1\u0001\u0002\u0018\")1m\u000fa\u0001K\"*1Ha6\u0003dB1\u00111HA]\u00053\u0004BAa7\u0003`6\u0011!Q\u001c\u0006\u0005\u0003\u0017\tY%\u0003\u0003\u0003b\nu'a\u0007%uiB\fU\u000f\u001e5f]RL7-\u0019;j_:,\u0005pY3qi&|g.\r\u0004\u001fK\n\u0015(1^\u0019\nG\u0005%\u0017q\u001aBt\u0003#\f\u0014bIAx\u0003c\u0014I/!62\r\t\nYd[A{c\r1#\u0011\\\u0001\u0013SN\\UM\u001d2fe>\u001c\u0018)\u001e;i\u001b>$W\r\u0006\u0003\u0002:\tE\b\"B2=\u0001\u0004)\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa>\u0011\t\u0005}#\u0011`\u0005\u0005\u0005w\f\tG\u0001\u0004PE*,7\r\u001e")
public class ThriftHttpServlet
extends TServlet
implements Logging {
    private final String authType;
    private final UserGroupInformation serviceUGI;
    private final UserGroupInformation httpUGI;
    private final AuthFactory authFactory;
    private final LivyConf livyConf;
    private final boolean isCookieAuthEnabled;
    private final CookieSigner signer;
    private final String cookieDomain;
    private final String cookiePath;
    private final int cookieMaxAge;
    private final boolean isCookieSecure;
    private final boolean isHttpOnlyCookie;
    private final boolean xsrfFilterEnabled;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static String X_FORWARDED_FOR() {
        return ThriftHttpServlet$.MODULE$.X_FORWARDED_FOR();
    }

    public static String HIVE_DELEGATION_TOKEN_HEADER() {
        return ThriftHttpServlet$.MODULE$.HIVE_DELEGATION_TOKEN_HEADER();
    }

    public static SecureRandom RAN() {
        return ThriftHttpServlet$.MODULE$.RAN();
    }

    public static String AUTH_COOKIE() {
        return ThriftHttpServlet$.MODULE$.AUTH_COOKIE();
    }

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        ThriftHttpServlet thriftHttpServlet = this;
        synchronized (thriftHttpServlet) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String authType() {
        return this.authType;
    }

    public UserGroupInformation serviceUGI() {
        return this.serviceUGI;
    }

    public UserGroupInformation httpUGI() {
        return this.httpUGI;
    }

    public AuthFactory authFactory() {
        return this.authFactory;
    }

    public LivyConf livyConf() {
        return this.livyConf;
    }

    private boolean isCookieAuthEnabled() {
        return this.isCookieAuthEnabled;
    }

    private CookieSigner signer() {
        return this.signer;
    }

    private String cookieDomain() {
        return this.cookieDomain;
    }

    private String cookiePath() {
        return this.cookiePath;
    }

    private int cookieMaxAge() {
        return this.cookieMaxAge;
    }

    private boolean isCookieSecure() {
        return this.isCookieSecure;
    }

    private boolean isHttpOnlyCookie() {
        return this.isHttpOnlyCookie;
    }

    private boolean xsrfFilterEnabled() {
        return this.xsrfFilterEnabled;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block17: {
            block16: {
                ObjectRef clientUserName = ObjectRef.create(null);
                boolean requireNewCookie = false;
                try {
                    try {
                        boolean continueProcessing;
                        if (this.xsrfFilterEnabled() && !(continueProcessing = ThriftHttpServlet$.MODULE$.org$apache$livy$thriftserver$cli$ThriftHttpServlet$$doXsrfFilter(request, response))) {
                            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Request did not have valid XSRF header, rejecting.");
                            break block16;
                        }
                        if (this.isCookieAuthEnabled()) {
                            clientUserName.elem = this.validateCookie(request);
                            boolean bl = requireNewCookie = (String)clientUserName.elem == null;
                            if (requireNewCookie) {
                                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Could not validate cookie sent, will try to generate a new cookie");
                            }
                        }
                        if ((String)clientUserName.elem == null) {
                            String delegationToken;
                            clientUserName.elem = ThriftHttpServlet$.MODULE$.org$apache$livy$thriftserver$cli$ThriftHttpServlet$$isKerberosAuthMode(this.authType()) ? ((delegationToken = request.getHeader(ThriftHttpServlet$.MODULE$.HIVE_DELEGATION_TOKEN_HEADER())) != null && !delegationToken.isEmpty() ? this.doTokenAuth(request, response) : this.doKerberosAuth(request)) : this.doPasswdAuth(request, this.authType());
                        }
                        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Client username: ").append((String)clientUserName$1.elem).toString());
                        SessionInfo$.MODULE$.setUserName((String)clientUserName.elem);
                        String doAsQueryParam = ThriftHttpServlet$.MODULE$.org$apache$livy$thriftserver$cli$ThriftHttpServlet$$getDoAsQueryParam(request.getQueryString());
                        if (doAsQueryParam != null) {
                            SessionInfo$.MODULE$.setProxyUserName(doAsQueryParam);
                        }
                        String clientIpAddress = request.getRemoteAddr();
                        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Client IP Address: ").append(clientIpAddress).toString());
                        SessionInfo$.MODULE$.setIpAddress(clientIpAddress);
                        String forwardedFor = request.getHeader(ThriftHttpServlet$.MODULE$.X_FORWARDED_FOR());
                        if (forwardedFor != null) {
                            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(ThriftHttpServlet$.MODULE$.X_FORWARDED_FOR()).append(":").append(forwardedFor).toString());
                            SessionInfo$.MODULE$.setForwardedAddresses((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])forwardedFor.split(","))).toList()).asJava());
                        } else {
                            SessionInfo$.MODULE$.setForwardedAddresses((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava());
                        }
                        if (requireNewCookie && !this.authType().equalsIgnoreCase(HiveAuthConstants.AuthTypes.NOSASL.toString())) {
                            String cookieToken = HttpAuthUtils.createCookieToken((String)((String)clientUserName.elem));
                            Cookie hs2Cookie = this.createCookie(this.signer().signCookie(cookieToken));
                            if (this.isHttpOnlyCookie()) {
                                response.setHeader("SET-COOKIE", ThriftHttpServlet$.MODULE$.org$apache$livy$thriftserver$cli$ThriftHttpServlet$$getHttpOnlyCookieHeader(hs2Cookie));
                            } else {
                                response.addCookie(hs2Cookie);
                            }
                            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Cookie added for clientUserName ").append((String)clientUserName$1.elem).toString());
                        }
                        super.doPost(request, response);
                    }
                    catch (HttpAuthenticationException e) {
                        this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error: ", e);
                        response.setStatus(401);
                        if (ThriftHttpServlet$.MODULE$.org$apache$livy$thriftserver$cli$ThriftHttpServlet$$isKerberosAuthMode(this.authType())) {
                            response.addHeader("WWW-Authenticate", "Negotiate");
                        }
                        response.getWriter().println(new StringBuilder(22).append("Authentication Error: ").append(e.getMessage()).toString());
                    }
                    break block17;
                }
                finally {
                    SessionInfo$.MODULE$.clearUserName();
                    SessionInfo$.MODULE$.clearIpAddress();
                    SessionInfo$.MODULE$.clearProxyUserName();
                    SessionInfo$.MODULE$.clearForwardedAddresses();
                }
            }
            return;
        }
    }

    private String getClientNameFromCookie(Cookie[] cookies) {
        String string;
        Object object = new Object();
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cookies)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.equals((Object)ThriftHttpServlet$.MODULE$.AUTH_COOKIE()))))).foreach((Function1 & Serializable & scala.Serializable)cookie -> {
                ThriftHttpServlet.$anonfun$getClientNameFromCookie$2(this, object, cookie);
                return BoxedUnit.UNIT;
            });
            string = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                string = (String)ex.value();
            }
            throw ex;
        }
        return string;
    }

    private String toCookieStr(Cookie[] cookies) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cookies)).map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(6).append(c.getName()).append(" = ").append(c.getValue()).append(" ;\n").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString();
    }

    private String validateCookie(HttpServletRequest request) {
        Cookie[] cookies;
        block2: {
            cookies = request.getCookies();
            if (cookies == null) {
                if (this.logger().isDebugEnabled()) {
                    this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("No valid cookies associated with the request ").append(request).toString());
                }
                return null;
            }
            if (!this.logger().isDebugEnabled()) break block2;
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Received cookies: ").append(this.toCookieStr(cookies)).toString());
        }
        return this.getClientNameFromCookie(cookies);
    }

    private Cookie createCookie(String str) {
        if (this.logger().isDebugEnabled()) {
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Cookie name = ").append(ThriftHttpServlet$.MODULE$.AUTH_COOKIE()).append(" value = ").append(str).toString());
        }
        Cookie cookie = new Cookie(ThriftHttpServlet$.MODULE$.AUTH_COOKIE(), str);
        cookie.setMaxAge(this.cookieMaxAge());
        if (this.cookieDomain() != null) {
            cookie.setDomain(this.cookieDomain());
        }
        if (this.cookiePath() != null) {
            cookie.setPath(this.cookiePath());
        }
        cookie.setSecure(this.isCookieSecure());
        return cookie;
    }

    private String doPasswdAuth(HttpServletRequest request, String authType) {
        String userName = this.getUsername(request, authType);
        if (!authType.equalsIgnoreCase(HiveAuthConstants.AuthTypes.NOSASL.toString())) {
            try {
                PasswdAuthenticationProvider provider = AuthenticationProvider$.MODULE$.getAuthenticationProvider(authType, this.livyConf());
                provider.Authenticate(userName, this.getPassword(request, authType));
            }
            catch (Exception e) {
                throw new HttpAuthenticationException((Throwable)e);
            }
        }
        return userName;
    }

    private String doTokenAuth(HttpServletRequest request, HttpServletResponse response) {
        String string;
        String tokenStr = request.getHeader(ThriftHttpServlet$.MODULE$.HIVE_DELEGATION_TOKEN_HEADER());
        try {
            string = this.authFactory().verifyDelegationToken(tokenStr);
        }
        catch (HiveSQLException e) {
            throw new HttpAuthenticationException((Throwable)e);
        }
        return string;
    }

    private String doKerberosAuth(HttpServletRequest request) {
        String string;
        if (this.httpUGI() != null) {
            try {
                return (String)this.httpUGI().doAs((PrivilegedExceptionAction)new HttpKerberosServerAction(request, this.httpUGI(), this.authType()));
            }
            catch (Exception exception) {
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Failed to authenticate with http/_HOST kerberos principal, trying with livy/_HOST kerberos principal");
            }
        }
        try {
            string = (String)this.serviceUGI().doAs((PrivilegedExceptionAction)new HttpKerberosServerAction(request, this.serviceUGI(), this.authType()));
        }
        catch (Exception e) {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Failed to authenticate with livy/_HOST kerberos principal");
            throw new HttpAuthenticationException((Throwable)e);
        }
        return string;
    }

    private String getUsername(HttpServletRequest request, String authType) {
        String[] creds = this.getAuthHeaderTokens(request, authType);
        if (creds[0] == null || creds[0].isEmpty()) {
            throw new HttpAuthenticationException("Authorization header received from the client does not contain username.");
        }
        return creds[0];
    }

    private String getPassword(HttpServletRequest request, String authType) {
        String[] creds = this.getAuthHeaderTokens(request, authType);
        if (creds[1] == null || creds[1].isEmpty()) {
            throw new HttpAuthenticationException("Authorization header received from the client does not contain password.");
        }
        return creds[1];
    }

    private String[] getAuthHeaderTokens(HttpServletRequest request, String authType) {
        String authHeaderBase64 = ThriftHttpServlet$.MODULE$.getAuthHeader(request, authType);
        String authHeaderString = StringUtils.newStringUtf8((byte[])Base64.decodeBase64((byte[])authHeaderBase64.getBytes()));
        return authHeaderString.split(":");
    }

    public static final /* synthetic */ void $anonfun$getClientNameFromCookie$2(ThriftHttpServlet $this, Object nonLocalReturnKey1$1, Cookie cookie) {
        String value = $this.signer().verifyAndExtract(cookie.getValue());
        if (value != null) {
            String userName = HttpAuthUtils.getUserNameFromCookieToken((String)value);
            if (userName == null) {
                $this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Invalid cookie token ").append(value).toString());
                return;
            }
            if ($this.logger().isDebugEnabled()) {
                $this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Validated the cookie for user ").append(userName).toString());
            }
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)userName);
        }
    }

    public ThriftHttpServlet(TProcessor processor, TProtocolFactory protocolFactory, String authType, UserGroupInformation serviceUGI, UserGroupInformation httpUGI, AuthFactory authFactory, LivyConf livyConf) {
        CookieSigner cookieSigner;
        this.authType = authType;
        this.serviceUGI = serviceUGI;
        this.httpUGI = httpUGI;
        this.authFactory = authFactory;
        this.livyConf = livyConf;
        super(processor, protocolFactory);
        Logging.$init$((Logging)this);
        this.isCookieAuthEnabled = livyConf.getBoolean((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_HTTP_COOKIE_AUTH_ENABLED());
        if (this.isCookieAuthEnabled()) {
            String secret = Long.toString(ThriftHttpServlet$.MODULE$.RAN().nextLong());
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Using the random number as the secret for cookie generation ").append(secret).toString());
            cookieSigner = new CookieSigner(secret.getBytes());
        } else {
            cookieSigner = null;
        }
        this.signer = cookieSigner;
        this.cookieDomain = livyConf.get((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_HTTP_COOKIE_DOMAIN());
        this.cookiePath = livyConf.get((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_HTTP_COOKIE_PATH());
        this.cookieMaxAge = (int)(livyConf.getTimeAsMs((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_HTTP_COOKIE_MAX_AGE()) / 1000L);
        this.isCookieSecure = livyConf.getBoolean((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_USE_SSL());
        this.isHttpOnlyCookie = livyConf.getBoolean((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_HTTP_COOKIE_IS_HTTPONLY());
        this.xsrfFilterEnabled = livyConf.getBoolean((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_XSRF_FILTER_ENABLED());
    }
}

