/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.rpc;

import java.io.Serializable;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.livy.Job;
import org.apache.livy.JobHandle;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.client.common.ClientConf;
import org.apache.livy.rsc.RSCClient;
import org.apache.livy.server.interactive.InteractiveSession;
import org.apache.livy.thriftserver.session.CleanupStatementJob;
import org.apache.livy.thriftserver.session.FetchResultJob;
import org.apache.livy.thriftserver.session.FetchResultSchemaJob;
import org.apache.livy.thriftserver.session.RegisterSessionJob;
import org.apache.livy.thriftserver.session.ResultSet;
import org.apache.livy.thriftserver.session.SqlJob;
import org.apache.livy.thriftserver.session.UnregisterSessionJob;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001\u0002\t\u0012\u0001qA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006a\u0001!\t!\r\u0005\bk\u0001\u0011\r\u0011\"\u00037\u0011\u0019y\u0004\u0001)A\u0005o!9\u0001\t\u0001b\u0001\n\u0013\t\u0005B\u0002%\u0001A\u0003%!\tC\u0003J\u0001\u0011\u0005!\nC\u0003O\u0001\u0011%q\nC\u0003g\u0001\u0011\u0005q\rC\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0005\"CAO\u0001E\u0005I\u0011AAP\u0011\u001d\t)\f\u0001C\u0001\u0003oCq!!5\u0001\t\u0003\t\u0019NA\u0005Sa\u000e\u001cE.[3oi*\u0011!cE\u0001\u0004eB\u001c'B\u0001\u000b\u0016\u00031!\bN]5giN,'O^3s\u0015\t1r#\u0001\u0003mSZL(B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001;\r\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0007C\u0001\u0013&\u001b\u0005)\u0012B\u0001\u0014\u0016\u0005\u001daunZ4j]\u001e\f1\u0002\\5wsN+7o]5p]B\u0011\u0011FL\u0007\u0002U)\u00111\u0006L\u0001\fS:$XM]1di&4XM\u0003\u0002.+\u000511/\u001a:wKJL!a\f\u0016\u0003%%sG/\u001a:bGRLg/Z*fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005I\"\u0004CA\u001a\u0001\u001b\u0005\t\u0002\"B\u0014\u0003\u0001\u0004A\u0013!\u00073fM\u0006,H\u000e^%oGJ,W.\u001a8uC2\u001cu\u000e\u001c7fGR,\u0012a\u000e\t\u0003quj\u0011!\u000f\u0006\u0003um\nA\u0001\\1oO*\tA(\u0001\u0003kCZ\f\u0017B\u0001 :\u0005\u0019\u0019FO]5oO\u0006QB-\u001a4bk2$\u0018J\\2sK6,g\u000e^1m\u0007>dG.Z2uA\u0005I!o]2DY&,g\u000e^\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011Q)F\u0001\u0004eN\u001c\u0017BA$E\u0005%\u00116kQ\"mS\u0016tG/\u0001\u0006sg\u000e\u001cE.[3oi\u0002\nq![:WC2LG-F\u0001L!\tqB*\u0003\u0002N?\t9!i\\8mK\u0006t\u0017!C:fgNLwN\\%e)\t\u0001&\f\u0005\u0002R1:\u0011!K\u0016\t\u0003'~i\u0011\u0001\u0016\u0006\u0003+n\ta\u0001\u0010:p_Rt\u0014BA, \u0003\u0019\u0001&/\u001a3fM&\u0011a(\u0017\u0006\u0003/~AQa\u0017\u0005A\u0002q\u000bQb]3tg&|g\u000eS1oI2,\u0007CA/e\u001b\u0005q&BA0a\u0003\r\u0019G.\u001b\u0006\u0003C\n\fqa]3sm&\u001cWM\u0003\u0002d/\u0005!\u0001.\u001b<f\u0013\t)gLA\u0007TKN\u001c\u0018n\u001c8IC:$G.Z\u0001\u000bKb,7-\u001e;f'FdG\u0003\u00025xqj\u0004$!\u001b8\u0011\u0007\u0011RG.\u0003\u0002l+\tI!j\u001c2IC:$G.\u001a\t\u0003[:d\u0001\u0001B\u0005p\u0013\u0005\u0005\t\u0011!B\u0001a\n\u0019q\fJ\u0019\u0012\u0005E$\bC\u0001\u0010s\u0013\t\u0019xDA\u0004O_RD\u0017N\\4\u0011\u0005y)\u0018B\u0001< \u0005\r\te.\u001f\u0005\u00067&\u0001\r\u0001\u0018\u0005\u0006s&\u0001\r\u0001U\u0001\fgR\fG/Z7f]RLE\rC\u0003|\u0013\u0001\u0007\u0001+A\u0005ti\u0006$X-\\3oi\"\"\u0011\"`A\n!\u0011qb0!\u0001\n\u0005}|\"A\u0002;ie><8\u000f\u0005\u0003\u0002\u0004\u00055a\u0002BA\u0003\u0003\u0013q1aUA\u0004\u0013\u0005\u0001\u0013bAA\u0006?\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\b\u0003#\u0011\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005-q$\r\u0004\u001f!\u0006U\u00111H\u0019\nG\u0005]\u0011qDA\u0019\u0003C)B!!\u0007\u0002\u001cU\t\u0001\u000bB\u0004\u0002\u001em\u0011\r!a\n\u0003\u0003QKA!!\t\u0002$\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER1!!\n \u0003\u0019!\bN]8xgF\u0019\u0011/!\u000b\u0011\t\u0005-\u0012Q\u0006\b\u0004=\u0005%\u0011\u0002BA\u0018\u0003#\u0011\u0011\u0002\u00165s_^\f'\r\\32\u0013\r\n\u0019$!\u000e\u00028\u0005\u0015bb\u0001\u0010\u00026%\u0019\u0011QE\u00102\u000b\trr$!\u000f\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\n\t!A\u0006gKR\u001c\u0007NU3tk2$H\u0003CA!\u0003\u001f\n\t&a\u0015\u0011\t\u0011R\u00171\t\t\u0005\u0003\u000b\nY%\u0004\u0002\u0002H)\u0019\u0011\u0011J\n\u0002\u000fM,7o]5p]&!\u0011QJA$\u0005%\u0011Vm];miN+G\u000fC\u0003\\\u0015\u0001\u0007A\fC\u0003z\u0015\u0001\u0007\u0001\u000bC\u0004\u0002V)\u0001\r!a\u0016\u0002\u000f5\f\u0007PU8xgB\u0019a$!\u0017\n\u0007\u0005msDA\u0002J]RDCAC?\u0002`E2a\u0004UA1\u0003O\n\u0014bIA\f\u0003?\t\u0019'!\t2\u0013\r\n\u0019$!\u000e\u0002f\u0005\u0015\u0012'\u0002\u0012\u001f?\u0005e\u0012g\u0001\u0014\u0002\u0002\u0005\tb-\u001a;dQJ+7/\u001e7u'\u000eDW-\\1\u0015\r\u00055\u0014qNA9!\r!#\u000e\u0015\u0005\u00067.\u0001\r\u0001\u0018\u0005\u0006s.\u0001\r\u0001\u0015\u0015\u0005\u0017u\f)(\r\u0004\u001f!\u0006]\u0014QP\u0019\nG\u0005]\u0011qDA=\u0003C\t\u0014bIA\u001a\u0003k\tY(!\n2\u000b\trr$!\u000f2\u0007\u0019\n\t!\u0001\tdY\u0016\fg.\u001e9Ti\u0006$X-\\3oiRA\u00111QAE\u0003\u0017\u000bi\t\u0005\u0003%U\u0006\u0015\u0005c\u0001\u001d\u0002\b&\u0011Q*\u000f\u0005\u000672\u0001\r\u0001\u0018\u0005\u0006s2\u0001\r\u0001\u0015\u0005\t\u0003\u001fc\u0001\u0013!a\u0001\u0017\u0006I1-\u00198dK2TuN\u0019\u0015\u0005\u0019u\f\u0019*\r\u0004\u001f!\u0006U\u00151T\u0019\nG\u0005]\u0011qDAL\u0003C\t\u0014bIA\u001a\u0003k\tI*!\n2\u000b\trr$!\u000f2\u0007\u0019\n\t!\u0001\u000edY\u0016\fg.\u001e9Ti\u0006$X-\\3oi\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\"*\u001a1*a),\u0005\u0005\u0015\u0006\u0003BAT\u0003ck!!!+\u000b\t\u0005-\u0016QV\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a, \u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\u000bIKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa#\u001a=fGV$XMU3hSN$XM]*fgNLwN\u001c\u000b\u0005\u0003s\u000b\u0019\r\r\u0003\u0002<\u0006}\u0006\u0003\u0002\u0013k\u0003{\u00032!\\A`\t)\t\tMDA\u0001\u0002\u0003\u0015\t\u0001\u001d\u0002\u0004?\u0012\u0012\u0004\"B.\u000f\u0001\u0004a\u0006\u0006\u0002\b~\u0003\u000f\fdA\b)\u0002J\u0006=\u0017'C\u0012\u0002\u0018\u0005}\u00111ZA\u0011c%\u0019\u00131GA\u001b\u0003\u001b\f)#M\u0003#=}\tI$M\u0002'\u0003\u0003\t\u0001$\u001a=fGV$X-\u00168sK\u001eL7\u000f^3s'\u0016\u001c8/[8o)\u0011\t).a81\t\u0005]\u00171\u001c\t\u0005I)\fI\u000eE\u0002n\u00037$!\"!8\u0010\u0003\u0003\u0005\tQ!\u0001q\u0005\ryFe\r\u0005\u00067>\u0001\r\u0001\u0018\u0015\u0005\u001fu\f\u0019/\r\u0004\u001f!\u0006\u0015\u00181^\u0019\nG\u0005]\u0011qDAt\u0003C\t\u0014bIA\u001a\u0003k\tI/!\n2\u000b\trr$!\u000f2\u0007\u0019\n\t\u0001")
public class RpcClient
implements Logging {
    private final InteractiveSession livySession;
    private final String defaultIncrementalCollect;
    private final RSCClient rscClient;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        RpcClient rpcClient = this;
        synchronized (rpcClient) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private String defaultIncrementalCollect() {
        return this.defaultIncrementalCollect;
    }

    private RSCClient rscClient() {
        return this.rscClient;
    }

    public boolean isValid() {
        return this.rscClient().isAlive();
    }

    private String sessionId(SessionHandle sessionHandle) {
        return sessionHandle.getSessionId().toString();
    }

    public JobHandle<?> executeSql(SessionHandle sessionHandle, String statementId, String statement) throws Exception {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("RSC client is executing SQL query: ").append(statement).append(", statementId = ").append(statementId).append(", session = ").append(sessionHandle).toString());
        Predef$.MODULE$.require(statementId != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Invalid statementId specified. StatementId = ").append(statementId).toString());
        Predef$.MODULE$.require(statement != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Invalid statement specified. StatementId = ").append(statement).toString());
        this.livySession.recordActivity();
        return this.rscClient().submit((Job)new SqlJob(this.sessionId(sessionHandle), statementId, statement, this.defaultIncrementalCollect(), new StringBuilder(6).append("spark.").append(LivyConf$.MODULE$.THRIFT_INCR_COLLECT_ENABLED()).toString()));
    }

    public JobHandle<ResultSet> fetchResult(SessionHandle sessionHandle, String statementId, int maxRows) throws Exception {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("RSC client is fetching result for statementId ").append(statementId).append(" with ").append(maxRows).append(" maxRows.").toString());
        Predef$.MODULE$.require(statementId != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Invalid statementId specified. StatementId = ").append(statementId).toString());
        this.livySession.recordActivity();
        return this.rscClient().submit((Job)new FetchResultJob(this.sessionId(sessionHandle), statementId, maxRows));
    }

    public JobHandle<String> fetchResultSchema(SessionHandle sessionHandle, String statementId) throws Exception {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("RSC client is fetching result schema for statementId = ").append(statementId).toString());
        Predef$.MODULE$.require(statementId != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Invalid statementId specified. statementId = ").append(statementId).toString());
        this.livySession.recordActivity();
        return this.rscClient().submit((Job)new FetchResultSchemaJob(this.sessionId(sessionHandle), statementId));
    }

    public JobHandle<Boolean> cleanupStatement(SessionHandle sessionHandle, String statementId, boolean cancelJob) throws Exception {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Cleaning up remote session for statementId = ").append(statementId).toString());
        Predef$.MODULE$.require(statementId != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Invalid statementId specified. statementId = ").append(statementId).toString());
        this.livySession.recordActivity();
        return this.rscClient().submit((Job)new CleanupStatementJob(this.sessionId(sessionHandle), statementId));
    }

    public boolean cleanupStatement$default$3() {
        return false;
    }

    public JobHandle<?> executeRegisterSession(SessionHandle sessionHandle) throws Exception {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("RSC client is executing register session ").append(sessionHandle).toString());
        this.livySession.recordActivity();
        return this.rscClient().submit((Job)new RegisterSessionJob(this.sessionId(sessionHandle)));
    }

    public JobHandle<?> executeUnregisterSession(SessionHandle sessionHandle) throws Exception {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("RSC client is executing unregister session ").append(sessionHandle).toString());
        this.livySession.recordActivity();
        return this.rscClient().submit((Job)new UnregisterSessionJob(this.sessionId(sessionHandle)));
    }

    public RpcClient(InteractiveSession livySession) {
        this.livySession = livySession;
        Logging.$init$((Logging)this);
        this.defaultIncrementalCollect = Boolean.toString(livySession.livyConf().getBoolean((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_INCR_COLLECT_ENABLED()));
        this.rscClient = (RSCClient)livySession.client().get();
    }
}

