/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.types;

import java.io.Serializable;
import org.apache.livy.thriftserver.types.ArrayType;
import org.apache.livy.thriftserver.types.BasicDataType;
import org.apache.livy.thriftserver.types.Field;
import org.apache.livy.thriftserver.types.FieldType;
import org.apache.livy.thriftserver.types.MapType;
import org.apache.livy.thriftserver.types.Schema;
import org.apache.livy.thriftserver.types.Schema$;
import org.apache.livy.thriftserver.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonInput;
import org.json4s.StringInput;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;

public final class DataTypeUtils$ {
    public static DataTypeUtils$ MODULE$;
    private final DefaultFormats$ formats;

    static {
        new DataTypeUtils$();
    }

    private DefaultFormats$ formats() {
        return this.formats;
    }

    private FieldType toFieldType(JsonAST.JValue jValue) {
        JsonAST.JValue jValue2 = jValue;
        if (jValue2 instanceof JsonAST.JString) {
            JsonAST.JString jString = (JsonAST.JString)jValue2;
            String t = jString.s();
            return new BasicDataType(t);
        }
        if (jValue2 instanceof JsonAST.JObject) {
            JsonAST.JObject jObject = (JsonAST.JObject)jValue2;
            return this.complexToDataType(jObject);
        }
        throw new IllegalArgumentException(new StringBuilder(55).append("Spark type was neither a string nor a object. It was: ").append(jValue).append(".").toString());
    }

    private FieldType complexToDataType(JsonAST.JObject sparkType) {
        String string = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic((JsonAST.JValue)sparkType).$bslash("type")).extract((Formats)this.formats(), ManifestFactory$.MODULE$.classType(String.class));
        if ("array".equals(string)) {
            return new ArrayType(this.toFieldType(package$.MODULE$.jvalue2monadic((JsonAST.JValue)sparkType).$bslash("elementType")));
        }
        if ("struct".equals(string)) {
            List fields = (List)package$.MODULE$.jvalue2monadic((JsonAST.JValue)sparkType).$bslash("fields").children().map((Function1 & Serializable & scala.Serializable)f -> new Field((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(f).$bslash("name")).extract((Formats)MODULE$.formats(), ManifestFactory$.MODULE$.classType(String.class)), MODULE$.toFieldType(package$.MODULE$.jvalue2monadic(f).$bslash("type")), ""), List$.MODULE$.canBuildFrom());
            return new StructType((Field[])fields.toArray(ClassTag$.MODULE$.apply(Field.class)));
        }
        if ("map".equals(string)) {
            return new MapType(this.toFieldType(package$.MODULE$.jvalue2monadic((JsonAST.JValue)sparkType).$bslash("keyType")), this.toFieldType(package$.MODULE$.jvalue2monadic((JsonAST.JValue)sparkType).$bslash("valueType")));
        }
        if ("udt".equals(string)) {
            return this.toFieldType(package$.MODULE$.jvalue2monadic((JsonAST.JValue)sparkType).$bslash("sqlType"));
        }
        throw new MatchError((Object)string);
    }

    public Schema schemaFromSparkJson(String sparkJson) {
        JsonAST.JValue schema = package$.MODULE$.jvalue2monadic(JsonMethods$.MODULE$.parse((JsonInput)new StringInput(sparkJson), false, JsonMethods$.MODULE$.parse$default$3())).$bslash("fields");
        List fields = (List)schema.children().map((Function1 & Serializable & scala.Serializable)field -> {
            String name = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(field).$bslash("name")).extract((Formats)MODULE$.formats(), ManifestFactory$.MODULE$.classType(String.class));
            FieldType hiveType = MODULE$.toFieldType(package$.MODULE$.jvalue2monadic(field).$bslash("type"));
            return new Field(name, hiveType, "");
        }, List$.MODULE$.canBuildFrom());
        return Schema$.MODULE$.apply((Field[])fields.toArray(ClassTag$.MODULE$.apply(Field.class)));
    }

    private DataTypeUtils$() {
        MODULE$ = this;
        this.formats = DefaultFormats$.MODULE$;
    }
}

