/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.proto.HAServiceProtocolProtos;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.inotify.EventBatchList;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.BatchedDirectoryListing;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ECBlockGroupStats;
import org.apache.hadoop.hdfs.protocol.ECTopologyVerifierResult;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsPartialListing;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import org.apache.hadoop.hdfs.protocol.OpenFilesIterator;
import org.apache.hadoop.hdfs.protocol.ReplicatedBlockStats;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;
import org.apache.hadoop.hdfs.protocol.proto.AclProtos;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.EncryptionZonesProtos;
import org.apache.hadoop.hdfs.protocol.proto.ErasureCodingProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.XAttrProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.AsyncCallHandler;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.ipc.internal.ShadedProtobufHelper;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;
import org.apache.hadoop.util.concurrent.AsyncGet;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class ClientNamenodeProtocolTranslatorPB
implements ProtocolMetaInterface,
ClientProtocol,
Closeable,
ProtocolTranslator {
    private final ClientNamenodeProtocolPB rpcProxy;
    static final ClientNamenodeProtocolProtos.GetServerDefaultsRequestProto VOID_GET_SERVER_DEFAULT_REQUEST = ClientNamenodeProtocolProtos.GetServerDefaultsRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.GetFsStatusRequestProto VOID_GET_FSSTATUS_REQUEST = ClientNamenodeProtocolProtos.GetFsStatusRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.GetFsReplicatedBlockStatsRequestProto VOID_GET_FS_REPLICATED_BLOCK_STATS_REQUEST = ClientNamenodeProtocolProtos.GetFsReplicatedBlockStatsRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.GetFsECBlockGroupStatsRequestProto VOID_GET_FS_ECBLOCKGROUP_STATS_REQUEST = ClientNamenodeProtocolProtos.GetFsECBlockGroupStatsRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.RollEditsRequestProto VOID_ROLLEDITS_REQUEST = ClientNamenodeProtocolProtos.RollEditsRequestProto.getDefaultInstance();
    private static final ClientNamenodeProtocolProtos.RefreshNodesRequestProto VOID_REFRESH_NODES_REQUEST = ClientNamenodeProtocolProtos.RefreshNodesRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.FinalizeUpgradeRequestProto VOID_FINALIZE_UPGRADE_REQUEST = ClientNamenodeProtocolProtos.FinalizeUpgradeRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.UpgradeStatusRequestProto VOID_UPGRADE_STATUS_REQUEST = ClientNamenodeProtocolProtos.UpgradeStatusRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.GetDataEncryptionKeyRequestProto VOID_GET_DATA_ENCRYPTIONKEY_REQUEST = ClientNamenodeProtocolProtos.GetDataEncryptionKeyRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.GetStoragePoliciesRequestProto VOID_GET_STORAGE_POLICIES_REQUEST = ClientNamenodeProtocolProtos.GetStoragePoliciesRequestProto.newBuilder().build();
    private static final ErasureCodingProtos.GetErasureCodingPoliciesRequestProto VOID_GET_EC_POLICIES_REQUEST = ErasureCodingProtos.GetErasureCodingPoliciesRequestProto.newBuilder().build();
    private static final ErasureCodingProtos.GetErasureCodingCodecsRequestProto VOID_GET_EC_CODEC_REQUEST = ErasureCodingProtos.GetErasureCodingCodecsRequestProto.newBuilder().build();

    public ClientNamenodeProtocolTranslatorPB(ClientNamenodeProtocolPB proxy) {
        this.rpcProxy = proxy;
    }

    @Override
    public void close() {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    @Override
    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        ClientNamenodeProtocolProtos.GetBlockLocationsRequestProto req = ClientNamenodeProtocolProtos.GetBlockLocationsRequestProto.newBuilder().setSrc(src).setOffset(offset).setLength(length).build();
        ClientNamenodeProtocolProtos.GetBlockLocationsResponseProto resp = (ClientNamenodeProtocolProtos.GetBlockLocationsResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getBlockLocations(null, req));
        return resp.hasLocations() ? PBHelperClient.convert(resp.getLocations()) : null;
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        ClientNamenodeProtocolProtos.GetServerDefaultsRequestProto req = VOID_GET_SERVER_DEFAULT_REQUEST;
        return PBHelperClient.convert((HdfsProtos.FsServerDefaultsProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getServerDefaults(null, req).getServerDefaults()));
    }

    @Override
    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions, String ecPolicyName, String storagePolicy) throws IOException {
        FsPermission unmasked;
        ClientNamenodeProtocolProtos.CreateRequestProto.Builder builder = ClientNamenodeProtocolProtos.CreateRequestProto.newBuilder().setSrc(src).setMasked(PBHelperClient.convert(masked)).setClientName(clientName).setCreateFlag(PBHelperClient.convertCreateFlag(flag)).setCreateParent(createParent).setReplication(replication).setBlockSize(blockSize);
        if (ecPolicyName != null) {
            builder.setEcPolicyName(ecPolicyName);
        }
        if (storagePolicy != null) {
            builder.setStoragePolicy(storagePolicy);
        }
        if ((unmasked = masked.getUnmasked()) != null) {
            builder.setUnmasked(PBHelperClient.convert(unmasked));
        }
        builder.addAllCryptoProtocolVersion(PBHelperClient.convert(supportedVersions));
        ClientNamenodeProtocolProtos.CreateRequestProto req = builder.build();
        ClientNamenodeProtocolProtos.CreateResponseProto res = (ClientNamenodeProtocolProtos.CreateResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.create(null, req));
        return res.hasFs() ? PBHelperClient.convert(res.getFs()) : null;
    }

    @Override
    public boolean truncate(String src, long newLength, String clientName) throws IOException {
        ClientNamenodeProtocolProtos.TruncateRequestProto req = ClientNamenodeProtocolProtos.TruncateRequestProto.newBuilder().setSrc(src).setNewLength(newLength).setClientName(clientName).build();
        return (Boolean)ShadedProtobufHelper.ipc(() -> this.rpcProxy.truncate(null, req).getResult());
    }

    @Override
    public LastBlockWithStatus append(String src, String clientName, EnumSetWritable<CreateFlag> flag) throws IOException {
        ClientNamenodeProtocolProtos.AppendRequestProto req = ClientNamenodeProtocolProtos.AppendRequestProto.newBuilder().setSrc(src).setClientName(clientName).setFlag(PBHelperClient.convertCreateFlag(flag)).build();
        ClientNamenodeProtocolProtos.AppendResponseProto res = (ClientNamenodeProtocolProtos.AppendResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.append(null, req));
        LocatedBlock lastBlock = res.hasBlock() ? PBHelperClient.convertLocatedBlockProto(res.getBlock()) : null;
        HdfsFileStatus stat = res.hasStat() ? PBHelperClient.convert(res.getStat()) : null;
        return new LastBlockWithStatus(lastBlock, stat);
    }

    @Override
    public boolean setReplication(String src, short replication) throws IOException {
        ClientNamenodeProtocolProtos.SetReplicationRequestProto req = ClientNamenodeProtocolProtos.SetReplicationRequestProto.newBuilder().setSrc(src).setReplication(replication).build();
        return ((ClientNamenodeProtocolProtos.SetReplicationResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.setReplication(null, req))).getResult();
    }

    @Override
    public void setPermission(String src, FsPermission permission) throws IOException {
        ClientNamenodeProtocolProtos.SetPermissionRequestProto req = ClientNamenodeProtocolProtos.SetPermissionRequestProto.newBuilder().setSrc(src).setPermission(PBHelperClient.convert(permission)).build();
        if (Client.isAsynchronousMode()) {
            ShadedProtobufHelper.ipc(() -> this.rpcProxy.setPermission(null, req));
            this.setAsyncReturnValue();
        } else {
            ShadedProtobufHelper.ipc(() -> this.rpcProxy.setPermission(null, req));
        }
    }

    private void setAsyncReturnValue() {
        final AsyncGet asyncReturnMessage = ProtobufRpcEngine2.getAsyncReturnMessage();
        AsyncGet<Void, Exception> asyncGet = new AsyncGet<Void, Exception>(){

            public Void get(long timeout, TimeUnit unit) throws Exception {
                asyncReturnMessage.get(timeout, unit);
                return null;
            }

            public boolean isDone() {
                return asyncReturnMessage.isDone();
            }
        };
        AsyncCallHandler.setLowerLayerAsyncReturn((AsyncGet)asyncGet);
    }

    @Override
    public void setOwner(String src, String username, String groupname) throws IOException {
        ClientNamenodeProtocolProtos.SetOwnerRequestProto.Builder req = ClientNamenodeProtocolProtos.SetOwnerRequestProto.newBuilder().setSrc(src);
        if (username != null) {
            req.setUsername(username);
        }
        if (groupname != null) {
            req.setGroupname(groupname);
        }
        if (Client.isAsynchronousMode()) {
            ShadedProtobufHelper.ipc(() -> this.rpcProxy.setOwner(null, req.build()));
            this.setAsyncReturnValue();
        } else {
            ShadedProtobufHelper.ipc(() -> this.rpcProxy.setOwner(null, req.build()));
        }
    }

    @Override
    public void abandonBlock(ExtendedBlock b, long fileId, String src, String holder) throws IOException {
        ClientNamenodeProtocolProtos.AbandonBlockRequestProto req = ClientNamenodeProtocolProtos.AbandonBlockRequestProto.newBuilder().setB(PBHelperClient.convert(b)).setSrc(src).setHolder(holder).setFileId(fileId).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.abandonBlock(null, req));
    }

    @Override
    public LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludeNodes, long fileId, String[] favoredNodes, EnumSet<AddBlockFlag> addBlockFlags) throws IOException {
        ClientNamenodeProtocolProtos.AddBlockRequestProto.Builder req = ClientNamenodeProtocolProtos.AddBlockRequestProto.newBuilder().setSrc(src).setClientName(clientName).setFileId(fileId);
        if (previous != null) {
            req.setPrevious(PBHelperClient.convert(previous));
        }
        if (excludeNodes != null) {
            req.addAllExcludeNodes(PBHelperClient.convert(excludeNodes));
        }
        if (favoredNodes != null) {
            req.addAllFavoredNodes(Arrays.asList(favoredNodes));
        }
        if (addBlockFlags != null) {
            req.addAllFlags(PBHelperClient.convertAddBlockFlags(addBlockFlags));
        }
        return PBHelperClient.convertLocatedBlockProto(((ClientNamenodeProtocolProtos.AddBlockResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.addBlock(null, req.build()))).getBlock());
    }

    @Override
    public LocatedBlock getAdditionalDatanode(String src, long fileId, ExtendedBlock blk, DatanodeInfo[] existings, String[] existingStorageIDs, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws IOException {
        ClientNamenodeProtocolProtos.GetAdditionalDatanodeRequestProto req = ClientNamenodeProtocolProtos.GetAdditionalDatanodeRequestProto.newBuilder().setSrc(src).setFileId(fileId).setBlk(PBHelperClient.convert(blk)).addAllExistings(PBHelperClient.convert(existings)).addAllExistingStorageUuids(Arrays.asList(existingStorageIDs)).addAllExcludes(PBHelperClient.convert(excludes)).setNumAdditionalNodes(numAdditionalNodes).setClientName(clientName).build();
        return PBHelperClient.convertLocatedBlockProto(((ClientNamenodeProtocolProtos.GetAdditionalDatanodeResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getAdditionalDatanode(null, req))).getBlock());
    }

    @Override
    public boolean complete(String src, String clientName, ExtendedBlock last, long fileId) throws IOException {
        ClientNamenodeProtocolProtos.CompleteRequestProto.Builder req = ClientNamenodeProtocolProtos.CompleteRequestProto.newBuilder().setSrc(src).setClientName(clientName).setFileId(fileId);
        if (last != null) {
            req.setLast(PBHelperClient.convert(last));
        }
        return ((ClientNamenodeProtocolProtos.CompleteResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.complete(null, req.build()))).getResult();
    }

    @Override
    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        ClientNamenodeProtocolProtos.ReportBadBlocksRequestProto req = ClientNamenodeProtocolProtos.ReportBadBlocksRequestProto.newBuilder().addAllBlocks(Arrays.asList(PBHelperClient.convertLocatedBlocks(blocks))).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.reportBadBlocks(null, req));
    }

    @Override
    public boolean rename(String src, String dst) throws IOException {
        ClientNamenodeProtocolProtos.RenameRequestProto req = ClientNamenodeProtocolProtos.RenameRequestProto.newBuilder().setSrc(src).setDst(dst).build();
        return ((ClientNamenodeProtocolProtos.RenameResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.rename(null, req))).getResult();
    }

    @Override
    public void rename2(String src, String dst, Options.Rename ... options) throws IOException {
        boolean overwrite = false;
        boolean toTrash = false;
        if (options != null) {
            for (Options.Rename option : options) {
                if (option == Options.Rename.OVERWRITE) {
                    overwrite = true;
                }
                if (option != Options.Rename.TO_TRASH) continue;
                toTrash = true;
            }
        }
        ClientNamenodeProtocolProtos.Rename2RequestProto req = ClientNamenodeProtocolProtos.Rename2RequestProto.newBuilder().setSrc(src).setDst(dst).setOverwriteDest(overwrite).setMoveToTrash(toTrash).build();
        if (Client.isAsynchronousMode()) {
            ShadedProtobufHelper.ipc(() -> this.rpcProxy.rename2(null, req));
            this.setAsyncReturnValue();
        } else {
            ShadedProtobufHelper.ipc(() -> this.rpcProxy.rename2(null, req));
        }
    }

    @Override
    public void concat(String trg, String[] srcs) throws IOException {
        ClientNamenodeProtocolProtos.ConcatRequestProto req = ClientNamenodeProtocolProtos.ConcatRequestProto.newBuilder().setTrg(trg).addAllSrcs(Arrays.asList(srcs)).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.concat(null, req));
    }

    @Override
    public boolean delete(String src, boolean recursive) throws IOException {
        ClientNamenodeProtocolProtos.DeleteRequestProto req = ClientNamenodeProtocolProtos.DeleteRequestProto.newBuilder().setSrc(src).setRecursive(recursive).build();
        return (Boolean)ShadedProtobufHelper.ipc(() -> this.rpcProxy.delete(null, req).getResult());
    }

    @Override
    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws IOException {
        ClientNamenodeProtocolProtos.MkdirsRequestProto.Builder builder = ClientNamenodeProtocolProtos.MkdirsRequestProto.newBuilder().setSrc(src).setMasked(PBHelperClient.convert(masked)).setCreateParent(createParent);
        FsPermission unmasked = masked.getUnmasked();
        if (unmasked != null) {
            builder.setUnmasked(PBHelperClient.convert(unmasked));
        }
        ClientNamenodeProtocolProtos.MkdirsRequestProto req = builder.build();
        return ((ClientNamenodeProtocolProtos.MkdirsResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.mkdirs(null, req))).getResult();
    }

    @Override
    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws IOException {
        ClientNamenodeProtocolProtos.GetListingRequestProto req = ClientNamenodeProtocolProtos.GetListingRequestProto.newBuilder().setSrc(src).setStartAfter(ByteString.copyFrom((byte[])startAfter)).setNeedLocation(needLocation).build();
        ClientNamenodeProtocolProtos.GetListingResponseProto result = (ClientNamenodeProtocolProtos.GetListingResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getListing(null, req));
        if (result.hasDirList()) {
            return PBHelperClient.convert(result.getDirList());
        }
        return null;
    }

    @Override
    public BatchedDirectoryListing getBatchedListing(String[] srcs, byte[] startAfter, boolean needLocation) throws IOException {
        ClientNamenodeProtocolProtos.GetBatchedListingRequestProto req = ClientNamenodeProtocolProtos.GetBatchedListingRequestProto.newBuilder().addAllPaths(Arrays.asList(srcs)).setStartAfter(ByteString.copyFrom((byte[])startAfter)).setNeedLocation(needLocation).build();
        ClientNamenodeProtocolProtos.GetBatchedListingResponseProto result = (ClientNamenodeProtocolProtos.GetBatchedListingResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getBatchedListing(null, req));
        if (result.getListingsCount() > 0) {
            HdfsPartialListing[] listingArray = new HdfsPartialListing[result.getListingsCount()];
            int listingIdx = 0;
            for (HdfsProtos.BatchedDirectoryListingProto proto : result.getListingsList()) {
                HdfsPartialListing listing;
                if (proto.hasException()) {
                    HdfsProtos.RemoteExceptionProto reProto = proto.getException();
                    RemoteException ex = new RemoteException(reProto.getClassName(), reProto.getMessage());
                    listing = new HdfsPartialListing(proto.getParentIdx(), ex);
                } else {
                    List<HdfsFileStatus> statuses = PBHelperClient.convertHdfsFileStatus(proto.getPartialListingList());
                    listing = new HdfsPartialListing(proto.getParentIdx(), statuses);
                }
                listingArray[listingIdx++] = listing;
            }
            BatchedDirectoryListing batchedListing = new BatchedDirectoryListing(listingArray, result.getHasMore(), result.getStartAfter().toByteArray());
            return batchedListing;
        }
        return null;
    }

    @Override
    public void renewLease(String clientName) throws IOException {
        ClientNamenodeProtocolProtos.RenewLeaseRequestProto req = ClientNamenodeProtocolProtos.RenewLeaseRequestProto.newBuilder().setClientName(clientName).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.renewLease(null, req));
    }

    @Override
    public boolean recoverLease(String src, String clientName) throws IOException {
        ClientNamenodeProtocolProtos.RecoverLeaseRequestProto req = ClientNamenodeProtocolProtos.RecoverLeaseRequestProto.newBuilder().setSrc(src).setClientName(clientName).build();
        return ((ClientNamenodeProtocolProtos.RecoverLeaseResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.recoverLease(null, req))).getResult();
    }

    @Override
    public long[] getStats() throws IOException {
        return PBHelperClient.convert((ClientNamenodeProtocolProtos.GetFsStatsResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getFsStats(null, VOID_GET_FSSTATUS_REQUEST)));
    }

    @Override
    public ReplicatedBlockStats getReplicatedBlockStats() throws IOException {
        return PBHelperClient.convert((ClientNamenodeProtocolProtos.GetFsReplicatedBlockStatsResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getFsReplicatedBlockStats(null, VOID_GET_FS_REPLICATED_BLOCK_STATS_REQUEST)));
    }

    @Override
    public ECBlockGroupStats getECBlockGroupStats() throws IOException {
        return PBHelperClient.convert((ClientNamenodeProtocolProtos.GetFsECBlockGroupStatsResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getFsECBlockGroupStats(null, VOID_GET_FS_ECBLOCKGROUP_STATS_REQUEST)));
    }

    @Override
    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        ClientNamenodeProtocolProtos.GetDatanodeReportRequestProto req = ClientNamenodeProtocolProtos.GetDatanodeReportRequestProto.newBuilder().setType(PBHelperClient.convert(type)).build();
        return PBHelperClient.convert(((ClientNamenodeProtocolProtos.GetDatanodeReportResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getDatanodeReport(null, req))).getDiList());
    }

    @Override
    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
        ClientNamenodeProtocolProtos.GetDatanodeStorageReportRequestProto req = ClientNamenodeProtocolProtos.GetDatanodeStorageReportRequestProto.newBuilder().setType(PBHelperClient.convert(type)).build();
        return PBHelperClient.convertDatanodeStorageReports((List)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getDatanodeStorageReport(null, req).getDatanodeStorageReportsList()));
    }

    @Override
    public long getPreferredBlockSize(String filename) throws IOException {
        ClientNamenodeProtocolProtos.GetPreferredBlockSizeRequestProto req = ClientNamenodeProtocolProtos.GetPreferredBlockSizeRequestProto.newBuilder().setFilename(filename).build();
        return ((ClientNamenodeProtocolProtos.GetPreferredBlockSizeResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getPreferredBlockSize(null, req))).getBsize();
    }

    @Override
    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        ClientNamenodeProtocolProtos.SetSafeModeRequestProto req = ClientNamenodeProtocolProtos.SetSafeModeRequestProto.newBuilder().setAction(PBHelperClient.convert(action)).setChecked(isChecked).build();
        return ((ClientNamenodeProtocolProtos.SetSafeModeResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.setSafeMode(null, req))).getResult();
    }

    @Override
    public boolean saveNamespace(long timeWindow, long txGap) throws IOException {
        ClientNamenodeProtocolProtos.SaveNamespaceRequestProto req = ClientNamenodeProtocolProtos.SaveNamespaceRequestProto.newBuilder().setTimeWindow(timeWindow).setTxGap(txGap).build();
        return ((ClientNamenodeProtocolProtos.SaveNamespaceResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.saveNamespace(null, req))).getSaved();
    }

    @Override
    public long rollEdits() throws IOException {
        ClientNamenodeProtocolProtos.RollEditsResponseProto resp = (ClientNamenodeProtocolProtos.RollEditsResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.rollEdits(null, VOID_ROLLEDITS_REQUEST));
        return resp.getNewSegmentTxId();
    }

    @Override
    public boolean restoreFailedStorage(String arg) throws IOException {
        ClientNamenodeProtocolProtos.RestoreFailedStorageRequestProto req = ClientNamenodeProtocolProtos.RestoreFailedStorageRequestProto.newBuilder().setArg(arg).build();
        return ((ClientNamenodeProtocolProtos.RestoreFailedStorageResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.restoreFailedStorage(null, req))).getResult();
    }

    @Override
    public void refreshNodes() throws IOException {
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.refreshNodes(null, VOID_REFRESH_NODES_REQUEST));
    }

    @Override
    public void finalizeUpgrade() throws IOException {
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.finalizeUpgrade(null, VOID_FINALIZE_UPGRADE_REQUEST));
    }

    @Override
    public boolean upgradeStatus() throws IOException {
        ClientNamenodeProtocolProtos.UpgradeStatusResponseProto proto = (ClientNamenodeProtocolProtos.UpgradeStatusResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.upgradeStatus(null, VOID_UPGRADE_STATUS_REQUEST));
        return proto.getUpgradeFinalized();
    }

    @Override
    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        ClientNamenodeProtocolProtos.RollingUpgradeRequestProto r = ClientNamenodeProtocolProtos.RollingUpgradeRequestProto.newBuilder().setAction(PBHelperClient.convert(action)).build();
        ClientNamenodeProtocolProtos.RollingUpgradeResponseProto proto = (ClientNamenodeProtocolProtos.RollingUpgradeResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.rollingUpgrade(null, r));
        if (proto.hasRollingUpgradeInfo()) {
            return PBHelperClient.convert(proto.getRollingUpgradeInfo());
        }
        return null;
    }

    @Override
    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        ClientNamenodeProtocolProtos.ListCorruptFileBlocksRequestProto.Builder req = ClientNamenodeProtocolProtos.ListCorruptFileBlocksRequestProto.newBuilder().setPath(path);
        if (cookie != null) {
            req.setCookie(cookie);
        }
        return PBHelperClient.convert(((ClientNamenodeProtocolProtos.ListCorruptFileBlocksResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.listCorruptFileBlocks(null, req.build()))).getCorrupt());
    }

    @Override
    public void metaSave(String filename) throws IOException {
        ClientNamenodeProtocolProtos.MetaSaveRequestProto req = ClientNamenodeProtocolProtos.MetaSaveRequestProto.newBuilder().setFilename(filename).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.metaSave(null, req));
    }

    @Override
    public HdfsFileStatus getFileInfo(String src) throws IOException {
        ClientNamenodeProtocolProtos.GetFileInfoRequestProto req = ClientNamenodeProtocolProtos.GetFileInfoRequestProto.newBuilder().setSrc(src).build();
        ClientNamenodeProtocolProtos.GetFileInfoResponseProto res = (ClientNamenodeProtocolProtos.GetFileInfoResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getFileInfo(null, req));
        return res.hasFs() ? PBHelperClient.convert(res.getFs()) : null;
    }

    @Override
    public HdfsLocatedFileStatus getLocatedFileInfo(String src, boolean needBlockToken) throws IOException {
        ClientNamenodeProtocolProtos.GetLocatedFileInfoRequestProto req = ClientNamenodeProtocolProtos.GetLocatedFileInfoRequestProto.newBuilder().setSrc(src).setNeedBlockToken(needBlockToken).build();
        ClientNamenodeProtocolProtos.GetLocatedFileInfoResponseProto res = (ClientNamenodeProtocolProtos.GetLocatedFileInfoResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getLocatedFileInfo(null, req));
        return (HdfsLocatedFileStatus)(res.hasFs() ? PBHelperClient.convert(res.getFs()) : null);
    }

    @Override
    public HdfsFileStatus getFileLinkInfo(String src) throws IOException {
        ClientNamenodeProtocolProtos.GetFileLinkInfoRequestProto req = ClientNamenodeProtocolProtos.GetFileLinkInfoRequestProto.newBuilder().setSrc(src).build();
        ClientNamenodeProtocolProtos.GetFileLinkInfoResponseProto result = (ClientNamenodeProtocolProtos.GetFileLinkInfoResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getFileLinkInfo(null, req));
        return result.hasFs() ? PBHelperClient.convert(result.getFs()) : null;
    }

    @Override
    public ContentSummary getContentSummary(String path) throws IOException {
        ClientNamenodeProtocolProtos.GetContentSummaryRequestProto req = ClientNamenodeProtocolProtos.GetContentSummaryRequestProto.newBuilder().setPath(path).build();
        return PBHelperClient.convert(((ClientNamenodeProtocolProtos.GetContentSummaryResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getContentSummary(null, req))).getSummary());
    }

    @Override
    public void setQuota(String path, long namespaceQuota, long storagespaceQuota, StorageType type) throws IOException {
        ClientNamenodeProtocolProtos.SetQuotaRequestProto.Builder builder = ClientNamenodeProtocolProtos.SetQuotaRequestProto.newBuilder().setPath(path).setNamespaceQuota(namespaceQuota).setStoragespaceQuota(storagespaceQuota);
        if (type != null) {
            builder.setStorageType(PBHelperClient.convertStorageType(type));
        }
        ClientNamenodeProtocolProtos.SetQuotaRequestProto req = builder.build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.setQuota(null, req));
    }

    @Override
    public void fsync(String src, long fileId, String client, long lastBlockLength) throws IOException {
        ClientNamenodeProtocolProtos.FsyncRequestProto req = ClientNamenodeProtocolProtos.FsyncRequestProto.newBuilder().setSrc(src).setClient(client).setLastBlockLength(lastBlockLength).setFileId(fileId).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.fsync(null, req));
    }

    @Override
    public void setTimes(String src, long mtime, long atime) throws IOException {
        ClientNamenodeProtocolProtos.SetTimesRequestProto req = ClientNamenodeProtocolProtos.SetTimesRequestProto.newBuilder().setSrc(src).setMtime(mtime).setAtime(atime).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.setTimes(null, req));
    }

    @Override
    public void createSymlink(String target, String link, FsPermission dirPerm, boolean createParent) throws IOException {
        ClientNamenodeProtocolProtos.CreateSymlinkRequestProto req = ClientNamenodeProtocolProtos.CreateSymlinkRequestProto.newBuilder().setTarget(target).setLink(link).setDirPerm(PBHelperClient.convert(dirPerm)).setCreateParent(createParent).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.createSymlink(null, req));
    }

    @Override
    public String getLinkTarget(String path) throws IOException {
        ClientNamenodeProtocolProtos.GetLinkTargetRequestProto req = ClientNamenodeProtocolProtos.GetLinkTargetRequestProto.newBuilder().setPath(path).build();
        ClientNamenodeProtocolProtos.GetLinkTargetResponseProto rsp = (ClientNamenodeProtocolProtos.GetLinkTargetResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getLinkTarget(null, req));
        return rsp.hasTargetPath() ? rsp.getTargetPath() : null;
    }

    @Override
    public LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        ClientNamenodeProtocolProtos.UpdateBlockForPipelineRequestProto req = ClientNamenodeProtocolProtos.UpdateBlockForPipelineRequestProto.newBuilder().setBlock(PBHelperClient.convert(block)).setClientName(clientName).build();
        return PBHelperClient.convertLocatedBlockProto(((ClientNamenodeProtocolProtos.UpdateBlockForPipelineResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.updateBlockForPipeline(null, req))).getBlock());
    }

    @Override
    public void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] storageIDs) throws IOException {
        ClientNamenodeProtocolProtos.UpdatePipelineRequestProto req = ClientNamenodeProtocolProtos.UpdatePipelineRequestProto.newBuilder().setClientName(clientName).setOldBlock(PBHelperClient.convert(oldBlock)).setNewBlock(PBHelperClient.convert(newBlock)).addAllNewNodes(Arrays.asList(PBHelperClient.convert(newNodes))).addAllStorageIDs(storageIDs == null ? null : Arrays.asList(storageIDs)).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.updatePipeline(null, req));
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        SecurityProtos.GetDelegationTokenRequestProto req = SecurityProtos.GetDelegationTokenRequestProto.newBuilder().setRenewer(renewer == null ? "" : renewer.toString()).build();
        SecurityProtos.GetDelegationTokenResponseProto resp = (SecurityProtos.GetDelegationTokenResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getDelegationToken(null, req));
        return resp.hasToken() ? PBHelperClient.convertDelegationToken(resp.getToken()) : null;
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        SecurityProtos.RenewDelegationTokenRequestProto req = SecurityProtos.RenewDelegationTokenRequestProto.newBuilder().setToken(PBHelperClient.convert(token)).build();
        return ((SecurityProtos.RenewDelegationTokenResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.renewDelegationToken(null, req))).getNewExpiryTime();
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        SecurityProtos.CancelDelegationTokenRequestProto req = SecurityProtos.CancelDelegationTokenRequestProto.newBuilder().setToken(PBHelperClient.convert(token)).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.cancelDelegationToken(null, req));
    }

    @Override
    public void setBalancerBandwidth(long bandwidth) throws IOException {
        ClientNamenodeProtocolProtos.SetBalancerBandwidthRequestProto req = ClientNamenodeProtocolProtos.SetBalancerBandwidthRequestProto.newBuilder().setBandwidth(bandwidth).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.setBalancerBandwidth(null, req));
    }

    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported((Object)this.rpcProxy, ClientNamenodeProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(ClientNamenodeProtocolPB.class), (String)methodName);
    }

    @Override
    public DataEncryptionKey getDataEncryptionKey() throws IOException {
        ClientNamenodeProtocolProtos.GetDataEncryptionKeyResponseProto rsp = (ClientNamenodeProtocolProtos.GetDataEncryptionKeyResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getDataEncryptionKey(null, VOID_GET_DATA_ENCRYPTIONKEY_REQUEST));
        return rsp.hasDataEncryptionKey() ? PBHelperClient.convert(rsp.getDataEncryptionKey()) : null;
    }

    @Override
    public boolean isFileClosed(String src) throws IOException {
        ClientNamenodeProtocolProtos.IsFileClosedRequestProto req = ClientNamenodeProtocolProtos.IsFileClosedRequestProto.newBuilder().setSrc(src).build();
        return ((ClientNamenodeProtocolProtos.IsFileClosedResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.isFileClosed(null, req))).getResult();
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public String createSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        ClientNamenodeProtocolProtos.CreateSnapshotRequestProto.Builder builder = ClientNamenodeProtocolProtos.CreateSnapshotRequestProto.newBuilder().setSnapshotRoot(snapshotRoot);
        if (snapshotName != null) {
            builder.setSnapshotName(snapshotName);
        }
        ClientNamenodeProtocolProtos.CreateSnapshotRequestProto req = builder.build();
        return ((ClientNamenodeProtocolProtos.CreateSnapshotResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.createSnapshot(null, req))).getSnapshotPath();
    }

    @Override
    public void deleteSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        ClientNamenodeProtocolProtos.DeleteSnapshotRequestProto req = ClientNamenodeProtocolProtos.DeleteSnapshotRequestProto.newBuilder().setSnapshotRoot(snapshotRoot).setSnapshotName(snapshotName).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.deleteSnapshot(null, req));
    }

    @Override
    public void allowSnapshot(String snapshotRoot) throws IOException {
        ClientNamenodeProtocolProtos.AllowSnapshotRequestProto req = ClientNamenodeProtocolProtos.AllowSnapshotRequestProto.newBuilder().setSnapshotRoot(snapshotRoot).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.allowSnapshot(null, req));
    }

    @Override
    public void disallowSnapshot(String snapshotRoot) throws IOException {
        ClientNamenodeProtocolProtos.DisallowSnapshotRequestProto req = ClientNamenodeProtocolProtos.DisallowSnapshotRequestProto.newBuilder().setSnapshotRoot(snapshotRoot).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.disallowSnapshot(null, req));
    }

    @Override
    public void renameSnapshot(String snapshotRoot, String snapshotOldName, String snapshotNewName) throws IOException {
        ClientNamenodeProtocolProtos.RenameSnapshotRequestProto req = ClientNamenodeProtocolProtos.RenameSnapshotRequestProto.newBuilder().setSnapshotRoot(snapshotRoot).setSnapshotOldName(snapshotOldName).setSnapshotNewName(snapshotNewName).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.renameSnapshot(null, req));
    }

    @Override
    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        ClientNamenodeProtocolProtos.GetSnapshottableDirListingRequestProto req = ClientNamenodeProtocolProtos.GetSnapshottableDirListingRequestProto.newBuilder().build();
        ClientNamenodeProtocolProtos.GetSnapshottableDirListingResponseProto result = (ClientNamenodeProtocolProtos.GetSnapshottableDirListingResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getSnapshottableDirListing(null, req));
        if (result.hasSnapshottableDirList()) {
            return PBHelperClient.convert(result.getSnapshottableDirList());
        }
        return null;
    }

    @Override
    public SnapshotDiffReport getSnapshotDiffReport(String snapshotRoot, String fromSnapshot, String toSnapshot) throws IOException {
        ClientNamenodeProtocolProtos.GetSnapshotDiffReportRequestProto req = ClientNamenodeProtocolProtos.GetSnapshotDiffReportRequestProto.newBuilder().setSnapshotRoot(snapshotRoot).setFromSnapshot(fromSnapshot).setToSnapshot(toSnapshot).build();
        ClientNamenodeProtocolProtos.GetSnapshotDiffReportResponseProto result = (ClientNamenodeProtocolProtos.GetSnapshotDiffReportResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getSnapshotDiffReport(null, req));
        return PBHelperClient.convert(result.getDiffReport());
    }

    @Override
    public SnapshotDiffReportListing getSnapshotDiffReportListing(String snapshotRoot, String fromSnapshot, String toSnapshot, byte[] startPath, int index) throws IOException {
        ClientNamenodeProtocolProtos.GetSnapshotDiffReportListingRequestProto req = ClientNamenodeProtocolProtos.GetSnapshotDiffReportListingRequestProto.newBuilder().setSnapshotRoot(snapshotRoot).setFromSnapshot(fromSnapshot).setToSnapshot(toSnapshot).setCursor(HdfsProtos.SnapshotDiffReportCursorProto.newBuilder().setStartPath(PBHelperClient.getByteString(startPath)).setIndex(index).build()).build();
        ClientNamenodeProtocolProtos.GetSnapshotDiffReportListingResponseProto result = (ClientNamenodeProtocolProtos.GetSnapshotDiffReportListingResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getSnapshotDiffReportListing(null, req));
        return PBHelperClient.convert(result.getDiffReport());
    }

    @Override
    public long addCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        ClientNamenodeProtocolProtos.AddCacheDirectiveRequestProto.Builder builder = ClientNamenodeProtocolProtos.AddCacheDirectiveRequestProto.newBuilder().setInfo(PBHelperClient.convert(directive));
        if (!flags.isEmpty()) {
            builder.setCacheFlags(PBHelperClient.convertCacheFlags(flags));
        }
        return ((ClientNamenodeProtocolProtos.AddCacheDirectiveResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.addCacheDirective(null, builder.build()))).getId();
    }

    @Override
    public void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        ClientNamenodeProtocolProtos.ModifyCacheDirectiveRequestProto.Builder builder = ClientNamenodeProtocolProtos.ModifyCacheDirectiveRequestProto.newBuilder().setInfo(PBHelperClient.convert(directive));
        if (!flags.isEmpty()) {
            builder.setCacheFlags(PBHelperClient.convertCacheFlags(flags));
        }
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.modifyCacheDirective(null, builder.build()));
    }

    @Override
    public void removeCacheDirective(long id) throws IOException {
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.removeCacheDirective(null, ClientNamenodeProtocolProtos.RemoveCacheDirectiveRequestProto.newBuilder().setId(id).build()));
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> listCacheDirectives(long prevId, CacheDirectiveInfo filter) throws IOException {
        if (filter == null) {
            filter = new CacheDirectiveInfo.Builder().build();
        }
        CacheDirectiveInfo f = filter;
        return new BatchedCacheEntries((ClientNamenodeProtocolProtos.ListCacheDirectivesResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.listCacheDirectives(null, ClientNamenodeProtocolProtos.ListCacheDirectivesRequestProto.newBuilder().setPrevId(prevId).setFilter(PBHelperClient.convert(f)).build())));
    }

    @Override
    public void addCachePool(CachePoolInfo info) throws IOException {
        ClientNamenodeProtocolProtos.AddCachePoolRequestProto.Builder builder = ClientNamenodeProtocolProtos.AddCachePoolRequestProto.newBuilder();
        builder.setInfo(PBHelperClient.convert(info));
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.addCachePool(null, builder.build()));
    }

    @Override
    public void modifyCachePool(CachePoolInfo req) throws IOException {
        ClientNamenodeProtocolProtos.ModifyCachePoolRequestProto.Builder builder = ClientNamenodeProtocolProtos.ModifyCachePoolRequestProto.newBuilder();
        builder.setInfo(PBHelperClient.convert(req));
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.modifyCachePool(null, builder.build()));
    }

    @Override
    public void removeCachePool(String cachePoolName) throws IOException {
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.removeCachePool(null, ClientNamenodeProtocolProtos.RemoveCachePoolRequestProto.newBuilder().setPoolName(cachePoolName).build()));
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        return new BatchedCachePoolEntries((ClientNamenodeProtocolProtos.ListCachePoolsResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.listCachePools(null, ClientNamenodeProtocolProtos.ListCachePoolsRequestProto.newBuilder().setPrevPoolName(prevKey).build())));
    }

    @Override
    public void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        AclProtos.ModifyAclEntriesRequestProto req = AclProtos.ModifyAclEntriesRequestProto.newBuilder().setSrc(src).addAllAclSpec(PBHelperClient.convertAclEntryProto(aclSpec)).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.modifyAclEntries(null, req));
    }

    @Override
    public void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        AclProtos.RemoveAclEntriesRequestProto req = AclProtos.RemoveAclEntriesRequestProto.newBuilder().setSrc(src).addAllAclSpec(PBHelperClient.convertAclEntryProto(aclSpec)).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.removeAclEntries(null, req));
    }

    @Override
    public void removeDefaultAcl(String src) throws IOException {
        AclProtos.RemoveDefaultAclRequestProto req = AclProtos.RemoveDefaultAclRequestProto.newBuilder().setSrc(src).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.removeDefaultAcl(null, req));
    }

    @Override
    public void removeAcl(String src) throws IOException {
        AclProtos.RemoveAclRequestProto req = AclProtos.RemoveAclRequestProto.newBuilder().setSrc(src).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.removeAcl(null, req));
    }

    @Override
    public void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        AclProtos.SetAclRequestProto req = AclProtos.SetAclRequestProto.newBuilder().setSrc(src).addAllAclSpec(PBHelperClient.convertAclEntryProto(aclSpec)).build();
        if (Client.isAsynchronousMode()) {
            ShadedProtobufHelper.ipc(() -> this.rpcProxy.setAcl(null, req));
            this.setAsyncReturnValue();
        } else {
            ShadedProtobufHelper.ipc(() -> this.rpcProxy.setAcl(null, req));
        }
    }

    @Override
    public AclStatus getAclStatus(String src) throws IOException {
        AclProtos.GetAclStatusRequestProto req = AclProtos.GetAclStatusRequestProto.newBuilder().setSrc(src).build();
        try {
            if (Client.isAsynchronousMode()) {
                this.rpcProxy.getAclStatus(null, req);
                final AsyncGet asyncReturnMessage = ProtobufRpcEngine2.getAsyncReturnMessage();
                AsyncGet<AclStatus, Exception> asyncGet = new AsyncGet<AclStatus, Exception>(){

                    public AclStatus get(long timeout, TimeUnit unit) throws Exception {
                        return PBHelperClient.convert((AclProtos.GetAclStatusResponseProto)asyncReturnMessage.get(timeout, unit));
                    }

                    public boolean isDone() {
                        return asyncReturnMessage.isDone();
                    }
                };
                AsyncCallHandler.setLowerLayerAsyncReturn((AsyncGet)asyncGet);
                return null;
            }
            return PBHelperClient.convert(this.rpcProxy.getAclStatus(null, req));
        }
        catch (ServiceException e) {
            throw ShadedProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void createEncryptionZone(String src, String keyName) throws IOException {
        EncryptionZonesProtos.CreateEncryptionZoneRequestProto.Builder builder = EncryptionZonesProtos.CreateEncryptionZoneRequestProto.newBuilder();
        builder.setSrc(src);
        if (keyName != null && !keyName.isEmpty()) {
            builder.setKeyName(keyName);
        }
        EncryptionZonesProtos.CreateEncryptionZoneRequestProto req = builder.build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.createEncryptionZone(null, req));
    }

    @Override
    public EncryptionZone getEZForPath(String src) throws IOException {
        EncryptionZonesProtos.GetEZForPathRequestProto.Builder builder = EncryptionZonesProtos.GetEZForPathRequestProto.newBuilder();
        builder.setSrc(src);
        EncryptionZonesProtos.GetEZForPathRequestProto req = builder.build();
        EncryptionZonesProtos.GetEZForPathResponseProto response = (EncryptionZonesProtos.GetEZForPathResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getEZForPath(null, req));
        if (response.hasZone()) {
            return PBHelperClient.convert(response.getZone());
        }
        return null;
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<EncryptionZone> listEncryptionZones(long id) throws IOException {
        EncryptionZonesProtos.ListEncryptionZonesRequestProto req = EncryptionZonesProtos.ListEncryptionZonesRequestProto.newBuilder().setId(id).build();
        EncryptionZonesProtos.ListEncryptionZonesResponseProto response = (EncryptionZonesProtos.ListEncryptionZonesResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.listEncryptionZones(null, req));
        ArrayList elements = Lists.newArrayListWithCapacity((int)response.getZonesCount());
        for (EncryptionZonesProtos.EncryptionZoneProto p : response.getZonesList()) {
            elements.add(PBHelperClient.convert(p));
        }
        return new BatchedRemoteIterator.BatchedListEntries((List)elements, response.getHasMore());
    }

    @Override
    public void setErasureCodingPolicy(String src, String ecPolicyName) throws IOException {
        ErasureCodingProtos.SetErasureCodingPolicyRequestProto.Builder builder = ErasureCodingProtos.SetErasureCodingPolicyRequestProto.newBuilder();
        builder.setSrc(src);
        if (ecPolicyName != null) {
            builder.setEcPolicyName(ecPolicyName);
        }
        ErasureCodingProtos.SetErasureCodingPolicyRequestProto req = builder.build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.setErasureCodingPolicy(null, req));
    }

    @Override
    public void unsetErasureCodingPolicy(String src) throws IOException {
        ErasureCodingProtos.UnsetErasureCodingPolicyRequestProto.Builder builder = ErasureCodingProtos.UnsetErasureCodingPolicyRequestProto.newBuilder();
        builder.setSrc(src);
        ErasureCodingProtos.UnsetErasureCodingPolicyRequestProto req = builder.build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.unsetErasureCodingPolicy(null, req));
    }

    @Override
    public ECTopologyVerifierResult getECTopologyResultForPolicies(String ... policyNames) throws IOException {
        ErasureCodingProtos.GetECTopologyResultForPoliciesRequestProto.Builder builder = ErasureCodingProtos.GetECTopologyResultForPoliciesRequestProto.newBuilder();
        builder.addAllPolicies(Arrays.asList(policyNames));
        ErasureCodingProtos.GetECTopologyResultForPoliciesRequestProto req = builder.build();
        ErasureCodingProtos.GetECTopologyResultForPoliciesResponseProto response = (ErasureCodingProtos.GetECTopologyResultForPoliciesResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getECTopologyResultForPolicies(null, req));
        return PBHelperClient.convertECTopologyVerifierResultProto(response.getResponse());
    }

    @Override
    public void reencryptEncryptionZone(String zone, HdfsConstants.ReencryptAction action) throws IOException {
        EncryptionZonesProtos.ReencryptEncryptionZoneRequestProto.Builder builder = EncryptionZonesProtos.ReencryptEncryptionZoneRequestProto.newBuilder();
        builder.setZone(zone).setAction(PBHelperClient.convert(action));
        EncryptionZonesProtos.ReencryptEncryptionZoneRequestProto req = builder.build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.reencryptEncryptionZone(null, req));
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<ZoneReencryptionStatus> listReencryptionStatus(long id) throws IOException {
        EncryptionZonesProtos.ListReencryptionStatusRequestProto req = EncryptionZonesProtos.ListReencryptionStatusRequestProto.newBuilder().setId(id).build();
        EncryptionZonesProtos.ListReencryptionStatusResponseProto response = (EncryptionZonesProtos.ListReencryptionStatusResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.listReencryptionStatus(null, req));
        ArrayList elements = Lists.newArrayListWithCapacity((int)response.getStatusesCount());
        for (EncryptionZonesProtos.ZoneReencryptionStatusProto p : response.getStatusesList()) {
            elements.add(PBHelperClient.convert(p));
        }
        return new BatchedRemoteIterator.BatchedListEntries((List)elements, response.getHasMore());
    }

    @Override
    public void setXAttr(String src, XAttr xAttr, EnumSet<XAttrSetFlag> flag) throws IOException {
        XAttrProtos.SetXAttrRequestProto req = XAttrProtos.SetXAttrRequestProto.newBuilder().setSrc(src).setXAttr(PBHelperClient.convertXAttrProto(xAttr)).setFlag(PBHelperClient.convert(flag)).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.setXAttr(null, req));
    }

    @Override
    public List<XAttr> getXAttrs(String src, List<XAttr> xAttrs) throws IOException {
        XAttrProtos.GetXAttrsRequestProto.Builder builder = XAttrProtos.GetXAttrsRequestProto.newBuilder();
        builder.setSrc(src);
        if (xAttrs != null) {
            builder.addAllXAttrs(PBHelperClient.convertXAttrProto(xAttrs));
        }
        XAttrProtos.GetXAttrsRequestProto req = builder.build();
        return PBHelperClient.convert((XAttrProtos.GetXAttrsResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getXAttrs(null, req)));
    }

    @Override
    public List<XAttr> listXAttrs(String src) throws IOException {
        XAttrProtos.ListXAttrsRequestProto.Builder builder = XAttrProtos.ListXAttrsRequestProto.newBuilder();
        builder.setSrc(src);
        XAttrProtos.ListXAttrsRequestProto req = builder.build();
        return PBHelperClient.convert((XAttrProtos.ListXAttrsResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.listXAttrs(null, req)));
    }

    @Override
    public void removeXAttr(String src, XAttr xAttr) throws IOException {
        XAttrProtos.RemoveXAttrRequestProto req = XAttrProtos.RemoveXAttrRequestProto.newBuilder().setSrc(src).setXAttr(PBHelperClient.convertXAttrProto(xAttr)).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.removeXAttr(null, req));
    }

    @Override
    public void checkAccess(String path, FsAction mode) throws IOException {
        ClientNamenodeProtocolProtos.CheckAccessRequestProto req = ClientNamenodeProtocolProtos.CheckAccessRequestProto.newBuilder().setPath(path).setMode(PBHelperClient.convert(mode)).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.checkAccess(null, req));
    }

    @Override
    public void setStoragePolicy(String src, String policyName) throws IOException {
        ClientNamenodeProtocolProtos.SetStoragePolicyRequestProto req = ClientNamenodeProtocolProtos.SetStoragePolicyRequestProto.newBuilder().setSrc(src).setPolicyName(policyName).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.setStoragePolicy(null, req));
    }

    @Override
    public void unsetStoragePolicy(String src) throws IOException {
        ClientNamenodeProtocolProtos.UnsetStoragePolicyRequestProto req = ClientNamenodeProtocolProtos.UnsetStoragePolicyRequestProto.newBuilder().setSrc(src).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.unsetStoragePolicy(null, req));
    }

    @Override
    public BlockStoragePolicy getStoragePolicy(String path) throws IOException {
        ClientNamenodeProtocolProtos.GetStoragePolicyRequestProto request = ClientNamenodeProtocolProtos.GetStoragePolicyRequestProto.newBuilder().setPath(path).build();
        return PBHelperClient.convert(((ClientNamenodeProtocolProtos.GetStoragePolicyResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getStoragePolicy(null, request))).getStoragePolicy());
    }

    @Override
    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        ClientNamenodeProtocolProtos.GetStoragePoliciesResponseProto response = (ClientNamenodeProtocolProtos.GetStoragePoliciesResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getStoragePolicies(null, VOID_GET_STORAGE_POLICIES_REQUEST));
        return PBHelperClient.convertStoragePolicies(response.getPoliciesList());
    }

    @Override
    public long getCurrentEditLogTxid() throws IOException {
        ClientNamenodeProtocolProtos.GetCurrentEditLogTxidRequestProto req = ClientNamenodeProtocolProtos.GetCurrentEditLogTxidRequestProto.getDefaultInstance();
        return ((ClientNamenodeProtocolProtos.GetCurrentEditLogTxidResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getCurrentEditLogTxid(null, req))).getTxid();
    }

    @Override
    public EventBatchList getEditsFromTxid(long txid) throws IOException {
        ClientNamenodeProtocolProtos.GetEditsFromTxidRequestProto req = ClientNamenodeProtocolProtos.GetEditsFromTxidRequestProto.newBuilder().setTxid(txid).build();
        return PBHelperClient.convert((ClientNamenodeProtocolProtos.GetEditsFromTxidResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getEditsFromTxid(null, req)));
    }

    @Override
    public AddErasureCodingPolicyResponse[] addErasureCodingPolicies(ErasureCodingPolicy[] policies) throws IOException {
        List protos = Arrays.stream(policies).map(PBHelperClient::convertErasureCodingPolicy).collect(Collectors.toList());
        ErasureCodingProtos.AddErasureCodingPoliciesRequestProto req = ErasureCodingProtos.AddErasureCodingPoliciesRequestProto.newBuilder().addAllEcPolicies(protos).build();
        ErasureCodingProtos.AddErasureCodingPoliciesResponseProto rep = (ErasureCodingProtos.AddErasureCodingPoliciesResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.addErasureCodingPolicies(null, req));
        AddErasureCodingPolicyResponse[] responses = (AddErasureCodingPolicyResponse[])rep.getResponsesList().stream().map(PBHelperClient::convertAddErasureCodingPolicyResponse).toArray(AddErasureCodingPolicyResponse[]::new);
        return responses;
    }

    @Override
    public void removeErasureCodingPolicy(String ecPolicyName) throws IOException {
        ErasureCodingProtos.RemoveErasureCodingPolicyRequestProto.Builder builder = ErasureCodingProtos.RemoveErasureCodingPolicyRequestProto.newBuilder();
        builder.setEcPolicyName(ecPolicyName);
        ErasureCodingProtos.RemoveErasureCodingPolicyRequestProto req = builder.build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.removeErasureCodingPolicy(null, req));
    }

    @Override
    public void enableErasureCodingPolicy(String ecPolicyName) throws IOException {
        ErasureCodingProtos.EnableErasureCodingPolicyRequestProto.Builder builder = ErasureCodingProtos.EnableErasureCodingPolicyRequestProto.newBuilder();
        builder.setEcPolicyName(ecPolicyName);
        ErasureCodingProtos.EnableErasureCodingPolicyRequestProto req = builder.build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.enableErasureCodingPolicy(null, req));
    }

    @Override
    public void disableErasureCodingPolicy(String ecPolicyName) throws IOException {
        ErasureCodingProtos.DisableErasureCodingPolicyRequestProto.Builder builder = ErasureCodingProtos.DisableErasureCodingPolicyRequestProto.newBuilder();
        builder.setEcPolicyName(ecPolicyName);
        ErasureCodingProtos.DisableErasureCodingPolicyRequestProto req = builder.build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.disableErasureCodingPolicy(null, req));
    }

    @Override
    public ErasureCodingPolicyInfo[] getErasureCodingPolicies() throws IOException {
        ErasureCodingProtos.GetErasureCodingPoliciesResponseProto response = (ErasureCodingProtos.GetErasureCodingPoliciesResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getErasureCodingPolicies(null, VOID_GET_EC_POLICIES_REQUEST));
        ErasureCodingPolicyInfo[] ecPolicies = new ErasureCodingPolicyInfo[response.getEcPoliciesCount()];
        int i = 0;
        for (HdfsProtos.ErasureCodingPolicyProto proto : response.getEcPoliciesList()) {
            ecPolicies[i++] = PBHelperClient.convertErasureCodingPolicyInfo(proto);
        }
        return ecPolicies;
    }

    @Override
    public Map<String, String> getErasureCodingCodecs() throws IOException {
        ErasureCodingProtos.GetErasureCodingCodecsResponseProto response = (ErasureCodingProtos.GetErasureCodingCodecsResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getErasureCodingCodecs(null, VOID_GET_EC_CODEC_REQUEST));
        HashMap<String, String> ecCodecs = new HashMap<String, String>();
        for (ErasureCodingProtos.CodecProto codec : response.getCodecList()) {
            ecCodecs.put(codec.getCodec(), codec.getCoders());
        }
        return ecCodecs;
    }

    @Override
    public ErasureCodingPolicy getErasureCodingPolicy(String src) throws IOException {
        ErasureCodingProtos.GetErasureCodingPolicyRequestProto req = ErasureCodingProtos.GetErasureCodingPolicyRequestProto.newBuilder().setSrc(src).build();
        ErasureCodingProtos.GetErasureCodingPolicyResponseProto response = (ErasureCodingProtos.GetErasureCodingPolicyResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getErasureCodingPolicy(null, req));
        if (response.hasEcPolicy()) {
            return PBHelperClient.convertErasureCodingPolicy(response.getEcPolicy());
        }
        return null;
    }

    @Override
    public QuotaUsage getQuotaUsage(String path) throws IOException {
        ClientNamenodeProtocolProtos.GetQuotaUsageRequestProto req = ClientNamenodeProtocolProtos.GetQuotaUsageRequestProto.newBuilder().setPath(path).build();
        return PBHelperClient.convert(((ClientNamenodeProtocolProtos.GetQuotaUsageResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getQuotaUsage(null, req))).getUsage());
    }

    @Override
    @Deprecated
    public BatchedRemoteIterator.BatchedEntries<OpenFileEntry> listOpenFiles(long prevId) throws IOException {
        return this.listOpenFiles(prevId, EnumSet.of(OpenFilesIterator.OpenFilesType.ALL_OPEN_FILES), "/");
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<OpenFileEntry> listOpenFiles(long prevId, EnumSet<OpenFilesIterator.OpenFilesType> openFilesTypes, String path) throws IOException {
        ClientNamenodeProtocolProtos.ListOpenFilesRequestProto.Builder req = ClientNamenodeProtocolProtos.ListOpenFilesRequestProto.newBuilder().setId(prevId);
        if (openFilesTypes != null) {
            req.addAllTypes(PBHelperClient.convertOpenFileTypes(openFilesTypes));
        }
        req.setPath(path);
        ClientNamenodeProtocolProtos.ListOpenFilesResponseProto response = (ClientNamenodeProtocolProtos.ListOpenFilesResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.listOpenFiles(null, req.build()));
        ArrayList openFileEntries = Lists.newArrayListWithCapacity((int)response.getEntriesCount());
        for (ClientNamenodeProtocolProtos.OpenFilesBatchResponseProto p : response.getEntriesList()) {
            openFileEntries.add(PBHelperClient.convert(p));
        }
        return new BatchedRemoteIterator.BatchedListEntries((List)openFileEntries, response.getHasMore());
    }

    @Override
    public void msync() throws IOException {
        ClientNamenodeProtocolProtos.MsyncRequestProto.Builder req = ClientNamenodeProtocolProtos.MsyncRequestProto.newBuilder();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.msync(null, req.build()));
    }

    @Override
    public void satisfyStoragePolicy(String src) throws IOException {
        ClientNamenodeProtocolProtos.SatisfyStoragePolicyRequestProto req = ClientNamenodeProtocolProtos.SatisfyStoragePolicyRequestProto.newBuilder().setSrc(src).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.satisfyStoragePolicy(null, req));
    }

    @Override
    public DatanodeInfo[] getSlowDatanodeReport() throws IOException {
        ClientNamenodeProtocolProtos.GetSlowDatanodeReportRequestProto req = ClientNamenodeProtocolProtos.GetSlowDatanodeReportRequestProto.newBuilder().build();
        return PBHelperClient.convert(((ClientNamenodeProtocolProtos.GetSlowDatanodeReportResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getSlowDatanodeReport(null, req))).getDatanodeInfoProtoList());
    }

    @Override
    public HAServiceProtocol.HAServiceState getHAServiceState() throws IOException {
        ClientNamenodeProtocolProtos.HAServiceStateRequestProto req = ClientNamenodeProtocolProtos.HAServiceStateRequestProto.newBuilder().build();
        HAServiceProtocolProtos.HAServiceStateProto res = ((ClientNamenodeProtocolProtos.HAServiceStateResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getHAServiceState(null, req))).getState();
        switch (res) {
            case ACTIVE: {
                return HAServiceProtocol.HAServiceState.ACTIVE;
            }
            case STANDBY: {
                return HAServiceProtocol.HAServiceState.STANDBY;
            }
            case OBSERVER: {
                return HAServiceProtocol.HAServiceState.OBSERVER;
            }
        }
        return HAServiceProtocol.HAServiceState.INITIALIZING;
    }

    private static class BatchedCachePoolEntries
    implements BatchedRemoteIterator.BatchedEntries<CachePoolEntry> {
        private final ClientNamenodeProtocolProtos.ListCachePoolsResponseProto proto;

        public BatchedCachePoolEntries(ClientNamenodeProtocolProtos.ListCachePoolsResponseProto proto) {
            this.proto = proto;
        }

        public CachePoolEntry get(int i) {
            ClientNamenodeProtocolProtos.CachePoolEntryProto elem = this.proto.getEntries(i);
            return PBHelperClient.convert(elem);
        }

        public int size() {
            return this.proto.getEntriesCount();
        }

        public boolean hasMore() {
            return this.proto.getHasMore();
        }
    }

    private static class BatchedCacheEntries
    implements BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> {
        private final ClientNamenodeProtocolProtos.ListCacheDirectivesResponseProto response;

        BatchedCacheEntries(ClientNamenodeProtocolProtos.ListCacheDirectivesResponseProto response) {
            this.response = response;
        }

        public CacheDirectiveEntry get(int i) {
            return PBHelperClient.convert(this.response.getElements(i));
        }

        public int size() {
            return this.response.getElementsCount();
        }

        public boolean hasMore() {
            return this.response.getHasMore();
        }
    }
}

