/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.admin.kadmin.remote;

import org.apache.kerby.KOption;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminConfig;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminOption;

public class AdminSetting {
    private final KOptions commonOptions;
    private final AdminConfig adminConfig;

    public AdminSetting(KOptions commonOptions, AdminConfig config) {
        this.commonOptions = commonOptions;
        this.adminConfig = config;
    }

    public AdminSetting(AdminConfig config) {
        this.commonOptions = new KOptions();
        this.adminConfig = config;
    }

    public AdminConfig getAdminConfig() {
        return this.adminConfig;
    }

    public String getKdcRealm() {
        String kdcRealm = this.commonOptions.getStringOption((KOption)AdminOption.ADMIN_REALM);
        if (kdcRealm == null || kdcRealm.isEmpty()) {
            kdcRealm = this.adminConfig.getAdminRealm();
        }
        return kdcRealm;
    }

    public String getKdcHost() {
        String kdcHost = this.commonOptions.getStringOption((KOption)AdminOption.ADMIN_HOST);
        if (kdcHost == null) {
            return this.adminConfig.getAdminHost();
        }
        return kdcHost;
    }

    public int checkGetKdcTcpPort() throws KrbException {
        if (this.allowTcp()) {
            int kdcPort = this.getKdcTcpPort();
            if (kdcPort < 1) {
                throw new KrbException("KDC tcp port isn't set or configured");
            }
            return kdcPort;
        }
        return -1;
    }

    public int checkGetKdcUdpPort() throws KrbException {
        if (this.allowUdp()) {
            int kdcPort = this.getKdcUdpPort();
            if (kdcPort < 1) {
                throw new KrbException("KDC udp port isn't set or configured");
            }
            return kdcPort;
        }
        return -1;
    }

    public int getKdcTcpPort() {
        int tcpPort = this.commonOptions.getIntegerOption((KOption)AdminOption.ADMIN_TCP_PORT);
        if (tcpPort > 0) {
            return tcpPort;
        }
        return this.adminConfig.getAdminTcpPort();
    }

    public boolean allowUdp() {
        return this.commonOptions.getBooleanOption((KOption)AdminOption.ALLOW_UDP, Boolean.valueOf(this.adminConfig.allowUdp()));
    }

    public boolean allowTcp() {
        return this.commonOptions.getBooleanOption((KOption)AdminOption.ALLOW_TCP, Boolean.valueOf(this.adminConfig.allowTcp()));
    }

    public int getKdcUdpPort() {
        int udpPort = this.commonOptions.getIntegerOption((KOption)AdminOption.ADMIN_UDP_PORT);
        if (udpPort > 0) {
            return udpPort;
        }
        return this.adminConfig.getAdminUdpPort();
    }

    public int getTimeout() {
        int timeout = this.commonOptions.getIntegerOption((KOption)AdminOption.CONN_TIMEOUT);
        if (timeout > 0) {
            return timeout;
        }
        return 1000;
    }
}

